/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.energy;

import javax.annotation.Nonnull;
import lehjr.numina.common.base.NuminaObjects;
import lehjr.numina.common.energy.BlackList;
import lehjr.numina.common.item.ItemUtils;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class ElectricItemUtils {
    public static double getPlayerEnergy(LivingEntity entity) {
        double avail = 0.0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            avail += (double)ElectricItemUtils.getItemEnergy(ItemUtils.getItemFromEntitySlot(entity, slot));
        }
        return avail;
    }

    public static double getMaxPlayerEnergy(LivingEntity entity) {
        double avail = 0.0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            avail += (double)ElectricItemUtils.getMaxItemEnergy(ItemUtils.getItemFromEntitySlot(entity, slot));
        }
        return avail;
    }

    @Deprecated
    public static double drainPlayerEnergy(LivingEntity entity, double drainAmount) {
        return ElectricItemUtils.drainPlayerEnergy(entity, (int)drainAmount, false);
    }

    public static double drainPlayerEnergy(LivingEntity entity, double drainAmount, boolean simulate) {
        double drainleft = drainAmount;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_9236_().f_46443_ || player.m_150110_().f_35937_) {
                return drainAmount;
            }
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (drainleft <= 0.0) break;
                ItemStack stack = ItemUtils.getItemFromEntitySlot(entity, slot);
                drainleft -= (double)ElectricItemUtils.drainItem(stack, (int)drainleft, simulate);
            }
            if (!simulate && drainAmount - drainleft > 0.0) {
                player.m_150109_().m_6596_();
            }
        }
        return drainAmount - drainleft;
    }

    @Deprecated
    public static double givePlayerEnergy(LivingEntity entity, int rfToGive) {
        return ElectricItemUtils.givePlayerEnergy(entity, rfToGive, false);
    }

    public static double givePlayerEnergy(LivingEntity entity, double rfToGive, boolean simulate) {
        double rfLeft = rfToGive;
        if (entity instanceof Player) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (!(rfLeft > 0.0)) break;
                ItemStack stack = ItemUtils.getItemFromEntitySlot(entity, slot);
                rfLeft -= (double)ElectricItemUtils.chargeItem(stack, (int)rfLeft, simulate);
            }
            if (rfLeft > 0.0) {
                Player player = (Player)entity;
                for (int i = 0; i < ((Player)entity).m_150109_().m_6643_() && rfLeft > 0.0; rfLeft -= (double)ElectricItemUtils.chargeItem(player.m_150109_().m_8020_(i), (int)rfLeft, simulate), ++i) {
                }
                if (rfToGive - rfLeft > 0.0) {
                    player.m_150109_().m_6596_();
                }
            }
        }
        return rfToGive - rfLeft;
    }

    public static int drainItem(@Nonnull ItemStack itemStack, double drainAmount, boolean simulate) {
        if (BlackList.blacklistModIds.contains(ItemUtils.getRegistryName(itemStack).m_135827_())) {
            return 0;
        }
        return itemStack.getCapability(ForgeCapabilities.ENERGY).filter(iEnergyStorage -> (double)iEnergyStorage.getMaxEnergyStored() >= ElectricItemUtils.getMaxEnergyForComparison()).map(energyHandler -> energyHandler.extractEnergy((int)drainAmount, simulate)).orElse(0);
    }

    public static int getItemEnergy(@Nonnull ItemStack itemStack) {
        return itemStack.getCapability(ForgeCapabilities.ENERGY).filter(iEnergyStorage -> (double)iEnergyStorage.getMaxEnergyStored() >= ElectricItemUtils.getMaxEnergyForComparison()).map(energyHandler -> energyHandler.getEnergyStored()).orElse(0);
    }

    public static int getMaxItemEnergy(@Nonnull ItemStack itemStack) {
        return itemStack.getCapability(ForgeCapabilities.ENERGY).filter(iEnergyStorage -> (double)iEnergyStorage.getMaxEnergyStored() >= ElectricItemUtils.getMaxEnergyForComparison()).map(energyHandler -> energyHandler.getMaxEnergyStored()).orElse(0);
    }

    public static int chargeItem(@Nonnull ItemStack itemStack, double chargeAmount, boolean simulate) {
        return itemStack.getCapability(ForgeCapabilities.ENERGY).map(energyHandler -> energyHandler.receiveEnergy((int)chargeAmount, simulate)).orElse(0);
    }

    static double getMaxEnergyForComparison() {
        return 0.8 * (double)new ItemStack((ItemLike)NuminaObjects.BASIC_BATTERY.get()).getCapability(ForgeCapabilities.ENERGY).map(energyHandler -> energyHandler.getMaxEnergyStored()).orElse(0).intValue();
    }
}

