/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.network.packets.serverbound;

import java.util.function.Supplier;
import lehjr.numina.common.capabilities.NuminaCapabilities;
import lehjr.numina.common.item.ItemUtils;
import lehjr.numina.common.network.NuminaPackets;
import lehjr.numina.common.network.packets.clientbound.CosmeticInfoPacketClientBound;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record CosmeticInfoPacketServerBound(EquipmentSlot slotType, String tagName, CompoundTag tagData) {
    public static void encode(CosmeticInfoPacketServerBound msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130068_((Enum)msg.slotType);
        packetBuffer.m_130070_(msg.tagName);
        packetBuffer.m_130079_(msg.tagData);
    }

    public static CosmeticInfoPacketServerBound decode(FriendlyByteBuf packetBuffer) {
        return new CosmeticInfoPacketServerBound((EquipmentSlot)packetBuffer.m_130066_(EquipmentSlot.class), packetBuffer.m_130136_(500), packetBuffer.m_130260_());
    }

    public static void sendToClient(ServerPlayer entity, EquipmentSlot slotType, String tagName, CompoundTag tagData) {
        NuminaPackets.CHANNEL_INSTANCE.send(PacketDistributor.PLAYER.with(() -> entity), (Object)new CosmeticInfoPacketClientBound(slotType, tagName, tagData));
    }

    public static class Handler {
        public static void handle(CosmeticInfoPacketServerBound message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                EquipmentSlot slotType = message.slotType;
                String tagName = message.tagName;
                CompoundTag tagData = message.tagData;
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null) {
                    ItemUtils.getItemFromEntitySlot((LivingEntity)player, slotType).getCapability(NuminaCapabilities.RENDER).ifPresent(render -> render.setRenderTag(tagData, tagName));
                    CosmeticInfoPacketServerBound.sendToClient(player, slotType, tagName, tagData);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

