/*
 * Decompiled with CFR 0.152.
 */
package lehjr.numina.common.network.packets.serverbound;

import java.util.function.Supplier;
import lehjr.numina.common.capabilities.NuminaCapabilities;
import lehjr.numina.common.math.MathUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public record PlayerUpdatePacketServerBound(byte data) {
    public static void encode(PlayerUpdatePacketServerBound msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeByte((int)msg.data);
    }

    public static PlayerUpdatePacketServerBound decode(FriendlyByteBuf packetBuffer) {
        return new PlayerUpdatePacketServerBound(packetBuffer.readByte());
    }

    public static void handle(PlayerUpdatePacketServerBound message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        ctx.get().enqueueWork(() -> player.getCapability(NuminaCapabilities.PLAYER_KEYSTATES).ifPresent(playerCap -> {
            boolean[] boolArray = MathUtils.byteToBooleanArray(message.data);
            playerCap.setForwardKeyState(boolArray[0]);
            playerCap.setReverseKeyState(boolArray[1]);
            playerCap.setLeftStrafeKeyState(boolArray[2]);
            playerCap.setRightStrafeKeyState(boolArray[3]);
            playerCap.setDownKeyState(boolArray[4]);
            playerCap.setJumpKeyState(boolArray[5]);
        }));
        ctx.get().setPacketHandled(true);
    }
}

