/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.module;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.block.ZetaFlammableBlock;
import org.violetmoon.zeta.block.ZetaFlammablePillarBlock;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZLoadComplete;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.Hint;

@ZetaLoadModule(category="building")
public class CompressedBlocksModule
extends ZetaModule {
    @Config(name="Charcoal Block and Blaze Lantern Stay On Fire Forever", flag="compressed_blocks_burn_forever")
    public static boolean burnsForever = true;
    @Config(name="Charcoal Block Fuel Time")
    @Config.Min(value=0.0)
    public static int charcoalBlockFuelTime = 16000;
    @Config(name="Blaze Lantern Fuel Time")
    @Config.Min(value=0.0)
    public static int blazeLanternFuelTime = 24000;
    @Config(name="Stick Block Fuel Time")
    @Config.Min(value=0.0)
    public static int stickBlockFuelTime = 900;
    @Config(flag="charcoal_block")
    public static boolean enableCharcoalBlock = true;
    @Config(flag="sugar_cane_block")
    public static boolean enableSugarCaneBlock = true;
    @Config(flag="cactus_block")
    public static boolean enableCactusBlock = true;
    @Config(flag="chorus_fruit_block")
    public static boolean enableChorusFruitBlock = true;
    @Config(flag="stick_block")
    public static boolean enableStickBlock = true;
    @Config(flag="apple_crate")
    public static boolean enableAppleCrate = true;
    @Config(flag="golden_apple_crate")
    public static boolean enableGoldenAppleCrate = true;
    @Config(flag="potato_crate")
    public static boolean enablePotatoCrate = true;
    @Config(flag="carrot_crate")
    public static boolean enableCarrotCrate = true;
    @Config(flag="golden_carrot_crate")
    public static boolean enableGoldenCarrotCrate = true;
    @Config(flag="beetroot_crate")
    public static boolean enableBeetrootCrate = true;
    @Config(flag="cocoa_beans_sack")
    public static boolean enableCocoaBeanSack = true;
    @Config(flag="nether_wart_sack")
    public static boolean enableNetherWartSack = true;
    @Config(flag="gunpowder_sack")
    public static boolean enableGunpowderSack = true;
    @Config(flag="berry_sack")
    public static boolean enableBerrySack = true;
    @Config(flag="glowberry_sack")
    public static boolean enableGlowBerrySack = true;
    @Config(flag="blaze_lantern")
    public static boolean enableBlazeLantern = true;
    @Config(flag="bonded_leather")
    public static boolean enableBondedLeather = true;
    @Config(flag="bonded_rabbit_hide")
    public static boolean enableBondedRabbitHide = true;
    @Hint(value="compressed_blocks_burn_forever")
    public static Block charcoal_block;
    @Hint(value="compressed_blocks_burn_forever")
    public static Block blaze_lantern;
    @Hint(value="golden_apple_crate")
    public static Block golden_apple_crate;
    public static Block stick_block;
    private final List<Block> compostable = Lists.newArrayList();

    @LoadEvent
    public final void register(ZRegister event) {
        charcoal_block = new ZetaBlock("charcoal_block", (ZetaModule)this, BlockBehaviour.Properties.m_284310_().m_280658_(NoteBlockInstrument.BASEDRUM).m_284180_(MapColor.f_283927_).m_60999_().m_60913_(5.0f, 10.0f).m_60918_(SoundType.f_56742_)).setCondition(() -> enableCharcoalBlock).setCreativeTab(CreativeModeTabs.f_256788_, (ItemLike)Blocks.f_50353_, false);
        this.pillar("sugar_cane", MapColor.f_283916_, true, () -> enableSugarCaneBlock, 200);
        this.pillar("cactus", MapColor.f_283784_, true, () -> enableCactusBlock, 50);
        this.pillar("chorus_fruit", MapColor.f_283889_, false, () -> enableChorusFruitBlock, 10);
        stick_block = this.pillar("stick", MapColor.f_283825_, false, () -> enableStickBlock, 300);
        golden_apple_crate = this.crate("golden_apple", MapColor.f_283757_, false, () -> enableGoldenAppleCrate);
        this.crate("apple", MapColor.f_283913_, true, () -> enableAppleCrate);
        this.crate("potato", MapColor.f_283750_, true, () -> enablePotatoCrate);
        this.crate("carrot", MapColor.f_283895_, true, () -> enableCarrotCrate);
        this.crate("golden_carrot", MapColor.f_283757_, false, () -> enableGoldenCarrotCrate);
        this.crate("beetroot", MapColor.f_283913_, true, () -> enableBeetrootCrate);
        this.sack("cocoa_beans", MapColor.f_283748_, true, () -> enableCocoaBeanSack);
        this.sack("nether_wart", MapColor.f_283913_, true, () -> enableNetherWartSack);
        this.sack("gunpowder", MapColor.f_283818_, false, () -> enableGunpowderSack);
        this.sack("berry", MapColor.f_283913_, true, () -> enableBerrySack);
        this.sack("glowberry", MapColor.f_283832_, 14, true, () -> enableGlowBerrySack);
        blaze_lantern = new ZetaBlock("blaze_lantern", (ZetaModule)this, BlockBehaviour.Properties.m_284310_().m_284268_(DyeColor.YELLOW).m_60978_(0.3f).m_60918_(SoundType.f_56744_).m_60953_(b -> 15)).setCondition(() -> enableBlazeLantern).setCreativeTab(CreativeModeTabs.f_256788_, (ItemLike)Blocks.f_50134_, true);
        new ZetaBlock("bonded_leather", (ZetaModule)this, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283750_).m_278183_().m_60978_(0.4f).m_60918_(SoundType.f_56745_)).setCondition(() -> enableBondedLeather).setCreativeTab(CreativeModeTabs.f_256788_);
        new ZetaBlock("bonded_rabbit_hide", (ZetaModule)this, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283919_).m_278183_().m_60978_(0.4f).m_60918_(SoundType.f_56745_)).setCondition(() -> enableBondedRabbitHide).setCreativeTab(CreativeModeTabs.f_256788_);
    }

    @LoadEvent
    public void loadComplete(ZLoadComplete event) {
        event.enqueueWork(() -> {
            for (Block block : this.compostable) {
                if (block.m_5456_() == null) continue;
                ComposterBlock.f_51914_.put((Object)block.m_5456_(), 1.0f);
            }
        });
        Quark.ZETA.fuel.addFuel(stick_block, stickBlockFuelTime);
        Quark.ZETA.fuel.addFuel(charcoal_block, charcoalBlockFuelTime);
        Quark.ZETA.fuel.addFuel(blaze_lantern, blazeLanternFuelTime);
    }

    private Block pillar(String name, MapColor color, boolean compost, BooleanSupplier cond, int flammability) {
        Block block = new ZetaFlammablePillarBlock(name + "_block", (ZetaModule)this, flammability, BlockBehaviour.Properties.m_284310_().m_284180_(color).m_278183_().m_60978_(0.5f).m_60918_(SoundType.f_56736_)).setCondition(cond).setCreativeTab(CreativeModeTabs.f_256788_);
        if (compost) {
            this.compostable.add(block);
        }
        return block;
    }

    private Block crate(String name, MapColor color, boolean compost, BooleanSupplier cond) {
        Block block = new ZetaFlammableBlock(name + "_crate", (ZetaModule)this, 150, BlockBehaviour.Properties.m_284310_().m_284180_(color).m_278183_().m_60978_(1.5f).m_60918_(SoundType.f_56736_)).setCondition(cond).setCreativeTab(CreativeModeTabs.f_256788_);
        if (compost) {
            this.compostable.add(block);
        }
        return block;
    }

    private Block sack(String name, MapColor color, boolean compost, BooleanSupplier cond) {
        return this.sack(name, color, 0, compost, cond);
    }

    private Block sack(String name, MapColor color, int light, boolean compost, BooleanSupplier cond) {
        Block block = new ZetaFlammableBlock(name + "_sack", (ZetaModule)this, 150, BlockBehaviour.Properties.m_284310_().m_284180_(color).m_278183_().m_60978_(0.5f).m_60953_(s -> light).m_60918_(SoundType.f_56745_)).setCondition(cond).setCreativeTab(CreativeModeTabs.f_256788_);
        if (compost) {
            this.compostable.add(block);
        }
        return block;
    }
}

