/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.NotNull;

public class ConductorEntityModel<T extends ConductorEntity>
extends HumanoidModel<T>
implements ArmedModel,
HeadedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Railways.asResource("conductor"), "main");

    public ConductorEntityModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition hat = partdefinition.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171423_((float)0.0f, (float)10.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(50, 0).m_171488_(0.0f, -2.0f, -2.0f, 3.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)12.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(34, 0).m_171488_(-3.0f, -2.0f, -2.0f, 3.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)12.0f, (float)0.0f));
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(-4.0f, -9.0f, -3.0f, 8.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 29).m_171488_(-3.0f, -4.0f, -2.0f, 6.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(34, 15).m_171488_(-1.5f, 0.0f, -2.0f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)19.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(50, 15).m_171488_(-1.5f, 0.0f, -2.0f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)19.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    private float quadraticArmUpdate(float limbSwing) {
        return limbSwing;
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float swimAmount;
        boolean fallFlying = ((ConductorEntity)((Object)entity)).visualBaseEntity != null && ((ConductorEntity)((Object)entity)).visualBaseEntity.m_21256_() > 4;
        boolean visuallySwimming = ((ConductorEntity)((Object)entity)).visualBaseEntity != null && ((ConductorEntity)((Object)entity)).visualBaseEntity.m_6067_();
        float f = swimAmount = ((ConductorEntity)((Object)entity)).visualBaseModel != null ? ((ConductorEntity)((Object)entity)).visualBaseModel.f_102818_ : this.f_102818_;
        this.f_102808_.f_104203_ = fallFlying ? -0.7853982f : (swimAmount > 0.0f ? (visuallySwimming ? this.m_102835_(swimAmount, this.f_102808_.f_104203_, -0.7853982f) : this.m_102835_(swimAmount, this.f_102808_.f_104203_, headPitch * ((float)Math.PI / 180))) : headPitch * ((float)Math.PI / 180));
        this.f_102808_.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.f_102809_.f_104203_ = (float)((double)this.f_102808_.f_104203_ + -0.17453292519943295);
        this.f_102809_.f_104204_ = this.f_102808_.f_104204_;
        float amt = -1.6f;
        this.f_102809_.f_104200_ = (float)(Math.cos(this.f_102808_.f_104203_) * (double)amt * Math.sin(this.f_102808_.f_104204_));
        this.f_102809_.f_104202_ = (float)(Math.cos(this.f_102808_.f_104203_) * (double)amt * Math.cos(this.f_102808_.f_104204_));
        this.f_102809_.f_104201_ = (((ConductorEntity)((Object)entity)).visualBaseModel != null && ((ConductorEntity)((Object)entity)).visualBaseModel.f_102817_ ? 14.2f : 10.0f) - (float)(Math.sin(this.f_102808_.f_104203_) * (double)amt);
        this.f_102811_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f * 2.0f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.f_102812_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f * 2.0f)) * 2.0f * limbSwingAmount * 0.5f;
        this.f_102811_.f_104205_ = 0.0f;
        this.f_102812_.f_104205_ = 0.0f;
        this.f_102813_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f * 3.0f)) * 1.4f * limbSwingAmount;
        this.f_102814_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f * 3.0f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.f_102813_.f_104204_ = 0.0f;
        this.f_102814_.f_104204_ = 0.0f;
        this.f_102813_.f_104205_ = 0.0f;
        this.f_102814_.f_104205_ = 0.0f;
        if (this.f_102609_) {
            this.f_102811_.f_104203_ += -1.5707964f;
            this.f_102812_.f_104203_ += -1.5707964f;
            this.f_102813_.f_104203_ = -1.4137167f;
            this.f_102813_.f_104204_ = -0.15707964f;
            this.f_102813_.f_104205_ = 0.07853982f;
            this.f_102814_.f_104203_ = -1.4137167f;
            this.f_102814_.f_104204_ = 0.15707964f;
            this.f_102814_.f_104205_ = -0.07853982f;
        }
        this.f_102811_.f_104204_ = 0.0f;
        this.f_102812_.f_104204_ = 0.0f;
        if (((ConductorEntity)((Object)entity)).visualBaseModel != null && ((ConductorEntity)((Object)entity)).visualBaseModel.f_102817_) {
            this.f_102810_.f_104203_ = 0.5f;
            this.f_102811_.f_104203_ += 0.4f;
            this.f_102812_.f_104203_ += 0.4f;
            this.f_102813_.f_104202_ = 3.9f;
            this.f_102814_.f_104202_ = 3.9f;
            this.f_102813_.f_104201_ = 19.2f;
            this.f_102814_.f_104201_ = 19.2f;
            this.f_102808_.f_104201_ = 14.2f;
            this.f_102810_.f_104202_ = 4.0f;
            this.f_102810_.f_104201_ = 20.2f;
            this.f_102812_.f_104201_ = 15.2f;
            this.f_102811_.f_104201_ = 15.2f;
        } else {
            this.f_102810_.f_104203_ = 0.0f;
            this.f_102813_.f_104202_ = 0.0f;
            this.f_102814_.f_104202_ = 0.0f;
            this.f_102813_.f_104201_ = 19.0f;
            this.f_102814_.f_104201_ = 19.0f;
            this.f_102808_.f_104201_ = 10.0f;
            this.f_102810_.f_104202_ = 0.0f;
            this.f_102810_.f_104201_ = 19.0f;
            this.f_102812_.f_104201_ = 12.0f;
            this.f_102811_.f_104201_ = 12.0f;
        }
        if (swimAmount > 0.0f) {
            float g = limbSwing % 26.0f;
            float h = swimAmount;
            float i = swimAmount;
            if (g < 14.0f) {
                this.f_102812_.f_104203_ = this.m_102835_(i, this.f_102812_.f_104203_, 0.0f);
                this.f_102811_.f_104203_ = Mth.m_14179_((float)h, (float)this.f_102811_.f_104203_, (float)0.0f);
                this.f_102812_.f_104204_ = this.m_102835_(i, this.f_102812_.f_104204_, (float)Math.PI);
                this.f_102811_.f_104204_ = Mth.m_14179_((float)h, (float)this.f_102811_.f_104204_, (float)((float)Math.PI));
                this.f_102812_.f_104205_ = this.m_102835_(i, this.f_102812_.f_104205_, (float)Math.PI + 1.8707964f * this.quadraticArmUpdate(g) / this.quadraticArmUpdate(14.0f));
                this.f_102811_.f_104205_ = Mth.m_14179_((float)h, (float)this.f_102811_.f_104205_, (float)((float)Math.PI - 1.8707964f * this.quadraticArmUpdate(g) / this.quadraticArmUpdate(14.0f)));
            } else if (g >= 14.0f && g < 22.0f) {
                float j = (g - 14.0f) / 8.0f;
                this.f_102812_.f_104203_ = this.m_102835_(i, this.f_102812_.f_104203_, 1.5707964f * j);
                this.f_102811_.f_104203_ = Mth.m_14179_((float)h, (float)this.f_102811_.f_104203_, (float)(1.5707964f * j));
                this.f_102812_.f_104204_ = this.m_102835_(i, this.f_102812_.f_104204_, (float)Math.PI);
                this.f_102811_.f_104204_ = Mth.m_14179_((float)h, (float)this.f_102811_.f_104204_, (float)((float)Math.PI));
                this.f_102812_.f_104205_ = this.m_102835_(i, this.f_102812_.f_104205_, 5.012389f - 1.8707964f * j);
                this.f_102811_.f_104205_ = Mth.m_14179_((float)h, (float)this.f_102811_.f_104205_, (float)(1.2707963f + 1.8707964f * j));
            } else if (g >= 22.0f && g < 26.0f) {
                float j = (g - 22.0f) / 4.0f;
                this.f_102812_.f_104203_ = this.m_102835_(i, this.f_102812_.f_104203_, 1.5707964f - 1.5707964f * j);
                this.f_102811_.f_104203_ = Mth.m_14179_((float)h, (float)this.f_102811_.f_104203_, (float)(1.5707964f - 1.5707964f * j));
                this.f_102812_.f_104204_ = this.m_102835_(i, this.f_102812_.f_104204_, (float)Math.PI);
                this.f_102811_.f_104204_ = Mth.m_14179_((float)h, (float)this.f_102811_.f_104204_, (float)((float)Math.PI));
                this.f_102812_.f_104205_ = this.m_102835_(i, this.f_102812_.f_104205_, (float)Math.PI);
                this.f_102811_.f_104205_ = Mth.m_14179_((float)h, (float)this.f_102811_.f_104205_, (float)((float)Math.PI));
            }
            this.f_102814_.f_104203_ = Mth.m_14179_((float)swimAmount, (float)this.f_102814_.f_104203_, (float)(0.3f * Mth.m_14089_((float)(limbSwing * 0.33333334f + (float)Math.PI))));
            this.f_102813_.f_104203_ = Mth.m_14179_((float)swimAmount, (float)this.f_102813_.f_104203_, (float)(0.3f * Mth.m_14089_((float)(limbSwing * 0.33333334f))));
        }
    }

    public void m_6002_(@NotNull HumanoidArm arm, @NotNull PoseStack stack) {
        (arm == HumanoidArm.LEFT ? this.f_102812_ : this.f_102811_).m_104299_(stack);
    }

    @NotNull
    public ModelPart m_5585_() {
        return this.f_102808_;
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.f_102808_.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.f_102810_.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.f_102811_.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.f_102812_.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.f_102813_.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.f_102814_.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

