/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import tcintegrations.common.capabilities.CapabilityRegistry;
import tcintegrations.network.IData;

public class BotaniaSetData
implements IData {
    private final boolean terrestrial;
    private final boolean greatFairy;
    private final boolean alfheim;

    public BotaniaSetData(boolean terrestrial, boolean greatFairy, boolean alfheim) {
        this.terrestrial = terrestrial;
        this.greatFairy = greatFairy;
        this.alfheim = alfheim;
    }

    public BotaniaSetData(FriendlyByteBuf buf) {
        this.terrestrial = buf.readBoolean();
        this.greatFairy = buf.readBoolean();
        this.alfheim = buf.readBoolean();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.terrestrial);
        buf.writeBoolean(this.greatFairy);
        buf.writeBoolean(this.alfheim);
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> Minecraft.m_91087_().f_91074_.getCapability(CapabilityRegistry.BOTANIA_SET_CAPABILITY).ifPresent(data -> {
                data.setTerrestrial(this.terrestrial);
                data.setGreatFairy(this.greatFairy);
                data.setAlfheim(this.alfheim);
            }));
        }
    }
}

