/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.compat;

import ht.treechop.api.IStrippableBlock;
import ht.treechop.api.ITreeBlock;
import ht.treechop.api.TreeChopAPI;
import ht.treechop.api.TreeData;
import ht.treechop.api.TreeDetectorBuilder;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.config.Lazy;
import ht.treechop.common.util.BlockNeighbors;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeConfigSpec;

public class HugeMushroomHandler
implements IStrippableBlock,
ITreeBlock {
    private static ITreeBlock detectionHandler;
    private static final Lazy<Set<Block>> logs;
    private static final Lazy<Set<Block>> leaves;

    public static void register(TreeChopAPI api) {
        detectionHandler = new TreeDetectorBuilder().logs(HugeMushroomHandler::isLog).leaves(HugeMushroomHandler::isLeaves).leavesScanner((level, pos) -> BlockNeighbors.ADJACENTS_AND_BELOW.asStream((BlockPos)pos)).maxLeavesDistance(5).build();
        HugeMushroomHandler handler = new HugeMushroomHandler();
        logs.get().forEach(block -> {
            api.overrideChoppableBlock((Block)block, true);
            api.registerChoppableBlockBehavior((Block)block, handler);
        });
        leaves.get().forEach(block -> api.overrideLeavesBlock((Block)block, true));
    }

    @Override
    public BlockState getStrippedState(BlockGetter level, BlockPos pos, BlockState blockState) {
        if (PipeBlock.f_55154_.values().stream().anyMatch(property -> !blockState.m_61138_((Property)property))) {
            return blockState;
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)PipeBlock.f_55148_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PipeBlock.f_55149_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PipeBlock.f_55150_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PipeBlock.f_55151_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PipeBlock.f_55152_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PipeBlock.f_55153_, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public TreeData getTree(Level level, BlockPos origin) {
        return detectionHandler.getTree(level, origin);
    }

    public static boolean isLog(Level level, BlockPos pos, BlockState state) {
        return logs.get().contains(state.m_60734_());
    }

    public static boolean isLeaves(Level level, BlockPos pos, BlockState state) {
        return leaves.get().contains(state.m_60734_());
    }

    static {
        logs = new Lazy<Set>(ConfigHandler.RELOAD, () -> ConfigHandler.getIdentifiedBlocks((List)MyConfigHandler.instance.logIds.get()).collect(Collectors.toSet()));
        leaves = new Lazy<Set>(ConfigHandler.RELOAD, () -> ConfigHandler.getIdentifiedBlocks((List)MyConfigHandler.instance.leavesIds.get()).collect(Collectors.toSet()));
    }

    public static class MyConfigHandler {
        private static MyConfigHandler instance;
        protected final ForgeConfigSpec.ConfigValue<List<? extends String>> logIds;
        protected final ForgeConfigSpec.ConfigValue<List<? extends String>> leavesIds;

        public MyConfigHandler(ForgeConfigSpec.Builder builder) {
            builder.push("hugeMushrooms");
            this.logIds = builder.defineList("logs", List.of(ConfigHandler.getCommonTagId("mushroom_stems")), always -> true);
            this.leavesIds = builder.defineList("leaves", List.of(ConfigHandler.getCommonTagId("mushroom_caps")), always -> true);
            builder.pop();
        }

        public static void init(ForgeConfigSpec.Builder builder) {
            instance = new MyConfigHandler(builder);
        }
    }
}

