/*
 * Decompiled with CFR 0.152.
 */
package voltaic.api.fluid;

import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;

public class PropertyFluidTank
extends FluidTank {
    protected SingleProperty<FluidStack> fluidStackProperty;
    protected SingleProperty<Integer> capacityProperty;
    protected GenericTile holder;

    public PropertyFluidTank(int capacity, GenericTile holder, String key) {
        super(capacity);
        this.holder = holder;
        this.fluidStackProperty = holder.property(new SingleProperty<FluidStack>(PropertyTypes.FLUID_STACK, "propertyfluidtankstack" + key, FluidStack.EMPTY));
        this.capacityProperty = holder.property(new SingleProperty<Integer>(PropertyTypes.INTEGER, "propertyfluidtankcapacity" + key, Integer.valueOf(capacity)));
    }

    public PropertyFluidTank(int capacity, Predicate<FluidStack> validator, GenericTile holder, String key) {
        super(capacity, validator);
        this.holder = holder;
        this.fluidStackProperty = holder.property(new SingleProperty<FluidStack>(PropertyTypes.FLUID_STACK, "propertyfluidtankstack" + key, FluidStack.EMPTY));
        this.capacityProperty = holder.property(new SingleProperty<Integer>(PropertyTypes.INTEGER, "propertyfluidtankcapacity" + key, Integer.valueOf(capacity)));
    }

    protected PropertyFluidTank(PropertyFluidTank other) {
        super(other.capacity, other.validator);
        this.holder = other.holder;
        this.fluidStackProperty = other.fluidStackProperty;
        this.capacityProperty = other.capacityProperty;
    }

    public PropertyFluidTank[] asArray() {
        return new PropertyFluidTank[]{this};
    }

    public String toString() {
        return "Fluid: " + this.getFluid().getFluid().getFluidType().getDescriptionId() + "\nAmount: " + this.getFluidAmount() + "\nCapacity: " + this.getCapacity();
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        CompoundTag tag = new CompoundTag();
        this.getFluid().writeToNBT(tag);
        tag.m_128405_("capacity", this.getCapacity());
        nbt.m_128365_(this.fluidStackProperty.getName() + "tank", (Tag)tag);
        return nbt;
    }

    public FluidTank readFromNBT(CompoundTag nbt) {
        CompoundTag tag = nbt.m_128469_(this.fluidStackProperty.getName() + "name");
        this.setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)tag));
        this.setCapacity(tag.m_128451_("capacity"));
        return this;
    }

    public PropertyFluidTank setCapacity(int capacity) {
        this.capacityProperty.setValue(capacity);
        this.onContentsChanged();
        return this;
    }

    public int getCapacity() {
        return (Integer)this.capacityProperty.getValue();
    }

    @NotNull
    public FluidStack getFluid() {
        return (FluidStack)this.fluidStackProperty.getValue();
    }

    public int getFluidAmount() {
        return this.getFluid().getAmount();
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        if (action.simulate()) {
            if (this.getFluid().isEmpty()) {
                return Math.min(this.getCapacity(), resource.getAmount());
            }
            if (!this.getFluid().isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.getCapacity() - this.getFluidAmount(), resource.getAmount());
        }
        if (this.isEmpty()) {
            this.setFluid(new FluidStack(resource.getFluid(), Math.min(this.getCapacity(), resource.getAmount())));
            this.onContentsChanged();
            return this.getFluidAmount();
        }
        if (!this.getFluid().isFluidEqual(resource)) {
            return 0;
        }
        int filled = this.getCapacity() - this.getFluidAmount();
        if (resource.getAmount() < filled) {
            FluidStack stack = new FluidStack(this.getFluid().getFluid(), resource.getAmount() + this.getFluidAmount());
            this.setFluid(stack);
            filled = resource.getAmount();
        } else {
            this.setFluid(new FluidStack(this.getFluid().getFluid(), this.getCapacity()));
        }
        if (filled > 0) {
            this.onContentsChanged();
        }
        return filled;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !resource.isFluidEqual(this.getFluid())) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int drained = maxDrain;
        if (this.getFluidAmount() < drained) {
            drained = this.getFluidAmount();
        }
        FluidStack stack = new FluidStack(this.getFluid().getFluid(), drained);
        if (action.execute() && drained > 0) {
            this.setFluid(new FluidStack(this.getFluid().getFluid(), this.getFluidAmount() - drained));
            this.onContentsChanged();
        }
        return stack;
    }

    public void setFluid(FluidStack stack) {
        this.onContentsChanged();
        this.fluidStackProperty.setValue(stack);
    }

    public boolean isEmpty() {
        return this.getFluid().isEmpty();
    }

    public int getSpace() {
        return Math.max(0, this.getCapacity() - this.getFluidAmount());
    }

    protected void onContentsChanged() {
        if (this.holder != null) {
            this.holder.onFluidTankChange(this);
        }
    }
}

