/*
 * Decompiled with CFR 0.152.
 */
package voltaic.client.particle.fluiddrop;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;
import voltaic.api.codec.StreamCodec;
import voltaic.registers.VoltaicParticles;

public class ParticleOptionFluidDrop
extends ParticleType<ParticleOptionFluidDrop>
implements ParticleOptions {
    public static final Codec<ParticleOptionFluidDrop> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("r").forGetter(instance0 -> Float.valueOf(instance0.r)), (App)Codec.FLOAT.fieldOf("g").forGetter(instance0 -> Float.valueOf(instance0.g)), (App)Codec.FLOAT.fieldOf("b").forGetter(instance0 -> Float.valueOf(instance0.b)), (App)Codec.FLOAT.fieldOf("scale").forGetter(instance0 -> Float.valueOf(instance0.scale))).apply((Applicative)instance, (r, g, b, scale) -> new ParticleOptionFluidDrop().setParameters(r.floatValue(), g.floatValue(), b.floatValue(), scale.floatValue())));
    public static final StreamCodec<FriendlyByteBuf, ParticleOptionFluidDrop> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, ParticleOptionFluidDrop>(){

        @Override
        public void encode(FriendlyByteBuf buffer, ParticleOptionFluidDrop value) {
            buffer.writeFloat(value.r);
            buffer.writeFloat(value.g);
            buffer.writeFloat(value.b);
            buffer.writeFloat(value.scale);
        }

        @Override
        public ParticleOptionFluidDrop decode(FriendlyByteBuf buffer) {
            return new ParticleOptionFluidDrop().setParameters(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };
    public static final ParticleOptions.Deserializer<ParticleOptionFluidDrop> DESERIALIZER = new ParticleOptions.Deserializer<ParticleOptionFluidDrop>(){

        public ParticleOptionFluidDrop fromCommand(ParticleType<ParticleOptionFluidDrop> pParticleType, StringReader reader) throws CommandSyntaxException {
            ParticleOptionFluidDrop particle = new ParticleOptionFluidDrop();
            reader.expect(' ');
            float r = reader.readFloat();
            reader.expect(' ');
            float g = reader.readFloat();
            reader.expect(' ');
            float b = reader.readFloat();
            reader.expect(' ');
            float scale = reader.readFloat();
            return particle.setParameters(r, g, b, scale);
        }

        public ParticleOptionFluidDrop fromNetwork(ParticleType<ParticleOptionFluidDrop> pParticleType, FriendlyByteBuf pBuffer) {
            return STREAM_CODEC.decode(pBuffer);
        }
    };
    public float r;
    public float g;
    public float b;
    public float scale;

    public ParticleOptionFluidDrop() {
        super(false, DESERIALIZER);
    }

    public ParticleOptionFluidDrop setParameters(float r, float g, float b, float scale) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.scale = scale;
        return this;
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)VoltaicParticles.PARTICLE_FLUIDDROP.get();
    }

    public void m_7711_(FriendlyByteBuf pBuffer) {
        STREAM_CODEC.encode(pBuffer, this);
    }

    public String m_5942_() {
        return ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()).toString() + ", r: " + this.r + ", g: " + this.g + ", b: " + this.b + ", scale: " + this.scale;
    }

    public Codec<ParticleOptionFluidDrop> m_7652_() {
        return CODEC;
    }
}

