/*
 * Decompiled with CFR 0.152.
 */
package voltaic.compatibility.jei.utils.ingredients;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.TooltipFlag;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.gas.GasStack;
import voltaic.client.VoltaicClientRegister;
import voltaic.compatibility.jei.utils.gui.types.gasgauge.IGasGaugeTexture;
import voltaic.prefab.screen.component.types.gauges.ScreenComponentGasGauge;
import voltaic.prefab.utilities.RenderingUtils;

public class IngredientRendererGasStack
implements IIngredientRenderer<GasStack> {
    public static final IIngredientRenderer<GasStack> LIST_RENDERER = new IIngredientRenderer<GasStack>(){

        public void render(GuiGraphics graphics, GasStack ingredient) {
            RenderingUtils.setShaderColor(ingredient.getGas().getColor());
            graphics.m_280159_(0, 0, 0, 16, 16, VoltaicClientRegister.getSprite(VoltaicClientRegister.TEXTURE_GAS));
            RenderingUtils.resetShaderColor();
        }

        public List<Component> getTooltip(GasStack ingredient, TooltipFlag tooltipFlag) {
            return List.of(ingredient.getGas().getDescription());
        }
    };
    private final int tankAmount;
    private final int mercuryOffset;
    private final int tooltipHeight;
    private final IGasGaugeTexture bars;

    public IngredientRendererGasStack(int tankAmount, int mercuryOffset, int tooltipHeight, IGasGaugeTexture bars) {
        this.tankAmount = tankAmount;
        this.mercuryOffset = mercuryOffset;
        this.tooltipHeight = tooltipHeight;
        this.bars = bars;
    }

    public void render(GuiGraphics graphics, GasStack ingredient) {
        if (ingredient.isEmpty()) {
            return;
        }
        PoseStack stack = graphics.m_280168_();
        stack.m_85836_();
        float amt = ingredient.getAmount();
        if (amt < (float)(this.tankAmount / 50)) {
            double amtPowTen = Math.pow(10.0, Math.round(Math.log10(amt) - Math.log10(5.5) + 0.5));
            if (amtPowTen == 0.0) {
                amtPowTen = 1.0;
            }
            double gaugePowTen = Math.log10(Math.pow(10.0, Math.round(Math.log10(this.tankAmount) - Math.log10(5.5) + 0.5)));
            double logAmtPowTen = Math.log10(amtPowTen);
            double delta = gaugePowTen - logAmtPowTen;
            amt = (float)((double)amt * Math.pow(10.0, delta));
        }
        float ratio = amt / (float)this.tankAmount;
        ScreenComponentGasGauge.renderMercuryTexture(graphics, 0, this.mercuryOffset, ratio);
        graphics.m_280163_(this.bars.getLocation(), this.bars.getXOffset(), this.mercuryOffset + this.bars.getYOffset(), (float)this.bars.textureU(), (float)this.bars.textureV(), this.bars.textureWidth(), this.bars.textureHeight(), this.bars.imageWidth(), this.bars.imageHeight());
        stack.m_85849_();
    }

    public List<Component> getTooltip(GasStack ingredient, TooltipFlag tooltipFlag) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        tooltips.add(ingredient.getGas().getDescription());
        if (!ingredient.isEmpty()) {
            tooltips.add((Component)ChatFormatter.formatFluidMilibuckets(ingredient.getAmount()).m_130940_(ChatFormatting.GRAY));
            tooltips.add((Component)ChatFormatter.getChatDisplayShort(ingredient.getTemperature(), DisplayUnits.TEMPERATURE_KELVIN).m_130940_(ChatFormatting.GRAY));
            tooltips.add((Component)ChatFormatter.getChatDisplayShort(ingredient.getPressure(), DisplayUnits.PRESSURE_ATM).m_130940_(ChatFormatting.GRAY));
        }
        return tooltips;
    }

    public int getWidth() {
        return this.bars.textureWidth() - 2;
    }

    public int getHeight() {
        return Math.max(1, this.tooltipHeight - 1);
    }
}

