/*
 * Decompiled with CFR 0.152.
 */
package voltaic.prefab.properties.types;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import voltaic.api.codec.StreamCodec;
import voltaic.prefab.properties.types.IPropertyType;

public class ListPropertyType<TYPE, BUFFERTYPE extends ByteBuf>
implements IPropertyType<List<TYPE>, BUFFERTYPE> {
    private final BiPredicate<TYPE, TYPE> singleComparison;
    private final BiPredicate<List<TYPE>, List<TYPE>> comparison;
    private final StreamCodec<BUFFERTYPE, List<TYPE>> packetCodec;
    private final Consumer<IPropertyType.TagWriter<List<TYPE>>> writeToNbt;
    private final Function<IPropertyType.TagReader<List<TYPE>>, List<TYPE>> readFromNbt;

    public ListPropertyType(@Nonnull BiPredicate<TYPE, TYPE> singleComparison, final StreamCodec<BUFFERTYPE, TYPE> singlePacketCodec, Codec<TYPE> singleNbtCodec, final TYPE defaultValue) {
        this.singleComparison = singleComparison;
        this.comparison = (list1, list2) -> {
            if (list1 == null || list2 == null) {
                return false;
            }
            if (list1.size() != list2.size()) {
                return false;
            }
            for (int i = 0; i < list1.size(); ++i) {
                if (singleComparison.test(list1.get(i), list2.get(i))) continue;
                return false;
            }
            return true;
        };
        this.packetCodec = new StreamCodec<BUFFERTYPE, List<TYPE>>(){

            @Override
            public List<TYPE> decode(BUFFERTYPE buffer) {
                int size = buffer.readInt();
                ArrayList list = new ArrayList(size);
                Collections.fill(list, defaultValue);
                for (int i = 0; i < size; ++i) {
                    list.set(i, singlePacketCodec.decode(buffer));
                }
                return list;
            }

            @Override
            public void encode(BUFFERTYPE buffer, List<TYPE> value) {
                buffer.writeInt(value.size());
                for (int i = 0; i < value.size(); ++i) {
                    singlePacketCodec.encode(buffer, value.get(i));
                }
            }
        };
        this.writeToNbt = writer -> {
            CompoundTag tag = new CompoundTag();
            List list = (List)writer.prop().getValue();
            tag.m_128405_("size", list.size());
            for (int i = 0; i < list.size(); ++i) {
                int index = i;
                singleNbtCodec.encode(list.get(i), (DynamicOps)NbtOps.f_128958_, (Object)NbtOps.f_128958_.empty()).result().ifPresent(nbt -> tag.m_128365_("" + index, nbt));
            }
            writer.tag().m_128365_(writer.prop().getName(), (Tag)tag);
        };
        this.readFromNbt = reader -> {
            int i;
            CompoundTag data = reader.tag().m_128469_(reader.prop().getName());
            if (!data.m_128441_("size")) {
                return (List)reader.prop().getValue();
            }
            int size = data.m_128451_("size");
            if (size <= 0) {
                return new ArrayList();
            }
            ArrayList<Object> list = new ArrayList<Object>(size);
            for (i = 0; i < size; ++i) {
                list.add(defaultValue);
            }
            for (i = 0; i < size; ++i) {
                int index = i;
                singleNbtCodec.decode((DynamicOps)NbtOps.f_128958_, (Object)data.m_128423_("" + i)).result().ifPresent(pair -> list.set(index, pair.getFirst()));
            }
            return list;
        };
    }

    @Override
    public StreamCodec<BUFFERTYPE, List<TYPE>> getPacketCodec() {
        return this.packetCodec;
    }

    @Override
    public void writeToTag(IPropertyType.TagWriter<List<TYPE>> writer) {
        this.writeToNbt.accept(writer);
    }

    @Override
    public List<TYPE> readFromTag(IPropertyType.TagReader<List<TYPE>> reader) {
        return this.readFromNbt.apply(reader);
    }

    @Override
    public boolean isEqual(List<TYPE> currentValue, List<TYPE> newValue) {
        return this.comparison.test(currentValue, newValue);
    }

    public boolean isSingleEqual(TYPE val1, TYPE val2) {
        return this.singleComparison.test(val1, val2);
    }
}

