/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.network.packet;

import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.animatable.GeoReplacedEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.network.AbstractPacket;
import mod.azure.azurelib.platform.services.AzureLibNetwork;
import mod.azure.azurelib.util.ClientUtils;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

@Deprecated(forRemoval=true)
public class EntityAnimTriggerPacket
extends AbstractPacket {
    private final int entityId;
    private final boolean isReplacedEntity;
    private final String controllerName;
    private final String animName;

    public EntityAnimTriggerPacket(int entityId, @Nullable String controllerName, String animName) {
        this(entityId, false, controllerName, animName);
    }

    public EntityAnimTriggerPacket(int entityId, boolean isReplacedEntity, @Nullable String controllerName, String animName) {
        this.entityId = entityId;
        this.isReplacedEntity = isReplacedEntity;
        this.controllerName = controllerName == null ? "" : controllerName;
        this.animName = animName;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.entityId);
        buf.writeBoolean(this.isReplacedEntity);
        buf.m_130070_(this.controllerName);
        buf.m_130070_(this.animName);
    }

    @Override
    public ResourceLocation getPacketID() {
        return AzureLibNetwork.ENTITY_ANIM_TRIGGER_SYNC_PACKET_ID;
    }

    public static EntityAnimTriggerPacket receive(FriendlyByteBuf buf) {
        return new EntityAnimTriggerPacket(buf.m_130242_(), buf.readBoolean(), buf.m_130277_(), buf.m_130277_());
    }

    @Override
    public void handle() {
        Entity entity = ClientUtils.getLevel().m_6815_(this.entityId);
        if (entity == null) {
            return;
        }
        if (!this.isReplacedEntity) {
            if (entity instanceof GeoEntity) {
                GeoEntity geoEntity = (GeoEntity)entity;
                geoEntity.triggerAnim(this.controllerName.isEmpty() ? null : this.controllerName, this.animName);
            }
            return;
        }
        GeoAnimatable animatable = RenderUtils.getReplacedAnimatable(entity.m_6095_());
        if (animatable instanceof GeoReplacedEntity) {
            GeoReplacedEntity replacedEntity = (GeoReplacedEntity)animatable;
            replacedEntity.triggerAnim(entity, this.controllerName.isEmpty() ? null : this.controllerName, this.animName);
        }
    }
}

