/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.portal.linking;

import java.util.concurrent.ConcurrentHashMap;
import net.kyrptonaught.customportalapi.portal.linking.DimensionalBlockPos;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class PortalLinkingStorage
extends SavedData {
    private final ConcurrentHashMap<ResourceLocation, ConcurrentHashMap<BlockPos, DimensionalBlockPos>> portalLinks = new ConcurrentHashMap();

    public static SavedData fromNbt(CompoundTag tag) {
        PortalLinkingStorage cman = new PortalLinkingStorage();
        ListTag links = (ListTag)tag.m_128423_("portalLinks");
        for (int i = 0; i < links.size(); ++i) {
            CompoundTag link = links.m_128728_(i);
            DimensionalBlockPos toTag = DimensionalBlockPos.fromTag(link.m_128469_("to"));
            cman.addLink(BlockPos.m_122022_((long)link.m_128454_("fromPos")), new ResourceLocation(link.m_128461_("fromDimID")), toTag.pos, toTag.dimensionType);
        }
        return cman;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag links = new ListTag();
        this.portalLinks.keys().asIterator().forEachRemaining(dimKey -> this.portalLinks.get(dimKey).forEach((blockPos, dimensionalBlockPos) -> {
            CompoundTag link = new CompoundTag();
            link.m_128359_("fromDimID", dimKey.toString());
            link.m_128356_("fromPos", blockPos.m_121878_());
            link.m_128365_("to", (Tag)dimensionalBlockPos.toTag(new CompoundTag()));
            links.add((Object)link);
        }));
        tag.m_128365_("portalLinks", (Tag)links);
        return tag;
    }

    public DimensionalBlockPos getDestination(BlockPos portalFramePos, ResourceKey<Level> dimID) {
        if (this.portalLinks.containsKey(dimID.m_135782_())) {
            return this.portalLinks.get(dimID.m_135782_()).get(portalFramePos);
        }
        return null;
    }

    public void createLink(BlockPos portalFramePos, ResourceKey<Level> dimID, BlockPos destPortalFramePos, ResourceKey<Level> destDimID) {
        this.addLink(portalFramePos, dimID, destPortalFramePos, destDimID);
        this.addLink(destPortalFramePos, destDimID, portalFramePos, dimID);
    }

    private void addLink(BlockPos portalFramePos, ResourceLocation dimID, BlockPos destPortalFramePos, ResourceLocation destDimID) {
        if (!this.portalLinks.containsKey(dimID)) {
            this.portalLinks.put(dimID, new ConcurrentHashMap());
        }
        this.portalLinks.get(dimID).put(portalFramePos, new DimensionalBlockPos(destDimID, destPortalFramePos));
    }

    private void addLink(BlockPos portalFramePos, ResourceKey<Level> dimID, BlockPos destPortalFramePos, ResourceKey<Level> destDimID) {
        this.addLink(portalFramePos, dimID.m_135782_(), destPortalFramePos, destDimID.m_135782_());
    }

    public boolean m_77764_() {
        return true;
    }
}

