/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.turret;

import com.jesz.createdieselgenerators.CreateDieselGenerators;
import com.jesz.createdieselgenerators.content.entity_filter.EntityFilterItem;
import com.jesz.createdieselgenerators.content.entity_filter.EntityFilteringBehaviour;
import com.jesz.createdieselgenerators.content.turret.ChemicalTurretBlockEntity;
import com.jesz.createdieselgenerators.mixin_interfaces.IEntity;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.actors.seat.SeatEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.Iterator;
import java.util.List;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TurretBlockEntity
extends KineticBlockEntity {
    public float oldHorizontalRotation;
    public float oldVerticalRotation;
    public float oldTargetedVerticalRotation = 0.0f;
    public float oldTargetedHorizontalRotation = 0.0f;
    public float horizontalRotation;
    public float verticalRotation;
    public float targetedVerticalRotation = 0.0f;
    public float targetedHorizontalRotation = 0.0f;
    public Player controllingPlayer;
    public LivingEntity controllingEntity;
    public Entity targetedEntity;
    public Direction controllingEntityDirection;
    public boolean sync;
    boolean removePlayer = false;
    int t;
    float cachedPitch = 0.0f;
    private FilteringBehaviour filtering;

    public TurretBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void tick() {
        super.tick();
        if (this.controllingEntity == null) {
            this.targetedEntity = null;
        }
        if (this.controllingEntity != null) {
            this.controllingEntity.m_5616_(-this.targetedHorizontalRotation + 180.0f);
            Entity entity = this.controllingEntity.m_20201_();
            if (entity instanceof SeatEntity) {
                Iterator seat = (SeatEntity)entity;
                if (Math.sqrt(seat.m_20183_().m_123331_((Vec3i)this.f_58858_)) > 1.0) {
                    ((IEntity)this.controllingEntity).setTurretPos(null);
                    this.controllingEntity = null;
                }
            } else {
                ((IEntity)this.controllingEntity).setTurretPos(null);
                this.controllingEntity = null;
            }
        } else if (this.t == 0) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                LivingEntity le;
                Entity possibleControllingEntity;
                List passengers;
                List list = this.f_58857_.m_45976_(SeatEntity.class, new AABB(this.m_58899_().m_121945_(direction)));
                if (list.isEmpty() || (passengers = ((SeatEntity)list.get(0)).m_20197_()).isEmpty() || passengers.get(0) instanceof Player || ((IEntity)(possibleControllingEntity = (Entity)passengers.get(0))).getTurretPos() != null) continue;
                ((IEntity)possibleControllingEntity).setTurretPos(this.f_58858_);
                if (!(possibleControllingEntity instanceof LivingEntity)) continue;
                this.controllingEntity = le = (LivingEntity)possibleControllingEntity;
                this.controllingEntityDirection = direction;
            }
        }
        if (this.controllingEntity != null && this.controllingPlayer == null && this.targetedEntity != null) {
            AABB aabb = this.getTargetBB();
            this.targetedHorizontalRotation = (float)(Math.atan2(this.targetedEntity.m_20185_() - (double)this.f_58858_.m_123341_() - 0.5, this.targetedEntity.m_20189_() - (double)this.f_58858_.m_123343_() - 0.5) * 180.0 / Math.PI) + 180.0f;
            this.targetedVerticalRotation = this.calculatePitch(this.targetedEntity.m_20182_().m_82520_(0.0, 0.5, 0.0));
            if (!aabb.m_82390_(this.targetedEntity.m_20182_()) || this.targetedEntity.m_213877_() || !this.isWithinRange(this.targetedEntity.m_20182_().m_82520_(0.0, 0.5, 0.0)) || this.targetedEntity.m_20182_().m_82554_(Vec3.m_82512_((Vec3i)this.f_58858_)) < 1.0) {
                this.targetedEntity = null;
            }
        }
        ++this.t;
        if (this.t >= 40) {
            this.t = 0;
            this.updateTargetedEntity();
        }
        if (this.t % 8 == 0 && this.sync) {
            this.sendData();
            this.sync = false;
        }
        this.oldHorizontalRotation = this.horizontalRotation;
        this.oldVerticalRotation = this.verticalRotation;
        this.horizontalRotation = AngleHelper.angleLerp((double)(this.controllingEntity == null || this.controllingPlayer != null ? (double)0.2f : (double)0.7f), (double)this.horizontalRotation, (double)this.targetedHorizontalRotation);
        this.verticalRotation = AngleHelper.angleLerp((double)(this.controllingEntity == null || this.controllingPlayer != null ? (double)0.2f : (double)0.7f), (double)this.verticalRotation, (double)this.targetedVerticalRotation);
        if (this.oldTargetedHorizontalRotation != this.targetedHorizontalRotation || this.oldTargetedVerticalRotation != this.targetedVerticalRotation) {
            this.sendData();
        }
        this.oldTargetedHorizontalRotation = this.targetedHorizontalRotation;
        this.oldTargetedVerticalRotation = this.targetedVerticalRotation;
        if (this.controllingPlayer == null) {
            return;
        }
        if (Math.sqrt(this.controllingPlayer.m_20238_(Vec3.m_82512_((Vec3i)this.f_58858_))) > 3.0 || this.controllingPlayer.m_6047_()) {
            this.removePlayer();
        }
        if (this.removePlayer || this.controllingPlayer.m_213877_()) {
            this.controllingPlayer = null;
            this.removePlayer = false;
            return;
        }
        this.targetedVerticalRotation = Mth.m_14036_((float)this.controllingPlayer.f_19860_, (float)-50.0f, (float)1.0f);
        this.targetedHorizontalRotation = -this.controllingPlayer.f_20886_ + 180.0f;
    }

    public float calculatePitch(Vec3 targetPos) {
        Vec3 start = Vec3.m_82512_((Vec3i)this.f_58858_).m_82520_(0.0, 0.625, 0.0);
        float initialVelocity = this.getShootingForce();
        double dx = targetPos.f_82479_ - start.f_82479_;
        double dz = targetPos.f_82481_ - start.f_82481_;
        double dY = targetPos.f_82480_ - start.f_82480_;
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        float closestPitch = 0.0f;
        float closestDistance = 9999.0f;
        if (this.simulate(this.cachedPitch, initialVelocity, horizontalDist, dY) < 1.0f) {
            return this.cachedPitch;
        }
        for (float pitch = -50.0f; pitch <= 10.0f; pitch += 1.0f) {
            float distance = this.simulate(pitch, initialVelocity, horizontalDist, dY);
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
            closestPitch = pitch;
        }
        this.cachedPitch = closestPitch;
        return closestPitch;
    }

    public float getShootingForce() {
        float speed = Math.abs(this.getSpeed());
        return (float)Math.log(speed) * 0.3f + 0.2f;
    }

    public float simulate(float pitch, float initialVelocity, double horizontalDist, double dY) {
        double pX = 0.0;
        double pY = 0.0;
        double vX = Math.cos(Math.toRadians(-pitch)) * (double)initialVelocity;
        double vY = Math.sin(Math.toRadians(-pitch)) * (double)initialVelocity;
        float closestDistance = 9999.0f;
        for (int t = 0; t < 200; ++t) {
            pX += vX;
            vX *= 0.95;
            if ((pY += (vY -= 0.015)) < dY && (vY *= 0.95) < 0.0) break;
            float distance = (float)Math.sqrt((horizontalDist - pX) * (horizontalDist - pX) + (dY - pY) * (dY - pY));
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
        }
        return closestDistance;
    }

    public boolean isWithinRange(Vec3 targetPos) {
        float shootingForce = (float)Math.min(Math.abs(1.0 - Math.pow(1.0f - this.getSpeed() / 256.0f, 3.0)), 1.0);
        Vec3 turretPos = Vec3.m_82512_((Vec3i)this.f_58858_).m_82520_(0.0, 0.625, 0.0);
        double dx = targetPos.f_82479_ - turretPos.f_82479_;
        double dz = targetPos.f_82481_ - turretPos.f_82481_;
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        return horizontalDistance < 22.0;
    }

    public void remove() {
        super.remove();
        if (this.controllingEntity != null) {
            ((IEntity)this.controllingEntity).setTurretPos(null);
        }
    }

    public void updateTargetedEntity() {
        AABB aabb = this.getTargetBB();
        List<Entity> entities = this.f_58857_.m_45933_(null, aabb).stream().filter(e -> {
            if (!(e instanceof LivingEntity)) {
                return false;
            }
            LivingEntity entity = (LivingEntity)e;
            return this.isValidTarget(entity);
        }).sorted((entity, t1) -> {
            if (entity == this.targetedEntity) {
                return 1;
            }
            if (t1 == this.targetedEntity) {
                return 0;
            }
            return (int)t1.m_20182_().m_82554_(Vec3.m_82512_((Vec3i)this.f_58858_));
        }).toList();
        this.targetedEntity = entities.isEmpty() ? null : entities.get(0);
    }

    public boolean isValidTarget(LivingEntity entity) {
        SpawnEggItem egg;
        if (!TargetingConditions.m_148352_().m_26885_(this.controllingEntity, entity)) {
            return false;
        }
        if (entity.m_213877_() || !this.isWithinRange(entity.m_20182_()) || entity.m_20182_().m_82554_(Vec3.m_82512_((Vec3i)this.f_58858_)) < 2.0) {
            return false;
        }
        Item item = this.filtering.getFilter().m_41720_();
        if (item instanceof SpawnEggItem && (egg = (SpawnEggItem)item).m_43228_(null) != entity.m_6095_()) {
            return false;
        }
        return !(this.filtering.getFilter().m_41720_() instanceof EntityFilterItem ? !EntityFilterItem.test(this.filtering.getFilter(), (Entity)entity) : entity instanceof Player);
    }

    public AABB getTargetBB() {
        return new AABB((double)this.f_58858_.m_123341_() - (this.controllingEntityDirection == Direction.WEST ? -1.5 : 33.0), (double)(this.f_58858_.m_123342_() - 5), (double)this.f_58858_.m_123343_() - (this.controllingEntityDirection == Direction.NORTH ? -1.5 : 33.0), (double)this.f_58858_.m_123341_() + (this.controllingEntityDirection == Direction.EAST ? -1.5 : 33.0), (double)(this.f_58858_.m_123342_() + 10), (double)this.f_58858_.m_123343_() + (this.controllingEntityDirection == Direction.SOUTH ? -1.5 : 33.0));
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.targetedVerticalRotation = compound.m_128457_("VerticalRotation");
        this.targetedHorizontalRotation = compound.m_128457_("HorizontalRotation");
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128350_("VerticalRotation", this.targetedVerticalRotation);
        compound.m_128350_("HorizontalRotation", this.targetedHorizontalRotation);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filtering = new EntityFilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new ChemicalTurretBlockEntity.ChemicalTurretValueBox());
        behaviours.add((BlockEntityBehaviour)this.filtering);
    }

    public void setControllingPlayer(Player player) {
        ServerPlayer sp;
        BlockEntity blockEntity;
        BlockPos tPos;
        if (this.f_58857_.f_46443_) {
            AllSoundEvents.CONTROLLER_CLICK.play(this.f_58857_, player, (Vec3i)this.f_58858_);
        }
        if ((tPos = ((IEntity)player).getTurretPos()) != null && (blockEntity = this.f_58857_.m_7702_(tPos)) instanceof TurretBlockEntity) {
            TurretBlockEntity be = (TurretBlockEntity)blockEntity;
            be.removePlayer();
        }
        if (Math.sqrt(player.m_20238_(Vec3.m_82512_((Vec3i)this.f_58858_))) > 3.0) {
            if (player instanceof ServerPlayer) {
                sp = (ServerPlayer)player;
                sp.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket(CreateDieselGenerators.lang("actionbar.turret.too_far_away", new Object[0])));
            }
            return;
        }
        if (player instanceof ServerPlayer) {
            sp = (ServerPlayer)player;
            sp.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)CreateLang.translateDirect((String)"contraption.controls.start_controlling", (Object[])new Object[]{Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_())})));
        }
        this.controllingPlayer = player;
        ((IEntity)this.controllingPlayer).setTurretPos(this.f_58858_);
    }

    public void removePlayer() {
        Player player;
        if (this.f_58857_.f_46443_) {
            AllSoundEvents.CONTROLLER_CLICK.play(this.f_58857_, this.controllingPlayer, (Vec3i)this.f_58858_);
        }
        if ((player = this.controllingPlayer) instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket(CreateDieselGenerators.lang("actionbar.turret.stopped_controlling", Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_()))));
        }
        ((IEntity)this.controllingPlayer).setTurretPos(null);
        this.removePlayer = true;
    }
}

