/*
 * Decompiled with CFR 0.152.
 */
package net.chaolux.createterminal;

import com.mojang.logging.LogUtils;
import net.chaolux.createterminal.Config;
import net.chaolux.createterminal.client.ClientAdvancementCache;
import net.chaolux.createterminal.common.utility.StyleUtils;
import net.chaolux.createterminal.registry.item.ModItems;
import net.chaolux.createterminal.registry.network.ModNetwork;
import net.chaolux.createterminal.registry.recipe.ModRecipes;
import net.chaolux.createterminal.registry.sound.ModSounds;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="createterminal")
public class CreateTerminal {
    public static final String MOD_ID = "createterminal";
    private static final Logger LOGGER = LogUtils.getLogger();

    public CreateTerminal() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.ITEMS.register(modEventBus);
        ModSounds.SOUND_EVENTS.register(modEventBus);
        ModNetwork.register();
        ModRecipes.SERIALIZERS.register(modEventBus);
        ModRecipes.TYPES.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.accept(ModItems.REMOTE_TERMINAL);
            event.accept(ModItems.ADVANCED_REMOTE_TERMINAL);
            event.accept(ModItems.CREATIVE_REMOTE_TERMINAL);
        }
        if (event.getTabKey() == CreativeModeTabs.f_256968_) {
            event.accept(ModItems.MEMORY_CORE);
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(modid="createterminal", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                ItemProperties.register((Item)((Item)ModItems.CREATIVE_REMOTE_TERMINAL.get()), (ResourceLocation)new ResourceLocation("bound"), (stack, world, entity, seed) -> {
                    if (stack.m_41782_() && stack.m_41783_().m_128441_("terminals")) {
                        return 1.0f;
                    }
                    return 0.0f;
                });
                ItemProperties.register((Item)((Item)ModItems.ADVANCED_REMOTE_TERMINAL.get()), (ResourceLocation)new ResourceLocation("styles"), (stack, world, entity, seed) -> {
                    if (stack == null || !stack.m_41782_()) {
                        return 0.0f;
                    }
                    boolean bound = stack.m_41783_().m_128441_("terminals");
                    if (!bound) {
                        return 0.0f;
                    }
                    String style = stack.m_41783_().m_128461_("style");
                    if (style.equals("cardboard") && !StyleUtils.isMod("createcardboardthings")) {
                        return 1.0f;
                    }
                    if (style.equals("end") && !ClientAdvancementCache.hasDragonKill()) {
                        return 1.0f;
                    }
                    return switch (style) {
                        case "blaze" -> 1.0f;
                        case "parrot" -> 2.0f;
                        case "cat" -> 3.0f;
                        case "cardboard" -> 4.0f;
                        case "end" -> 5.0f;
                        default -> 0.0f;
                    };
                });
                ItemProperties.register((Item)((Item)ModItems.REMOTE_TERMINAL.get()), (ResourceLocation)new ResourceLocation("styles"), (stack, world, entity, seed) -> {
                    boolean bound;
                    if (stack == null || !stack.m_41782_()) {
                        return 0.0f;
                    }
                    boolean bl = bound = stack.m_41783_().m_128441_("boundPos") && stack.m_41783_().m_128441_("boundDim");
                    if (!bound) {
                        return 0.0f;
                    }
                    String style = stack.m_41783_().m_128461_("style");
                    if (style.equals("cardboard") && !StyleUtils.isMod("createcardboardthings")) {
                        return 1.0f;
                    }
                    if (style.equals("end") && !ClientAdvancementCache.hasDragonKill()) {
                        return 1.0f;
                    }
                    return switch (style) {
                        case "blaze" -> 1.0f;
                        case "parrot" -> 2.0f;
                        case "cat" -> 3.0f;
                        case "cardboard" -> 4.0f;
                        case "end" -> 5.0f;
                        default -> 0.0f;
                    };
                });
            });
        }
    }
}

