/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.blocks.blockentities;

import java.util.List;
import java.util.Random;
import mod.azure.azurelib.animatable.GeoBlockEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.doom.entities.DemonEntity;
import mod.azure.doom.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class TotemEntity
extends BlockEntity
implements GeoBlockEntity {
    protected final Random random = new Random();
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public TotemEntity(BlockPos pos, BlockState state) {
        super(Services.ENTITIES_HELPER.getTotemEntity(), pos, state);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, TotemEntity blockEntity) {
        if (blockEntity.f_58857_ != null && blockEntity.f_58857_.m_46467_() % 80L == 0L) {
            blockEntity.applyEffects();
        }
        if (world != null && world.m_5776_()) {
            double x = (double)pos.m_123341_() + 1.0 * (blockEntity.random.nextDouble() - 0.25) * 2.0;
            double y = (double)pos.m_123342_() + 1.0 * (blockEntity.random.nextDouble() - 0.5) * 2.0;
            double z = (double)pos.m_123343_() + 1.0 * (blockEntity.random.nextDouble() - 0.25) * 2.0;
            for (int k = 0; k < 4; ++k) {
                world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, x, y, z, (blockEntity.random.nextDouble() - 0.5) * 2.0, -blockEntity.random.nextDouble(), (blockEntity.random.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, event -> event.setAndContinue(RawAnimation.begin().thenLoop("idle")))});
    }

    public void m_7651_() {
        this.removeEffects();
        super.m_7651_();
    }

    private void applyEffects() {
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_) {
            AABB axisalignedbb = new AABB(this.f_58858_).m_82400_(40.0).m_82363_(0.0, (double)this.f_58857_.m_151558_(), 0.0);
            List list = this.f_58857_.m_45976_(DemonEntity.class, axisalignedbb);
            for (DemonEntity entity : list) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 1000, 1));
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 1000, 1));
                entity.m_146915_(true);
            }
        }
    }

    private void removeEffects() {
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_) {
            AABB axisalignedbb = new AABB(this.f_58858_).m_82400_(40.0).m_82363_(0.0, (double)this.f_58857_.m_151558_(), 0.0);
            List list = this.f_58857_.m_45976_(DemonEntity.class, axisalignedbb);
            for (DemonEntity entity : list) {
                entity.m_146915_(false);
                entity.m_21219_();
            }
        }
    }
}

