/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entities.projectiles;

import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.network.packet.EntityPacket;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.doom.entities.tierboss.IconofsinEntity;
import mod.azure.doom.helper.CommonUtils;
import mod.azure.doom.platform.Services;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class RocketEntity
extends AbstractArrow
implements GeoEntity {
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private LivingEntity shooter;
    private float projectiledamage;
    private int idleTicks = 0;

    public RocketEntity(EntityType<? extends RocketEntity> entityType, Level world) {
        super(entityType, world);
        this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
    }

    public RocketEntity(Level world, LivingEntity owner, float damage) {
        super(Services.ENTITIES_HELPER.getRocketEntity(), owner, world);
        this.shooter = owner;
        this.projectiledamage = damage;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, event -> PlayState.CONTINUE)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void m_7761_(@NotNull LivingEntity living) {
        super.m_7761_(living);
        if (!(living instanceof Player) && !(living instanceof IconofsinEntity)) {
            living.m_20334_(0.0, 0.0, 0.0);
            living.f_19802_ = 0;
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return EntityPacket.createPacket((Entity)this);
    }

    protected void m_6901_() {
        if (this.f_19797_ >= 40) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        super.m_6686_(x, y, z, velocity, inaccuracy);
    }

    public void m_8119_() {
        int idleOpt = 100;
        this.idleTicks = this.m_20184_().m_82556_() < 0.01 ? ++this.idleTicks : 0;
        if (this.idleTicks < 100) {
            super.m_8119_();
        }
        if (this.f_19797_ >= 80) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        boolean isInsideWaterBlock = this.m_9236_().m_46801_(this.m_20183_());
        CommonUtils.spawnLightSource((Entity)this, isInsideWaterBlock);
        if (this.m_9236_().m_5776_()) {
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123762_, true, this.m_20185_() + this.f_19796_.m_188500_() * (double)this.m_20205_() * 0.5, this.m_20227_(0.5), this.m_20189_() + this.f_19796_.m_188500_() * (double)this.m_20205_() * 0.5, 0.0, 0.0, 0.0);
        }
    }

    public boolean m_20068_() {
        return !this.m_20069_();
    }

    public void m_36740_(@NotNull SoundEvent soundIn) {
        this.m_7239_();
    }

    @NotNull
    protected SoundEvent m_7239_() {
        return Services.SOUNDS_HELPER.getROCKET_HIT();
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        areaeffectcloudentity.m_19724_((ParticleOptions)ParticleTypes.f_123756_);
        areaeffectcloudentity.m_19712_(6.0f);
        areaeffectcloudentity.m_19734_(1);
        areaeffectcloudentity.m_20248_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_9236_().m_7967_((Entity)areaeffectcloudentity);
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.5f);
        super.m_142687_(reason);
    }

    protected void m_8060_(@NotNull BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        if (!this.m_9236_().m_5776_()) {
            this.doDamage();
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_5790_(@NotNull EntityHitResult entityHitResult) {
        if (!this.m_9236_().m_5776_()) {
            this.doDamage();
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @NotNull
    public ItemStack m_7941_() {
        return Items.f_41852_.m_7968_();
    }

    public void doDamage() {
        this.m_9236_().m_45933_((Entity)this, new AABB(this.m_20183_().m_7494_()).m_82400_(4.0)).forEach(e -> {
            if (e instanceof LivingEntity) {
                e.m_6469_(this.m_269291_().m_269075_((Player)this.shooter), this.projectiledamage);
                if (this.m_6060_()) {
                    e.m_20254_(50);
                }
            }
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), 0.0f, Level.ExplosionInteraction.NONE);
        });
    }

    public boolean m_6051_() {
        return false;
    }
}

