/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entities.task;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.ToIntFunction;
import mod.azure.doom.MCDoom;
import mod.azure.doom.entities.DemonEntity;
import mod.azure.doom.entities.task.CustomDelayedRangedBehaviour;
import mod.azure.doom.entities.tierambient.TentacleEntity;
import mod.azure.doom.entities.tierambient.TurretEntity;
import mod.azure.doom.entities.tierboss.ArchMakyrEntity;
import mod.azure.doom.entities.tierboss.GladiatorEntity;
import mod.azure.doom.entities.tierboss.IconofsinEntity;
import mod.azure.doom.entities.tierboss.MotherDemonEntity;
import mod.azure.doom.entities.tierboss.SpiderMastermind2016Entity;
import mod.azure.doom.entities.tierboss.SpiderMastermindEntity;
import mod.azure.doom.entities.tierfodder.ChaingunnerEntity;
import mod.azure.doom.entities.tierfodder.GargoyleEntity;
import mod.azure.doom.entities.tierfodder.ImpEntity;
import mod.azure.doom.entities.tierfodder.LostSoulEntity;
import mod.azure.doom.entities.tierfodder.MaykrDroneEntity;
import mod.azure.doom.entities.tierfodder.MechaZombieEntity;
import mod.azure.doom.entities.tierfodder.PossessedScientistEntity;
import mod.azure.doom.entities.tierfodder.PossessedSoldierEntity;
import mod.azure.doom.entities.tierfodder.ShotgunguyEntity;
import mod.azure.doom.entities.tierfodder.ZombiemanEntity;
import mod.azure.doom.entities.tierheavy.ArachnotronEntity;
import mod.azure.doom.entities.tierheavy.BloodMaykrEntity;
import mod.azure.doom.entities.tierheavy.CacodemonEntity;
import mod.azure.doom.entities.tierheavy.CarcassEntity;
import mod.azure.doom.entities.tierheavy.HellknightEntity;
import mod.azure.doom.entities.tierheavy.MancubusEntity;
import mod.azure.doom.entities.tierheavy.PainEntity;
import mod.azure.doom.entities.tierheavy.ProwlerEntity;
import mod.azure.doom.entities.tierheavy.Revenant2016Entity;
import mod.azure.doom.entities.tierheavy.RevenantEntity;
import mod.azure.doom.entities.tiersuperheavy.ArchvileEntity;
import mod.azure.doom.entities.tiersuperheavy.BaronEntity;
import mod.azure.doom.entities.tiersuperheavy.CyberdemonEntity;
import mod.azure.doom.entities.tiersuperheavy.DoomHunterEntity;
import mod.azure.doom.entities.tiersuperheavy.FireBaronEntity;
import mod.azure.doom.entities.tiersuperheavy.MarauderEntity;
import mod.azure.doom.entities.tiersuperheavy.SummonerEntity;
import mod.azure.doom.helper.CommonUtils;
import mod.azure.doom.platform.Services;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AABB;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DemonProjectileAttack<E extends DemonEntity>
extends CustomDelayedRangedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.f_26373_, (Object)MemoryStatus.VALUE_ABSENT)});
    protected ToIntFunction<E> attackIntervalSupplier = entity -> 20;
    protected Float damage = Float.valueOf(0.0f);
    @Nullable
    protected LivingEntity target = null;

    public DemonProjectileAttack(int delayTicks) {
        super(delayTicks);
    }

    public DemonProjectileAttack<E> attackInterval(ToIntFunction<E> supplier) {
        this.attackIntervalSupplier = supplier;
        return this;
    }

    public DemonProjectileAttack<E> attackDamage(float damage) {
        this.damage = Float.valueOf(damage);
        return this;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull E entity) {
        this.target = BrainUtils.getTargetOfEntity(entity);
        assert (this.target != null);
        return entity.m_21574_().m_148306_((Entity)this.target) && !entity.m_217066_(this.target) && !entity.m_203117_() && !entity.m_203117_();
    }

    protected void start(E entity) {
        assert (this.target != null);
        BehaviorUtils.m_22595_(entity, (LivingEntity)this.target);
    }

    protected void stop(E entity) {
        this.target = null;
        ((DemonEntity)((Object)entity)).setAttackingState(0);
    }

    @Override
    protected void doDelayedAction(E entity) {
        BrainUtils.setForgettableMemory(entity, (MemoryModuleType)MemoryModuleType.f_26373_, (Object)true, (int)this.attackIntervalSupplier.applyAsInt(entity));
        if (this.target == null) {
            return;
        }
        if (!entity.m_21574_().m_148306_((Entity)this.target) || entity.m_217066_(this.target)) {
            return;
        }
        BehaviorUtils.m_22595_(entity, (LivingEntity)this.target);
        if (entity instanceof PossessedSoldierEntity || entity instanceof BaronEntity || entity instanceof FireBaronEntity) {
            ((DemonEntity)((Object)entity)).shootBaron(this.damage.floatValue(), 0.0, 0.0, 0.0);
        }
        if (entity instanceof MaykrDroneEntity) {
            ((DemonEntity)((Object)entity)).shootBolt(this.damage.floatValue());
        }
        if (entity instanceof BloodMaykrEntity) {
            ((DemonEntity)((Object)entity)).shootBloodBolt(this.damage.floatValue());
        }
        if (entity instanceof ChaingunnerEntity || entity instanceof ShotgunguyEntity || entity instanceof ZombiemanEntity) {
            this.hitScanAttack((LivingEntity)entity);
        }
        if (entity instanceof SpiderMastermindEntity || entity instanceof SpiderMastermind2016Entity || entity instanceof ArachnotronEntity) {
            ((DemonEntity)((Object)entity)).shootEnergyCell(this.damage.floatValue());
        }
        if (entity instanceof Revenant2016Entity || entity instanceof RevenantEntity) {
            ((DemonEntity)((Object)entity)).shootRocket(this.damage.floatValue());
            ((DemonEntity)((Object)entity)).shootRocket(this.damage.floatValue());
        }
        if (entity instanceof CyberdemonEntity) {
            ((DemonEntity)((Object)entity)).shootRocket(this.damage.floatValue());
        }
        if (entity instanceof HellknightEntity || entity instanceof CacodemonEntity) {
            ((DemonEntity)((Object)entity)).shootFireball(this.damage.floatValue(), 0);
        }
        if (entity instanceof MechaZombieEntity || entity instanceof ImpEntity || entity instanceof GargoyleEntity || entity instanceof TurretEntity || entity instanceof CarcassEntity) {
            ((DemonEntity)((Object)entity)).shootSmallFireball(this.damage.floatValue());
        }
        if (entity instanceof ProwlerEntity) {
            ProwlerEntity prowlerEntity = (ProwlerEntity)((Object)entity);
            prowlerEntity.shootSmallFireball(this.damage.floatValue());
            prowlerEntity.teleport();
        }
        if (entity instanceof MarauderEntity) {
            MarauderEntity marauderEntity = (MarauderEntity)((Object)entity);
            this.marauderAttacks(marauderEntity);
        }
        if (entity instanceof ArchvileEntity) {
            ArchvileEntity archvileEntity = (ArchvileEntity)((Object)entity);
            this.archvileAttacks(archvileEntity);
        }
        if (entity instanceof SummonerEntity) {
            SummonerEntity summonerEntity = (SummonerEntity)((Object)entity);
            if (summonerEntity.m_217043_().m_216339_(0, 40) >= 17) {
                for (int j = 0; j < 16; ++j) {
                    summonerEntity.spawnFlames(entity.m_20185_() + (double)Mth.m_14089_((float)((float)Mth.m_14136_((double)(this.target.m_20189_() - entity.m_20189_()), (double)(this.target.m_20185_() - summonerEntity.m_20185_())))) * (1.25 * (double)(j + 1)), entity.m_20189_() + (double)Mth.m_14031_((float)((float)Mth.m_14136_((double)(this.target.m_20189_() - entity.m_20189_()), (double)(this.target.m_20185_() - summonerEntity.m_20185_())))) * (1.25 * (double)(j + 1)), Math.min(this.target.m_20186_(), summonerEntity.m_20186_()), Math.max(this.target.m_20186_(), summonerEntity.m_20186_()) + 1.0);
                }
            } else {
                summonerEntity.spawnWave();
            }
        }
        if (entity instanceof MancubusEntity) {
            MancubusEntity mancubusEntity = (MancubusEntity)((Object)entity);
            if ((double)mancubusEntity.m_20270_((Entity)this.target) < 8.0 && (double)mancubusEntity.m_20270_((Entity)this.target) > 3.0) {
                mancubusEntity.shootMancubus(MCDoom.config.mancubus_ranged_damage);
            } else {
                mancubusEntity.shootBaron(MCDoom.config.mancubus_ranged_damage, 0.0, 0.0, 0.0);
            }
        }
        if (entity instanceof MotherDemonEntity) {
            MotherDemonEntity motherdemonEntity = (MotherDemonEntity)entity;
            this.motherDemonAttacks(motherdemonEntity);
        }
        if (entity instanceof PossessedScientistEntity) {
            ((DemonEntity)((Object)entity)).throwPotion(this.target);
        }
        if (entity instanceof DoomHunterEntity) {
            DoomHunterEntity doomHunterEntity = (DoomHunterEntity)((Object)entity);
            this.doomHunterAttacks(doomHunterEntity);
        }
        if (entity instanceof PainEntity) {
            PainEntity painEntity = (PainEntity)((Object)entity);
            this.painAttacks(painEntity);
        }
        if (entity instanceof ArchMakyrEntity) {
            ArchMakyrEntity archMakyrEntity = (ArchMakyrEntity)entity;
            this.archMakyrAttacks(archMakyrEntity);
        }
        if (entity instanceof IconofsinEntity) {
            IconofsinEntity iconEntity = (IconofsinEntity)entity;
            this.iconAttacks(iconEntity);
        }
        if (entity instanceof GladiatorEntity) {
            GladiatorEntity gladiatorEntity = (GladiatorEntity)entity;
            this.gladiatorAttacks(gladiatorEntity);
        }
    }

    private void hitScanAttack(LivingEntity livingEntity) {
        AABB aabb = livingEntity.m_20191_().m_82400_(16.0);
        TargetingConditions checkBlocking = TargetingConditions.m_148352_().m_26883_(16.0).m_26888_(target1 -> !target1.m_21211_().m_150930_(Items.f_42740_));
        livingEntity.m_9236_().m_45971_(LivingEntity.class, checkBlocking, livingEntity, aabb).stream().findFirst().ifPresent(target2 -> {
            BehaviorUtils.m_22595_((LivingEntity)livingEntity, (LivingEntity)target2);
            target2.m_6469_(livingEntity.m_269291_().m_269333_(livingEntity), livingEntity instanceof ChaingunnerEntity ? MCDoom.config.chaingun_bullet_damage : this.damage.floatValue());
        });
    }

    private void marauderAttacks(MarauderEntity marauderEntity) {
        AABB aabb = marauderEntity.m_20191_().m_82400_(16.0);
        TargetingConditions checkBlocking = TargetingConditions.m_148352_().m_26883_(16.0).m_26888_(target1 -> !target1.m_21211_().m_150930_(Items.f_42740_));
        marauderEntity.m_9236_().m_45971_(LivingEntity.class, checkBlocking, (LivingEntity)marauderEntity, aabb).stream().findFirst().ifPresent(target2 -> {
            BehaviorUtils.m_22595_((LivingEntity)marauderEntity, (LivingEntity)target2);
            target2.m_6469_(marauderEntity.m_269291_().m_269333_((LivingEntity)marauderEntity), this.damage.floatValue());
        });
    }

    private void archvileAttacks(ArchvileEntity archvileEntity) {
        archvileEntity.m_9236_().m_45933_((Entity)archvileEntity, new AABB(archvileEntity.m_20183_().m_7494_()).m_82377_(24.0, 24.0, 24.0)).forEach(e -> {
            if (e instanceof Mob) {
                Mob mob = (Mob)e;
                mob.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 1000, 1));
            }
        });
        assert (this.target != null);
        double d = Math.min(this.target.m_20186_(), archvileEntity.m_20186_());
        double e2 = Math.max(this.target.m_20186_(), archvileEntity.m_20186_()) + 1.0;
        float f = (float)Mth.m_14136_((double)(this.target.m_20189_() - archvileEntity.m_20189_()), (double)(this.target.m_20185_() - archvileEntity.m_20185_()));
        if ((double)archvileEntity.m_20270_((Entity)this.target) < 8.0) {
            float h;
            int j;
            for (j = 0; j < 15; ++j) {
                h = f + (float)j * (float)Math.PI * 0.4f;
                archvileEntity.spawnFlames(archvileEntity.m_20185_() + (double)Mth.m_14089_((float)h) * 1.5, archvileEntity.m_20189_() + (double)Mth.m_14031_((float)h) * 1.5, d, e2);
            }
            for (j = 0; j < 18; ++j) {
                h = f + (float)j * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                archvileEntity.spawnFlames(archvileEntity.m_20185_() + (double)Mth.m_14089_((float)h) * 2.5, archvileEntity.m_20189_() + (double)Mth.m_14031_((float)h) * 2.5, d, e2);
            }
        } else {
            for (int j = 0; j < 26; ++j) {
                double l1 = 1.25 * (double)(j + 1);
                archvileEntity.spawnFlames(archvileEntity.m_20185_() + (double)Mth.m_14089_((float)f) * l1, archvileEntity.m_20189_() + (double)Mth.m_14031_((float)f) * l1, d, e2);
            }
        }
    }

    private void motherDemonAttacks(MotherDemonEntity motherdemonEntity) {
        TentacleEntity tentacleEntity = (TentacleEntity)Services.ENTITIES_HELPER.getTentacleEntity().m_20615_(motherdemonEntity.m_9236_());
        assert (tentacleEntity != null);
        assert (this.target != null);
        tentacleEntity.m_7678_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_(), 0.0f, 0.0f);
        motherdemonEntity.m_9236_().m_7967_((Entity)tentacleEntity);
        if ((double)motherdemonEntity.m_21223_() <= (double)motherdemonEntity.m_21233_() * 0.5) {
            for (int l = 0; l < 32; ++l) {
                float f1 = (float)Mth.m_14136_((double)(this.target.m_20189_() - motherdemonEntity.m_20189_()), (double)(this.target.m_20185_() - motherdemonEntity.m_20185_())) + (float)l * (float)Math.PI * 0.4f;
                for (int y = 0; y < 5; ++y) {
                    motherdemonEntity.spawnFlames(this.target.m_20185_() + (double)Mth.m_14089_((float)f1) * this.target.m_217043_().m_188500_() * 1.5, this.target.m_20189_() + (double)Mth.m_14031_((float)f1) * this.target.m_217043_().m_188500_() * 1.5, Math.min(this.target.m_20186_(), this.target.m_20186_()), Math.max(this.target.m_20186_(), this.target.m_20186_()) + 1.0);
                }
            }
            this.target.m_20256_(this.target.m_20184_().m_82542_((double)0.4f, (double)1.4f, (double)0.4f));
        } else {
            motherdemonEntity.shootFireball(MCDoom.config.motherdemon_ranged_damage + this.extraMotherDemonDamage(motherdemonEntity), 0);
            motherdemonEntity.shootFireball(MCDoom.config.motherdemon_ranged_damage + this.extraMotherDemonDamage(motherdemonEntity), 3);
            motherdemonEntity.shootFireball(MCDoom.config.motherdemon_ranged_damage + this.extraMotherDemonDamage(motherdemonEntity), -3);
        }
    }

    private float extraMotherDemonDamage(MotherDemonEntity motherDemonEntity) {
        if (motherDemonEntity.getDeathState() == 1) {
            return MCDoom.config.motherdemon_phaseone_damage_boos;
        }
        return 0.0f;
    }

    private void doomHunterAttacks(DoomHunterEntity doomHunterEntity) {
        if (doomHunterEntity.getDeathState() == 1) {
            for (int l = 0; l < 16; ++l) {
                assert (this.target != null);
                doomHunterEntity.spawnFlames(doomHunterEntity.m_20185_() + (double)Mth.m_14089_((float)((float)Mth.m_14136_((double)(this.target.m_20189_() - doomHunterEntity.m_20189_()), (double)(this.target.m_20185_() - doomHunterEntity.m_20185_())))) * 1.25 * (double)(l + 1), doomHunterEntity.m_20189_() + (double)Mth.m_14031_((float)((float)Mth.m_14136_((double)(this.target.m_20189_() - doomHunterEntity.m_20189_()), (double)(this.target.m_20185_() - doomHunterEntity.m_20185_())))) * 1.25 * (double)(l + 1), Math.min(this.target.m_20186_(), this.target.m_20186_()), Math.max(this.target.m_20186_(), this.target.m_20186_()) + 1.0);
            }
        }
        if (doomHunterEntity.getDeathState() == 0) {
            doomHunterEntity.shootRocket(MCDoom.config.doomhunter_ranged_damage + (doomHunterEntity.getDeathState() == 1 ? MCDoom.config.doomhunter_extra_phase_two_damage : 0.0f));
        }
    }

    private void painAttacks(PainEntity painEntity) {
        painEntity.m_5496_(Services.SOUNDS_HELPER.getPAIN_HURT(), 1.0f, 1.0f);
        LostSoulEntity lostSoul = (LostSoulEntity)Services.ENTITIES_HELPER.getLostSoulEntity().m_20615_(painEntity.m_9236_());
        assert (lostSoul != null);
        lostSoul.m_7678_(painEntity.m_20185_(), painEntity.m_20186_(), painEntity.m_20189_(), 0.0f, 0.0f);
        painEntity.m_9236_().m_7967_((Entity)lostSoul);
        if (painEntity.getVariant() == 2) {
            LostSoulEntity lostSoul1 = (LostSoulEntity)Services.ENTITIES_HELPER.getLostSoulEntity().m_20615_(painEntity.m_9236_());
            assert (lostSoul1 != null);
            lostSoul1.m_7678_(painEntity.m_20185_(), painEntity.m_20186_(), painEntity.m_20189_(), 0.0f, 0.0f);
            painEntity.m_9236_().m_7967_((Entity)lostSoul1);
        }
        CommonUtils.spawnLightSource((Entity)painEntity, painEntity.m_9236_().m_46801_(painEntity.m_20183_()));
    }

    private void archMakyrAttacks(ArchMakyrEntity archMakyrEntity) {
        if (archMakyrEntity.m_217043_().m_216339_(0, 4) == 1) {
            archMakyrEntity.shootFireball(MCDoom.config.archmaykr_ranged_damage + this.extraArchMaykerDamage(archMakyrEntity), 0);
        } else {
            for (int i = 1; i < 5; ++i) {
                assert (this.target != null);
                float f1 = (float)Mth.m_14136_((double)(this.target.m_20189_() - archMakyrEntity.m_20189_()), (double)(this.target.m_20185_() - archMakyrEntity.m_20185_())) + (float)i * (float)Math.PI * 0.4f;
                for (int y = 0; y < 5; ++y) {
                    archMakyrEntity.spawnFlames(this.target.m_20185_() + (double)Mth.m_14089_((float)f1) * this.target.m_217043_().m_188500_() * 1.5, this.target.m_20189_() + (double)Mth.m_14031_((float)f1) * this.target.m_217043_().m_188500_() * 1.5, Math.min(this.target.m_20186_(), this.target.m_20186_()), Math.max(this.target.m_20186_(), this.target.m_20186_()) + 1.0);
                }
            }
            this.target.m_20256_(this.target.m_20184_().m_82542_((double)0.4f, (double)1.4f, (double)0.4f));
        }
    }

    private void iconAttacks(IconofsinEntity iconEntity) {
        int randomAttack = iconEntity.m_217043_().m_216339_(0, 4);
        if (randomAttack == 1) {
            for (int i = 1; i < 5; ++i) {
                assert (this.target != null);
                float f1 = (float)Mth.m_14136_((double)(this.target.m_20189_() - iconEntity.m_20189_()), (double)(this.target.m_20185_() - iconEntity.m_20185_())) + (float)i * (float)Math.PI * 0.4f;
                for (int y = 0; y < 5; ++y) {
                    iconEntity.spawnFlames(this.target.m_20185_() + (double)Mth.m_14089_((float)f1) * this.target.m_217043_().m_188500_() * 1.5, this.target.m_20189_() + (double)Mth.m_14031_((float)f1) * this.target.m_217043_().m_188500_() * 1.5, Math.min(this.target.m_20186_(), this.target.m_20186_()), Math.max(this.target.m_20186_(), this.target.m_20186_()) + 1.0);
                }
            }
            if ((double)iconEntity.m_21223_() < (double)iconEntity.m_21233_() * 0.5) {
                iconEntity.setAttackingState(6);
            } else {
                iconEntity.setAttackingState(5);
            }
        } else {
            iconEntity.shootFireball(MCDoom.config.icon_melee_damage + (iconEntity.getDeathState() == 1 ? MCDoom.config.icon_phaseone_damage_boos : 0.0f), 0);
            if ((double)iconEntity.m_21223_() < (double)iconEntity.m_21233_() * 0.5) {
                iconEntity.setAttackingState(2);
            } else {
                iconEntity.setAttackingState(1);
            }
        }
    }

    private void gladiatorAttacks(GladiatorEntity gladiatorEntity) {
        if (gladiatorEntity.getDeathState() == 0) {
            AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(gladiatorEntity.m_9236_(), gladiatorEntity.m_20185_(), gladiatorEntity.m_20186_(), gladiatorEntity.m_20189_());
            areaeffectcloudentity.m_19724_((ParticleOptions)ParticleTypes.f_123745_);
            areaeffectcloudentity.m_19712_(3.0f);
            areaeffectcloudentity.m_19734_(10);
            areaeffectcloudentity.m_6034_(gladiatorEntity.m_20185_(), gladiatorEntity.m_20186_(), gladiatorEntity.m_20189_());
            gladiatorEntity.m_9236_().m_7967_((Entity)areaeffectcloudentity);
            gladiatorEntity.shootFireball(MCDoom.config.gladiator_ranged_damage + (gladiatorEntity.getDeathState() == 1 ? MCDoom.config.gladiator_phaseone_damage_boost : 0.0f), 0);
        } else {
            gladiatorEntity.shootMace();
        }
    }

    private float extraArchMaykerDamage(ArchMakyrEntity archMakyrEntity) {
        if (archMakyrEntity.getDeathState() == 1) {
            return MCDoom.config.archmaykr_phaseone_damage_boost;
        }
        if (archMakyrEntity.getDeathState() == 2) {
            return MCDoom.config.archmaykr_phasetwo_damage_boost;
        }
        if (archMakyrEntity.getDeathState() == 3) {
            return MCDoom.config.archmaykr_phasethree_damage_boost;
        }
        if (archMakyrEntity.getDeathState() == 4) {
            return MCDoom.config.archmaykr_phasefour_damage_boost;
        }
        return 0.0f;
    }
}

