/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entities.tierambient;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.doom.MCDoom;
import mod.azure.doom.entities.DemonEntity;
import mod.azure.doom.entities.DoomAnimationsDefault;
import mod.azure.doom.entities.task.DemonMeleeAttack;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.custom.UnreachableTargetSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import org.jetbrains.annotations.NotNull;

public class CueBallEntity
extends DemonEntity
implements SmartBrainOwner<CueBallEntity> {
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(CueBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FUSE_SPEED = SynchedEntityData.m_135353_(CueBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CHARGED = SynchedEntityData.m_135353_(CueBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IGNITED = SynchedEntityData.m_135353_(CueBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private int currentFuseTime;
    private int fuseTime = 30;
    private int explosionRadius = 4;

    public CueBallEntity(EntityType<CueBallEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder m_21552_() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22276_, MCDoom.config.cueball_health).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22282_, 0.0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, event -> {
            if (event.isMoving()) {
                return event.setAndContinue(DoomAnimationsDefault.WALK);
            }
            if (this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_() && ((CueBallEntity)event.getAnimatable()).getVariant() == 3) {
                return event.setAndContinue(DoomAnimationsDefault.DEATH);
            }
            return event.setAndContinue(DoomAnimationsDefault.IDLE);
        }).triggerableAnim("death", DoomAnimationsDefault.DEATH)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_147240_(double strength, double x, double z) {
        super.m_147240_(3.0, x, z);
    }

    @Override
    protected void m_6153_() {
        ++this.f_20919_;
        if (this.getVariant() != 3) {
            if (this.f_20919_ == 30) {
                this.m_142687_(Entity.RemovalReason.KILLED);
                if (!this.m_9236_().f_46443_) {
                    this.explode();
                }
            }
        } else if (this.f_20919_ == 5) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            if (!this.m_9236_().f_46443_) {
                AABB aabb = new AABB(this.m_20183_().m_7494_()).m_82377_(24.0, 24.0, 24.0);
                this.m_9236_().m_45976_(DemonEntity.class, aabb).forEach(e -> {
                    if (e.m_6084_()) {
                        e.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 1000, 1));
                    }
                });
            }
        }
    }

    protected void explode() {
        this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), 1.0f, Level.ExplosionInteraction.NONE);
    }

    protected void m_8024_() {
        this.tickBrain((LivingEntity)this);
        super.m_8024_();
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Brain.Provider<?> m_5490_() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<ExtendedSensor<CueBallEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyLivingEntitySensor().setPredicate((target, entity) -> target.m_6084_() && entity.m_142582_((Entity)target) && !(target instanceof DemonEntity)), new HurtBySensor(), new UnreachableTargetSensor()});
    }

    public BrainActivityGroup<CueBallEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget(), new LookAtTargetSink(40, 300), new FloatToSurfaceOfFluid(), new MoveToWalkTarget()});
    }

    public BrainActivityGroup<CueBallEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate().alertAlliesWhen((mob, entity) -> this.m_5912_()), new SetPlayerLookTarget().stopIf(target -> {
            Player player;
            return !target.m_6084_() || target instanceof Player && (player = (Player)target).m_7500_();
        }), new SetRandomLookTarget()}), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().setRadius(20.0).speedModifier(0.75f), new Idle().runFor(entity -> entity.m_217043_().m_216339_(30, 60))})});
    }

    public BrainActivityGroup<CueBallEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((target, entity) -> !target.m_6084_()), new SetWalkTargetToAttackTarget().speedMod((owner, entity) -> Float.valueOf(0.85f)), new DemonMeleeAttack(0)});
    }

    public double m_142593_(LivingEntity livingEntity) {
        return this.m_20205_() * 1.5f * (this.m_20205_() * 1.5f + livingEntity.m_20205_());
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        double distance = this.m_20275_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
        return distance <= this.m_142593_(livingEntity);
    }

    protected void m_8099_() {
    }

    protected boolean shouldDrown() {
        return false;
    }

    protected boolean shouldBurnInDay() {
        return false;
    }

    public int m_5792_() {
        return 1;
    }

    public void m_8107_() {
        int i;
        super.m_8107_();
        this.flameTimer = (this.flameTimer + 1) % 2;
        if (this.m_9236_().f_46443_ && this.getVariant() == 3) {
            for (i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20208_(0.5), this.m_20187_() - 0.25, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
        if (this.m_6084_() && this.getVariant() != 3) {
            if (this.isIgnited()) {
                this.setFuseSpeed(1);
            }
            if ((i = this.getFuseSpeed()) > 0 && this.currentFuseTime == 0) {
                this.m_146850_(GameEvent.f_157776_);
            }
            this.currentFuseTime += i;
            if (this.currentFuseTime < 0) {
                this.currentFuseTime = 0;
            }
            if (this.currentFuseTime >= this.fuseTime) {
                this.currentFuseTime = this.fuseTime;
                if (!((double)this.m_21223_() < 0.01) && !this.m_21224_()) {
                    this.explode();
                }
                this.m_6074_();
            }
        }
    }

    public int getFlameTimer() {
        return this.flameTimer;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(FUSE_SPEED, (Object)-1);
        this.f_19804_.m_135372_(CHARGED, (Object)false);
        this.f_19804_.m_135372_(IGNITED, (Object)false);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(tag.m_128451_("Variant"));
        if (Boolean.TRUE.equals(this.f_19804_.m_135370_(CHARGED))) {
            tag.m_128379_("powered", true);
        }
        tag.m_128376_("Fuse", (short)this.fuseTime);
        tag.m_128344_("ExplosionRadius", (byte)this.explosionRadius);
        tag.m_128379_("ignited", this.isIgnited());
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
        this.f_19804_.m_135381_(CHARGED, (Object)tag.m_128471_("powered"));
        if (tag.m_128425_("Fuse", 99)) {
            this.fuseTime = tag.m_128448_("Fuse");
        }
        if (tag.m_128425_("ExplosionRadius", 99)) {
            this.explosionRadius = tag.m_128445_("ExplosionRadius");
        }
        if (tag.m_128471_("ignited")) {
            this.ignite();
        }
    }

    public int getVariant() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(VARIANT)), (int)1, (int)3);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public int getVariants() {
        return 3;
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        int random = this.m_217043_().m_216339_(0, 4);
        this.setVariant(random);
        return spawnDataIn;
    }

    public Component m_7770_() {
        if (this.getVariant() == 3) {
            return Component.m_237115_((String)"entity.doom.screecher");
        }
        if (this.getVariant() == 2) {
            return Component.m_237115_((String)"entity.doom.possessedengineer");
        }
        return super.m_7770_();
    }

    public int getFuseSpeed() {
        return (Integer)this.f_19804_.m_135370_(FUSE_SPEED);
    }

    public void setFuseSpeed(int fuseSpeed) {
        this.f_19804_.m_135381_(FUSE_SPEED, (Object)fuseSpeed);
    }

    public boolean isIgnited() {
        return (Boolean)this.f_19804_.m_135370_(IGNITED);
    }

    public void ignite() {
        this.f_19804_.m_135381_(IGNITED, (Object)true);
    }
}

