/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entities.tierambient;

import java.util.List;
import java.util.Objects;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.doom.MCDoom;
import mod.azure.doom.entities.DemonEntity;
import mod.azure.doom.entities.DoomAnimationsDefault;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class GoreNestEntity
extends DemonEntity
implements GeoEntity {
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private int spawnTimer = 0;

    public GoreNestEntity(EntityType<? extends GoreNestEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder m_21552_() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22276_, MCDoom.config.gorenest_health).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22282_, 0.0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "livingController", 0, event -> {
            if (this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_()) {
                return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("death"));
            }
            event.getController().setAnimationSpeed(0.25);
            return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
        }).triggerableAnim("death", DoomAnimationsDefault.DEATH)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_6138_() {
    }

    public void m_147240_(double strength, double x, double z) {
        super.m_147240_(0.0, 0.0, 0.0);
    }

    protected void m_6475_(@NotNull DamageSource source, float damageAmount) {
        if (source == this.m_269291_().m_287172_()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (!(source.m_7639_() instanceof Player)) {
            this.m_21153_(5.0f);
        }
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public void m_8107_() {
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)DustParticleOptions.f_123656_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, this.m_20208_(0.2), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
        ++this.spawnTimer;
        AABB aabb = new AABB(this.m_20183_()).m_82400_(64.0);
        int entityCount = this.m_9236_().m_142425_(EntityTypeTest.m_156916_(DemonEntity.class), aabb, Entity::m_6084_).size();
        if (this.spawnTimer == 800 && entityCount <= 15 && !this.m_21525_()) {
            this.spawnWave();
        }
        if (this.spawnTimer >= 810) {
            this.spawnTimer = 0;
        }
        super.m_8107_();
    }

    public void spawnWave() {
        List<String> waveEntries = List.of(MCDoom.config.gorenest_wave_entries);
        int random = this.m_217043_().m_216339_(-3, 3);
        for (int k = 1; k < 5; ++k) {
            Entity waveentity = ((EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(waveEntries.get(this.m_217043_().m_188503_(waveEntries.size()))))).m_20615_(this.m_9236_());
            Objects.requireNonNull(waveentity).m_6034_(this.m_20185_() + (double)random, this.m_20186_() + 0.5, this.m_20189_() + (double)random);
            this.m_9236_().m_7967_(waveentity);
        }
    }

    protected boolean shouldDrown() {
        return false;
    }

    protected boolean shouldBurnInDay() {
        return false;
    }
}

