/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.entities.tierheavy;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.object.PlayState;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.doom.MCDoom;
import mod.azure.doom.entities.DemonEntity;
import mod.azure.doom.entities.DoomAnimationsDefault;
import mod.azure.doom.entities.ai.DemonFlyControl;
import mod.azure.doom.entities.task.DemonMeleeAttack;
import mod.azure.doom.entities.task.DemonProjectileAttack;
import mod.azure.doom.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StayWithinDistanceOfAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.custom.UnreachableTargetSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import org.jetbrains.annotations.NotNull;

public class Revenant2016Entity
extends DemonEntity
implements SmartBrainOwner<Revenant2016Entity> {
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(Revenant2016Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public Revenant2016Entity(EntityType<Revenant2016Entity> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.f_21342_ = new DemonFlyControl(this);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder m_21552_() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22276_, MCDoom.config.revenant_health).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22278_, (double)0.6f).m_22268_(Attributes.f_22280_, 0.25).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22282_, 0.0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "livingController", 0, event -> {
            if (this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_()) {
                return event.setAndContinue(DoomAnimationsDefault.DEATH);
            }
            if (!(this.m_5912_() || !event.isMoving() || this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_())) {
                return event.setAndContinue(DoomAnimationsDefault.WALKING);
            }
            if (this.m_5912_() && event.isMoving() && !this.f_20890_ && !((double)this.m_21223_() < 0.01) && !this.m_21224_()) {
                return event.setAndContinue(DoomAnimationsDefault.FLYING);
            }
            if (!event.isCurrentAnimation(DoomAnimationsDefault.FLYING) && !event.isCurrentAnimation(DoomAnimationsDefault.WALKING)) {
                return event.setAndContinue(DoomAnimationsDefault.IDLE);
            }
            return PlayState.CONTINUE;
        }).triggerableAnim("death", DoomAnimationsDefault.DEATH)}).add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 0, event -> PlayState.STOP).setSoundKeyframeHandler(event -> {
            if (event.getKeyframeData().getSound().matches("attack") && this.m_9236_().m_5776_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getVariant() == 11 ? Services.SOUNDS_HELPER.getREVENANT_DOOT() : Services.SOUNDS_HELPER.getROCKET_FIRING(), SoundSource.HOSTILE, 0.25f, 1.0f, false);
            }
        }).triggerableAnim("ranged", DoomAnimationsDefault.RANGED).triggerableAnim("melee", DoomAnimationsDefault.MELEE)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(tag.m_128451_("Variant"));
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
    }

    public int getVariant() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(VARIANT)), (int)1, (int)11);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public int getVariants() {
        return 11;
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setVariant(this.f_19796_.m_188502_());
        return spawnDataIn;
    }

    protected void m_8024_() {
        this.tickBrain((LivingEntity)this);
        super.m_8024_();
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Brain.Provider<?> m_5490_() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<ExtendedSensor<Revenant2016Entity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyLivingEntitySensor().setPredicate((target, entity) -> target.m_6084_() && entity.m_142582_((Entity)target) && !(target instanceof DemonEntity)), new HurtBySensor(), new UnreachableTargetSensor()});
    }

    public BrainActivityGroup<Revenant2016Entity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget(), new LookAtTargetSink(40, 300), new FloatToSurfaceOfFluid(), new StayWithinDistanceOfAttackTarget().speedMod(0.25f), new MoveToWalkTarget()});
    }

    public BrainActivityGroup<Revenant2016Entity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate().alertAlliesWhen((mob, entity) -> this.m_5912_()), new SetPlayerLookTarget().stopIf(target -> {
            Player player;
            return !target.m_6084_() || target instanceof Player && (player = (Player)target).m_7500_();
        }), new SetRandomLookTarget()}), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().setRadius(20.0).speedModifier(1.0f), new Idle().runFor(entity -> entity.m_217043_().m_216339_(300, 600))})});
    }

    public BrainActivityGroup<Revenant2016Entity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((target, entity) -> !target.m_6084_() || !entity.m_142582_((Entity)target)), new SetWalkTargetToAttackTarget().speedMod((owner, target) -> Float.valueOf(1.05f)), new DemonProjectileAttack<DemonEntity>(5).attackInterval(mob -> 80).attackDamage(MCDoom.config.revenant_ranged_damage), new DemonMeleeAttack(5)});
    }

    public void m_7023_(@NotNull Vec3 movementInput) {
        if (this.m_5912_()) {
            if (this.m_20069_()) {
                this.m_19920_(0.02f, movementInput);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            } else if (this.m_20077_()) {
                this.m_19920_(0.02f, movementInput);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                BlockPos ground = BlockPos.m_274561_((double)this.m_20185_(), (double)(this.m_20186_() - 1.0), (double)this.m_20189_());
                float f = 0.91f;
                if (this.m_20096_()) {
                    f = this.m_9236_().m_8055_(ground).m_60734_().m_49958_() * 0.91f;
                }
                float f1 = 0.16277137f / (f * f * f);
                f = 0.91f;
                if (this.m_20096_()) {
                    f = this.m_9236_().m_8055_(ground).m_60734_().m_49958_() * 0.91f;
                }
                this.m_19920_(this.m_20096_() ? 0.1f * f1 : 0.02f, movementInput);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)f));
            }
        } else {
            super.m_7023_(movementInput);
        }
    }

    @Override
    @NotNull
    protected PathNavigation m_6037_(@NotNull Level worldIn) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, worldIn);
        flyingpathnavigator.m_26440_(false);
        flyingpathnavigator.m_7008_(true);
        flyingpathnavigator.m_26443_(true);
        return flyingpathnavigator;
    }

    protected void m_7840_(double y, boolean onGroundIn, @NotNull BlockState state, @NotNull BlockPos pos) {
    }

    protected void m_8022_() {
        boolean flag = this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_());
        this.f_21345_.m_25360_(Goal.Flag.LOOK, flag);
        super.m_8022_();
    }

    protected boolean shouldDrown() {
        return false;
    }

    protected boolean shouldBurnInDay() {
        return false;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return Services.SOUNDS_HELPER.getREVENANT_HURT();
    }

    protected SoundEvent m_5592_() {
        return Services.SOUNDS_HELPER.getREVENANT_DEATH();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12383_;
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState blockIn) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public int m_5792_() {
        return 7;
    }

    public void m_8107_() {
        super.m_8107_();
        this.flameTimer = (this.flameTimer + 1) % 8;
    }

    public int getFlameTimer() {
        return this.flameTimer;
    }
}

