/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.doom.helper;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.azure.doom.registry.NeoDoomItems;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class SoulCubeHandler {
    ClientLevel world;

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
        if (((ItemStack)evt.getObject()).m_41720_() != NeoDoomItems.SOULCUBE.get()) {
            return;
        }
        final ICurio curio = new ICurio(){

            public boolean canEquipFromUse(SlotContext slotContext) {
                return true;
            }

            public ItemStack getStack() {
                return new ItemStack((ItemLike)NeoDoomItems.SOULCUBE.get());
            }
        };
        ICapabilityProvider provider = new ICapabilityProvider(){
            private final LazyOptional<ICurio> curioOpt = LazyOptional.of(() -> curio);

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CuriosCapability.ITEM.orEmpty(cap, this.curioOpt);
            }
        };
        evt.addCapability(CuriosCapability.ID_ITEM, provider);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingDeath(LivingDeathEvent evt) {
        if (this.soulCube(evt.getEntity(), evt.getSource())) {
            evt.setCanceled(true);
        }
    }

    private boolean soulCube(LivingEntity livingEntity, DamageSource source) {
        for (ItemStack held : livingEntity.m_6167_()) {
            if (held.m_41720_() != NeoDoomItems.SOULCUBE.get()) continue;
            return false;
        }
        return CuriosApi.getCuriosHelper().findFirstCurio(livingEntity, (Item)NeoDoomItems.SOULCUBE.get()).map(soulcube -> {
            this.activateSoulCube(livingEntity, soulcube.stack());
            return true;
        }).orElse(false);
    }

    private void activateSoulCube(LivingEntity livingEntity, ItemStack soulcube) {
        ItemStack copy = soulcube.m_41777_();
        soulcube.m_41622_(1, livingEntity, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            CriteriaTriggers.f_10551_.m_74431_(serverPlayer, copy);
        }
        if (livingEntity instanceof Player) {
            livingEntity.m_21153_(20.0f);
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 4));
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 100, 4));
            livingEntity.m_9236_().m_7605_((Entity)livingEntity, (byte)90);
        }
    }
}

