/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.misc;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.DamageTypeTagsProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="iceandfire", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IafDamageRegistry {
    public static final ResourceKey<DamageType> GORGON_DMG_TYPE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("iceandfire:gorgon"));
    public static final ResourceKey<DamageType> DRAGON_FIRE_TYPE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("iceandfire:dragon_fire"));
    public static final ResourceKey<DamageType> DRAGON_ICE_TYPE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("iceandfire:dragon_ice"));
    public static final ResourceKey<DamageType> DRAGON_LIGHTNING_TYPE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("iceandfire:dragon_lightning"));

    public static CustomEntityDamageSource causeGorgonDamage(@javax.annotation.Nullable Entity entity) {
        Holder holder = (Holder)entity.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_203636_(GORGON_DMG_TYPE).get();
        return new CustomEntityDamageSource((Holder<DamageType>)holder, entity);
    }

    public static CustomEntityDamageSource causeDragonFireDamage(@javax.annotation.Nullable Entity entity) {
        Holder holder = (Holder)entity.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_203636_(DRAGON_FIRE_TYPE).get();
        return new CustomEntityDamageSource((Holder<DamageType>)holder, entity);
    }

    public static CustomIndirectEntityDamageSource causeIndirectDragonFireDamage(Entity source, @javax.annotation.Nullable Entity indirectEntityIn) {
        Holder holder = (Holder)indirectEntityIn.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_203636_(DRAGON_FIRE_TYPE).get();
        return new CustomIndirectEntityDamageSource((Holder<DamageType>)holder, source, indirectEntityIn);
    }

    public static CustomEntityDamageSource causeDragonIceDamage(@javax.annotation.Nullable Entity entity) {
        Holder holder = (Holder)entity.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_203636_(DRAGON_ICE_TYPE).get();
        return new CustomEntityDamageSource((Holder<DamageType>)holder, entity);
    }

    public static CustomIndirectEntityDamageSource causeIndirectDragonIceDamage(Entity source, @javax.annotation.Nullable Entity indirectEntityIn) {
        Holder holder = (Holder)indirectEntityIn.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_203636_(DRAGON_ICE_TYPE).get();
        return new CustomIndirectEntityDamageSource((Holder<DamageType>)holder, source, indirectEntityIn);
    }

    public static CustomEntityDamageSource causeDragonLightningDamage(@javax.annotation.Nullable Entity entity) {
        Holder holder = (Holder)entity.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_203636_(DRAGON_LIGHTNING_TYPE).get();
        return new CustomEntityDamageSource((Holder<DamageType>)holder, entity);
    }

    public static CustomIndirectEntityDamageSource causeIndirectDragonLightningDamage(Entity source, @javax.annotation.Nullable Entity indirectEntityIn) {
        Holder holder = (Holder)indirectEntityIn.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_203636_(DRAGON_LIGHTNING_TYPE).get();
        return new CustomIndirectEntityDamageSource((Holder<DamageType>)holder, source, indirectEntityIn);
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent event) {
        event.getGenerator().addProvider(event.includeServer(), output -> new IafDamageTypeTagsProvider(event.getGenerator().getPackOutput(), event.getLookupProvider(), "iceandfire", event.getExistingFileHelper()));
    }

    static class CustomEntityDamageSource
    extends DamageSource {
        public CustomEntityDamageSource(Holder<DamageType> damageTypeIn, @javax.annotation.Nullable Entity damageSourceEntityIn) {
            super(damageTypeIn, damageSourceEntityIn);
        }

        @NotNull
        public Component m_6157_(LivingEntity entityLivingBaseIn) {
            LivingEntity livingentity = entityLivingBaseIn.m_21232_();
            String s = "death.attack." + this.m_19385_();
            int index = entityLivingBaseIn.m_217043_().m_188503_(2);
            String s1 = s + "." + index;
            String s2 = s + ".attacker_" + index;
            return livingentity != null ? Component.m_237110_((String)s2, (Object[])new Object[]{entityLivingBaseIn.m_5446_(), livingentity.m_5446_()}) : Component.m_237110_((String)s1, (Object[])new Object[]{entityLivingBaseIn.m_5446_()});
        }
    }

    static class CustomIndirectEntityDamageSource
    extends DamageSource {
        public CustomIndirectEntityDamageSource(Holder<DamageType> damageTypeIn, Entity source, @javax.annotation.Nullable Entity indirectEntityIn) {
            super(damageTypeIn, source, indirectEntityIn);
        }

        @NotNull
        public Component m_6157_(LivingEntity entityLivingBaseIn) {
            LivingEntity livingentity = entityLivingBaseIn.m_21232_();
            String s = "death.attack." + this.m_19385_();
            int index = entityLivingBaseIn.m_217043_().m_188503_(2);
            String s1 = s + "." + index;
            String s2 = s + ".attacker_" + index;
            return livingentity != null ? Component.m_237110_((String)s2, (Object[])new Object[]{entityLivingBaseIn.m_5446_(), livingentity.m_5446_()}) : Component.m_237110_((String)s1, (Object[])new Object[]{entityLivingBaseIn.m_5446_()});
        }
    }

    public static class IafDamageTypeTagsProvider
    extends DamageTypeTagsProvider {
        public IafDamageTypeTagsProvider(PackOutput p_270719_, CompletableFuture<HolderLookup.Provider> p_270256_, String modId, @Nullable ExistingFileHelper existingFileHelper) {
            super(p_270719_, p_270256_, modId, existingFileHelper);
        }

        public void m_6577_(HolderLookup.Provider pProvider) {
            this.m_206424_(DamageTypeTags.f_268490_).m_255204_(GORGON_DMG_TYPE);
            this.m_206424_(DamageTypeTags.f_268437_).m_255204_(GORGON_DMG_TYPE);
        }
    }
}

