/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg;

import dev.tauri.jsg.advancements.JSGAdvancements;
import dev.tauri.jsg.api.item.NotebookPageSerialization;
import dev.tauri.jsg.command.JSGCommands;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.config.stargate.StargateDimensionConfig;
import dev.tauri.jsg.config.stargate.StargateRIGConfig;
import dev.tauri.jsg.integration.cctweaked.CCIntegrationWrapper;
import dev.tauri.jsg.integration.create.CreateIntegrationManager;
import dev.tauri.jsg.integration.oc2.OCIntegrationWrapper;
import dev.tauri.jsg.model.JSGBlockModel;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.recipes.NotebookRecipe;
import dev.tauri.jsg.recipes.PageAndUniverseDialerRecipe;
import dev.tauri.jsg.recipes.StargateOrlinBaseBlockRecipe;
import dev.tauri.jsg.recipes.UniverseDialerCloneRecipe;
import dev.tauri.jsg.registry.BlockEntityRegistry;
import dev.tauri.jsg.registry.BlockRegistry;
import dev.tauri.jsg.registry.EntityRegistry;
import dev.tauri.jsg.registry.FluidRegistry;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.registry.MenuTypeRegistry;
import dev.tauri.jsg.registry.SoundRegistry;
import dev.tauri.jsg.registry.TabRegistry;
import dev.tauri.jsg.registry.VillagerRegistry;
import dev.tauri.jsg.renderer.entity.MastadgeRenderer;
import dev.tauri.jsg.screen.inventory.dialhomedevice.DHDContainerGui;
import dev.tauri.jsg.screen.inventory.energy.capacitor.CapacitorContainerGui;
import dev.tauri.jsg.screen.inventory.stargate.StargateContainerGui;
import dev.tauri.jsg.stargate.StargateSizeEnum;
import dev.tauri.jsg.stargate.network.StargateNetwork;
import dev.tauri.jsg.stargate.network.StargateReservedAddresses;
import dev.tauri.jsg.util.updater.GetUpdate;
import dev.tauri.jsg.worldgen.dimension.SpecialStructuresHandler;
import dev.tauri.jsg.worldgen.village.TemplatePoolsAdditions;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.util.LoaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="jsg")
public class JSG {
    public static final String MOD_ID = "jsg";
    public static final String MOD_NAME = "Just Stargate Mod";
    public static Logger logger;
    public static final String CONFIG_DIMENSIONS_VERSION = "2.0";
    public static String MOD_VERSION;
    public static final String MC_VERSION = "1.20.1";
    public static final String CONFIG_GENERAL_VERSION = "2.0";
    public static File modConfigDir;
    public static File modsDirectory;
    public static File clientModPath;
    public static boolean embeddiumInstalled;
    public static MinecraftServer currentServer;
    public static OCIntegrationWrapper ocWrapper;
    private static final String OC_WRAPPER_LOADED = "dev.tauri.jsg.integration.oc2.OCIntegrationLoaded";
    private static final String OC_WRAPPER_NOT_LOADED = "dev.tauri.jsg.integration.oc2.OCIntegrationNotLoaded";
    public static CCIntegrationWrapper ccWrapper;
    private static final String CC_WRAPPER_LOADED = "dev.tauri.jsg.integration.cctweaked.CCIntegrationLoaded";
    private static final String CC_WRAPPER_NOT_LOADED = "dev.tauri.jsg.integration.cctweaked.CCIntegrationNotLoaded";
    public static long memoryTotal;
    public static double neededMemory;
    public static final String[] WELCOME_MESS;
    public static BlockPos lastPlayerPosInWorld;

    public static void displayWelcomeMessage() {
        for (String s : WELCOME_MESS) {
            logger.info(s.replaceAll("\\{version}", MOD_VERSION));
        }
    }

    public static Component getInProgress() {
        return Component.m_237113_((String)(String.valueOf(ChatFormatting.AQUA) + "Work In Progress Item!"));
    }

    public JSG() {
        logger = LoggerFactory.getLogger((String)MOD_NAME);
        ModList.get().getModContainerById(MOD_ID).ifPresentOrElse(container -> {
            MOD_VERSION = "1.20.1-" + container.getModInfo().getVersion().getQualifier();
            clientModPath = container.getModInfo().getOwningFile().getFile().getFilePath().toFile();
        }, () -> {});
        if (ModList.get().isLoaded("embeddium") || ModList.get().isLoaded("sodium") || ModList.get().isLoaded("optifine") || ModList.get().isLoaded("rubiddium") || ModList.get().isLoaded("iris") || ModList.get().isLoaded("oculus")) {
            embeddiumInstalled = true;
        }
        modConfigDir = FMLPaths.CONFIGDIR.get().toFile();
        modsDirectory = FMLPaths.MODSDIR.get().toFile();
        memoryTotal = Runtime.getRuntime().maxMemory();
        logger.info("Started loading JSG mod in " + clientModPath.getAbsolutePath());
        logger.info("Mods directory: " + modsDirectory.getAbsolutePath());
        logger.info("Loading JSG version " + MOD_VERSION);
        if ((double)memoryTotal < neededMemory) {
            throw new LoaderException("JSG mod requires " + String.format("%.2f", neededMemory / 1024.0 / 1024.0) + "MB of allocated RAM as minimum! (got " + String.format("%.2f", (double)memoryTotal / 1024.0 / 1024.0) + "MB)");
        }
        JSGConfig.load();
        JSGConfig.register();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        SoundRegistry.load();
        MenuTypeRegistry.register(modEventBus);
        FluidRegistry.register(modEventBus);
        logger.info("Successfully registered Fluids!");
        ItemRegistry.register(modEventBus);
        BlockRegistry.register(modEventBus);
        TabRegistry.register(modEventBus);
        BlockEntityRegistry.register(modEventBus);
        SoundRegistry.register(modEventBus);
        EntityRegistry.register(modEventBus);
        VillagerRegistry.register(modEventBus);
        NotebookPageSerialization.registerInternal();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(BlockEntityRegistry::registerBERs);
        MinecraftForge.EVENT_BUS.register((Object)this);
        JSGPacketHandler.init();
        logger.info("Successfully registered Packets!");
        StargateDimensionConfig.INSTANCE.load(modConfigDir);
        logger.info("Successfully registered Dimensions!");
        StargateRIGConfig.INSTANCE.load(modConfigDir);
        logger.info("Successfully registered RIG config!");
        StargateSizeEnum.init();
        logger.info("Successfully registered Stargate Sizes!");
        SpecialStructuresHandler.register();
        JSG.registerOC();
        JSG.registerCC();
        CreateIntegrationManager.registerCreate();
        TemplatePoolsAdditions.injectStructureTemplatePool();
        JSG.displayWelcomeMessage();
        Runtime.getRuntime().addShutdownHook(new Thread(JSG::shutDown));
    }

    public static void registerOC() {
        try {
            if (ModList.get().isLoaded("oc2") || ModList.get().isLoaded("oc2r")) {
                logger.info("OpenComputers found and connection is enabled... Connecting...");
                ocWrapper = (OCIntegrationWrapper)Class.forName(OC_WRAPPER_LOADED).getConstructor(new Class[0]).newInstance(new Object[0]);
                logger.info("Successfully connected into OpenComputers!");
            } else {
                ocWrapper = (OCIntegrationWrapper)Class.forName(OC_WRAPPER_NOT_LOADED).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            logger.error("Exception loading OpenComputers wrapper", (Throwable)e);
        }
    }

    public static void registerCC() {
        try {
            if (ModList.get().isLoaded("computercraft")) {
                logger.info("ComputerCraft found and connection is enabled... Connecting...");
                ccWrapper = (CCIntegrationWrapper)Class.forName(CC_WRAPPER_LOADED).getConstructor(new Class[0]).newInstance(new Object[0]);
                logger.info("Successfully connected into ComputerCraft!");
            } else {
                ccWrapper = (CCIntegrationWrapper)Class.forName(CC_WRAPPER_NOT_LOADED).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            logger.error("Exception loading ComputerCraft wrapper", (Throwable)e);
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        JSGAdvancements.register();
        FluidRegistry.registerCauldrons();
    }

    @SubscribeEvent
    public void loadCompleteServer(FMLLoadCompleteEvent event) {
        logger.info("Just Stargate Mod loading completed!");
    }

    public static void shutDown() {
        logger.info("Good bye! Thank you for using Just Stargate Mod :)");
    }

    @SubscribeEvent
    public void onServerBeginStarting(ServerAboutToStartEvent event) {
        currentServer = event.getServer();
        TemplatePoolsAdditions.runVillageAdditionsAdder();
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        currentServer = event.getServer();
        new StargateNetwork().register(currentServer.m_129783_().m_8895_());
        StargateReservedAddresses.register();
        SpecialStructuresHandler.tryGenerateStructures(currentServer);
    }

    @SubscribeEvent
    public void serverStarted(ServerStartedEvent event) throws IOException {
        StargateDimensionConfig.INSTANCE.reload(event.getServer());
        StargateRIGConfig.INSTANCE.reload(event.getServer());
        RecipeManager recipeManager = event.getServer().m_129894_();
        Collection recipes = recipeManager.m_44051_();
        recipes.add(new NotebookRecipe());
        recipes.add(new UniverseDialerCloneRecipe());
        recipes.add(new PageAndUniverseDialerRecipe());
        recipes.add(new StargateOrlinBaseBlockRecipe());
        recipeManager.m_44024_((Iterable)recipes);
        logger.info("Server started!");
    }

    @SubscribeEvent
    public void onCommandsRegister(RegisterCommandsEvent event) {
        JSGCommands.registerCommands(event);
    }

    @SubscribeEvent
    public void addCreative(BuildCreativeModeTabContentsEvent event) {
    }

    static {
        MOD_VERSION = "";
        embeddiumInstalled = false;
        currentServer = null;
        memoryTotal = 0L;
        neededMemory = 1.073741824E9;
        WELCOME_MESS = new String[]{"=======================================", "|     $$$$$\\  $$$$$$\\   $$$$$$\\", "|     \\__$$ |$$  __$$\\ $$  __$$\\", "|        $$ |$$ /  \\__|$$ /  \\__|", "|        $$ |\\$$$$$$\\  $$ |$$$$\\", "|  $$\\   $$ | \\____$$\\ $$ |\\_$$ |", "|  $$ |  $$ |$$\\   $$ |$$ |  $$ |", "|  \\$$$$$$  |\\$$$$$$  |\\$$$$$$  |", "|   \\______/  \\______/  \\______/", "", " Authors: Tau'ri Dev team", " Wiki: https://justsgmod.eu/wiki", " Version: {version}", "======================================="};
        lastPlayerPosInWorld = new BlockPos(0, 0, 0);
    }

    @Mod.EventBusSubscriber(modid="jsg", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                MenuScreens.m_96206_((MenuType)((MenuType)MenuTypeRegistry.STARGATE_MENU_TYPE.get()), StargateContainerGui::new);
                MenuScreens.m_96206_((MenuType)((MenuType)MenuTypeRegistry.CAPACITOR_MENU_TYPE.get()), CapacitorContainerGui::new);
                MenuScreens.m_96206_((MenuType)((MenuType)MenuTypeRegistry.DHD_MENU_TYPE.get()), DHDContainerGui::new);
            });
            EntityRenderers.m_174036_((EntityType)((EntityType)EntityRegistry.MASTADGE.get()), MastadgeRenderer::new);
            GetUpdate.checkForUpdateVoid();
        }

        @SubscribeEvent
        public static void onLoadersRegister(ModelEvent.RegisterGeometryLoaders event) {
            event.register("handheld_item_model", (IGeometryLoader)JSGBlockModel.Loader.INSTANCE);
        }

        public static class LoadingStats {
            public static int loadedTextures = 0;
            public static int notLoadedTextures = 0;
            public static int loadedModels = 0;
            public static int notLoadedModels = 0;
        }
    }
}

