/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.api.loader;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.loader.FolderLoader;
import java.util.Collections;
import java.util.List;

public class JarResourcesScanner {
    protected final Class<?> modMainClass;
    protected final String modId;
    protected String path = null;
    protected String[] fileEnds = null;

    public static JarResourcesScanner createScanner(String modId, Class<?> modMainClass) {
        return new JarResourcesScanner(modId, modMainClass);
    }

    private JarResourcesScanner(String modId, Class<?> modMainClass) {
        this.modMainClass = modMainClass;
        this.modId = modId;
        JSG.logger.info("Created FolderLoader for domain " + modId);
    }

    public List<String> getFiles() {
        if (this.path == null) {
            return Collections.emptyList();
        }
        if (this.fileEnds == null) {
            return Collections.emptyList();
        }
        try {
            return FolderLoader.getAllFiles(this.modMainClass, this.modId, this.path, this.fileEnds);
        }
        catch (Exception e) {
            JSG.logger.error("Error while getting files from folder " + this.path + " for domain " + this.modId);
            return Collections.emptyList();
        }
    }
}

