/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.block.cauldron;

import dev.tauri.jsg.helpers.FluidHelper;
import dev.tauri.jsg.helpers.ItemHandlerHelper;
import it.unimi.dsi.fastutil.Pair;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class JSGFluidCauldron
extends AbstractCauldronBlock {
    public final Map<Item, CauldronInteraction> publicInteractionMap;

    public static JSGFluidCauldron create() {
        return new JSGFluidCauldron((Map<Item, CauldronInteraction>)CauldronInteraction.m_175617_());
    }

    public static CauldronInteraction getItemDropInteraction(Supplier<ItemStack> result, boolean emptyCauldron, boolean emptyStack, boolean shrinkStack) {
        return (cauldronState, level, cauldronPos, player, hand, clickedStack) -> {
            if (level.f_46443_) {
                return InteractionResult.m_19078_((boolean)true);
            }
            player.m_36220_(Stats.f_12944_);
            if (emptyStack) {
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)clickedStack, (Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42446_)));
            }
            if (shrinkStack) {
                clickedStack.m_41774_(1);
            }
            if (emptyCauldron) {
                level.m_7731_(cauldronPos, Blocks.f_50256_.m_49966_(), 3);
            }
            ItemHandlerHelper.spawnItemStack(level, cauldronPos, (ItemStack)result.get());
            level.m_5594_(null, cauldronPos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)false);
        };
    }

    public void injectInteractions(FluidHelper.MoltenFluid fluid) {
        this.publicInteractionMap.put(Items.f_42446_, (cauldronState, level, cauldronPos, player, hand, clickedStack) -> CauldronInteraction.m_175635_((BlockState)cauldronState, (Level)level, (BlockPos)cauldronPos, (Player)player, (InteractionHand)hand, (ItemStack)clickedStack, (ItemStack)new ItemStack((ItemLike)fluid.bucket.get()), state -> true, (SoundEvent)SoundEvents.f_11783_));
        if (fluid.ingotSupplier != null) {
            this.publicInteractionMap.put(Blocks.f_50127_.m_5456_(), JSGFluidCauldron.getItemDropInteraction(() -> new ItemStack((ItemLike)fluid.ingotSupplier.get()), true, true, false));
        }
        CauldronInteraction.m_175647_(this.publicInteractionMap);
        CauldronInteraction fillSupplier = (cauldronState, level, cauldronPos, player, hand, clickedStack) -> {
            BlockState newBlockState = ((JSGFluidCauldron)((Object)((Object)fluid.cauldron.get()))).m_49966_();
            return CauldronInteraction.m_175618_((Level)level, (BlockPos)cauldronPos, (Player)player, (InteractionHand)hand, (ItemStack)clickedStack, (BlockState)newBlockState, (SoundEvent)SoundEvents.f_11778_);
        };
        CauldronInteraction.f_175606_.put((Item)fluid.bucket.get(), fillSupplier);
        Pair<Supplier<? extends Item>, FluidHelper.MoltenFluid> materials = fluid.makingIngredients;
        if (materials != null) {
            Supplier item = (Supplier)materials.first();
            FluidHelper.MoltenFluid materialFluid = (FluidHelper.MoltenFluid)materials.second();
            Map<Item, CauldronInteraction> map = CauldronInteraction.f_175608_;
            if (materialFluid != null) {
                map = ((JSGFluidCauldron)((Object)materialFluid.cauldron.get())).publicInteractionMap;
            }
            map.put((Item)item.get(), (cauldronState, level, cauldronPos, player, hand, clickedStack) -> {
                if (level.f_46443_) {
                    return InteractionResult.m_19078_((boolean)true);
                }
                player.m_36220_(Stats.f_12944_);
                level.m_7731_(cauldronPos, ((JSGFluidCauldron)((Object)((Object)fluid.cauldron.get()))).m_49966_(), 3);
                clickedStack.m_41774_(1);
                level.m_5594_(null, cauldronPos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.m_19078_((boolean)false);
            });
        }
    }

    public JSGFluidCauldron(Map<Item, CauldronInteraction> interactionMap) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50256_), interactionMap);
        this.publicInteractionMap = interactionMap;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public Item m_5456_() {
        return Items.f_42544_;
    }

    protected double m_142446_(@NotNull BlockState blockState) {
        return 0.9375;
    }

    public boolean m_142596_(@NotNull BlockState blockState) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public void m_7892_(BlockState blockState, Level level, BlockPos pos, Entity entity) {
    }

    @ParametersAreNonnullByDefault
    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return 3;
    }
}

