/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.blockentity;

import dev.tauri.jsg.block.invisible.InvisibleBlock;
import dev.tauri.jsg.config.util.JSGConfigUtil;
import dev.tauri.jsg.helpers.ItemHandlerHelper;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.StateUpdatePacketToClient;
import dev.tauri.jsg.packet.packets.StateUpdateRequestToServer;
import dev.tauri.jsg.state.CamoState;
import dev.tauri.jsg.state.State;
import dev.tauri.jsg.state.StateProviderInterface;
import dev.tauri.jsg.state.StateTypeEnum;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public abstract class CamouflageBE
extends BlockEntity
implements StateProviderInterface {
    private BlockState camoBlock = Blocks.f_50016_.m_49966_();
    private PacketDistributor.TargetPoint targetPointInternal;

    public void onCamoBlockChanged() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.targetPointInternal == null) {
            this.targetPointInternal = new PacketDistributor.TargetPoint((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), 512.0, this.f_58857_.m_46472_());
        }
        JSGPacketHandler.sendToClient(new StateUpdatePacketToClient(this.m_58899_(), StateTypeEnum.CAMO_STATE, this.getState(StateTypeEnum.CAMO_STATE)), this.targetPointInternal);
    }

    public void dropCamo() {
        if (this.camoBlock == null || this.camoBlock.m_60795_()) {
            return;
        }
        ItemHandlerHelper.spawnItemStack(this.m_58904_(), this.m_58899_(), new ItemStack((ItemLike)this.camoBlock.m_60734_()));
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            JSGPacketHandler.sendToServer(new StateUpdateRequestToServer(this.m_58899_(), StateTypeEnum.CAMO_STATE));
        } else {
            this.onCamoBlockChanged();
        }
    }

    public CamouflageBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.onCamoBlockChanged();
    }

    public BlockState getCamoBlock() {
        return this.camoBlock;
    }

    public boolean setCamoBlockByHeldItem(ItemStack stack, Player player, BlockPlaceContext ctx) {
        if (stack.m_41619_()) {
            return this.removeCamoBlockAndDrop(player);
        }
        Item item = stack.m_41720_();
        if (item instanceof BucketItem) {
            return false;
        }
        Block block = Block.m_49814_((Item)stack.m_41720_());
        if (block == Blocks.f_50016_) {
            return this.removeCamoBlockAndDrop(player);
        }
        if (block instanceof FlowerBlock) {
            return false;
        }
        if (block instanceof BannerBlock) {
            return false;
        }
        if (block instanceof InvisibleBlock) {
            return false;
        }
        if (!this.getCamoBlock().m_60795_()) {
            return false;
        }
        BlockState blockState = block.m_5573_(ctx);
        if (!JSGConfigUtil.canBeUsedAsCamoBlock(blockState)) {
            return false;
        }
        this.setCamoBlock(blockState);
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
        if (this.f_58857_ != null) {
            this.f_58857_.m_5594_(null, this.m_58899_(), block.m_49966_().m_60827_().m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return true;
    }

    public boolean removeCamoBlockAndDrop(Player player) {
        if (!this.camoBlock.m_60795_()) {
            if (!player.m_7500_()) {
                ItemHandlerHelper.spawnItemStack(this.f_58857_, this.m_58899_(), new ItemStack((ItemLike)this.camoBlock.m_60734_()));
            }
            this.removeCamoBlock();
            if (this.f_58857_ != null) {
                this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    public void setCamoBlock(BlockState blockState) {
        this.camoBlock = blockState;
        this.m_6596_();
        this.onCamoBlockChanged();
    }

    public void removeCamoBlock() {
        this.camoBlock = Blocks.f_50016_.m_49966_();
        this.m_6596_();
        this.onCamoBlockChanged();
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        compound.m_128405_("camoBlock_id", Block.m_49956_((BlockState)this.camoBlock));
        super.m_183515_(compound);
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        if (compound.m_128441_("camoBlock_id")) {
            this.camoBlock = Block.m_49803_((int)compound.m_128451_("camoBlock_id"));
        }
        super.m_142466_(compound);
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        if (stateType == StateTypeEnum.CAMO_STATE) {
            return new CamoState(this.getCamoBlock());
        }
        return null;
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        if (stateType == StateTypeEnum.CAMO_STATE) {
            return new CamoState();
        }
        return null;
    }

    @Override
    public void setState(StateTypeEnum stateType, State state) {
        if (stateType == StateTypeEnum.CAMO_STATE) {
            this.setCamoBlock(((CamoState)state).getState());
        }
    }
}

