/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.blockentity.dialhomedevice;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.blockentity.IPreparable;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.util.IUpgradable;
import dev.tauri.jsg.blockentity.util.ReactorStateEnum;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.config.util.JSGConfigUtil;
import dev.tauri.jsg.helpers.BlockHelpers;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.StateUpdatePacketToClient;
import dev.tauri.jsg.packet.packets.StateUpdateRequestToServer;
import dev.tauri.jsg.property.JSGProperties;
import dev.tauri.jsg.registry.FluidRegistry;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.renderer.dialhomedevice.DHDAbstractRendererState;
import dev.tauri.jsg.screen.inventory.dialhomedevice.DHDContainerGuiUpdate;
import dev.tauri.jsg.screen.util.DHDScreenHelper;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import dev.tauri.jsg.state.State;
import dev.tauri.jsg.state.StateProviderInterface;
import dev.tauri.jsg.state.StateTypeEnum;
import dev.tauri.jsg.state.dialhomedevice.DHDActivateButtonState;
import dev.tauri.jsg.state.stargate.StargateBiomeOverrideState;
import dev.tauri.jsg.util.EnumKeyInterface;
import dev.tauri.jsg.util.FluidTank;
import dev.tauri.jsg.util.ILinkable;
import dev.tauri.jsg.util.ITickable;
import dev.tauri.jsg.util.JSGItemStackHandler;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public abstract class DHDAbstractBE
extends BlockEntity
implements ILinkable<StargateAbstractBaseBE>,
IUpgradable,
StateProviderInterface,
ITickable,
IPreparable {
    public static final EnumSet<BiomeOverlayEnum> SUPPORTED_OVERLAYS = EnumSet.of(BiomeOverlayEnum.NORMAL, BiomeOverlayEnum.FROST, BiomeOverlayEnum.MOSSY, BiomeOverlayEnum.SOOTY, BiomeOverlayEnum.AGED);
    public static final List<Item> SUPPORTED_UPGRADES = Arrays.asList((Item)ItemRegistry.CRYSTAL_GLYPH_DHD.get(), (Item)ItemRegistry.CRYSTAL_UPGRADE_CAPACITY.get(), (Item)ItemRegistry.CRYSTAL_UPGRADE_EFFICIENCY.get());
    public static final int BIOME_OVERRIDE_SLOT = 5;
    protected final FluidTank fluidHandler = new FluidTank(new FluidStack(FluidRegistry.MOLTEN_NAQUADAH_REFINED.get(), 0), (Integer)JSGConfig.DialHomeDevice.fluidCapacity.get()){

        public boolean isFluidValid(FluidStack fluid) {
            if (fluid == null) {
                return false;
            }
            return fluid.getFluid() == FluidRegistry.MOLTEN_NAQUADAH_REFINED.get();
        }

        protected void onContentsChanged() {
            DHDAbstractBE.this.m_6596_();
        }
    };
    protected DHDAbstractRendererState rendererStateClient;
    protected PacketDistributor.TargetPoint targetPoint;
    protected ReactorStateEnum reactorState = ReactorStateEnum.STANDBY;
    private BlockPos linkedGate = null;
    private BlockPos lastPos = BlockPos.f_121853_;
    private boolean hadControlCrystal;
    protected final ItemStackHandler itemStackHandler = new JSGItemStackHandler(6){

        public boolean isItemValid(int slot, ItemStack stack) {
            Item item = stack.m_41720_();
            switch (slot) {
                case 0: {
                    return item == DHDAbstractBE.this.getControlCrystal();
                }
                case 1: 
                case 2: 
                case 3: {
                    return SUPPORTED_UPGRADES.contains(item) && !DHDAbstractBE.this.hasUpgrade(item);
                }
                case 4: {
                    Item item2 = stack.m_41720_();
                    if (item2 instanceof BucketItem) {
                        BucketItem bucket = (BucketItem)item2;
                        FluidStack fluid = new FluidStack(bucket.getFluid(), 1000);
                        return fluid.getFluid() == FluidRegistry.MOLTEN_NAQUADAH_REFINED.get();
                    }
                    return false;
                }
                case 5: {
                    BiomeOverlayEnum override = JSGConfigUtil.getBiomeOverrideItemMetaPairs().get(Block.m_49814_((Item)stack.m_41720_()));
                    if (override == null) {
                        return false;
                    }
                    return DHDAbstractBE.this.getSupportedOverlays().contains(override);
                }
            }
            return true;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            super.setStackInSlot(slot, stack);
            if (DHDAbstractBE.this.f_58857_ != null && !((DHDAbstractBE)DHDAbstractBE.this).f_58857_.f_46443_ && slot == 0) {
                DHDAbstractBE.this.updateCrystal();
            }
        }

        @Override
        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack out = super.extractItem(slot, amount, simulate);
            if (DHDAbstractBE.this.f_58857_ != null && !((DHDAbstractBE)DHDAbstractBE.this).f_58857_.f_46443_ && slot == 0 && amount > 0 && !simulate) {
                DHDAbstractBE.this.updateCrystal();
            }
            return out;
        }

        protected void onContentsChanged(int slot) {
            switch (slot) {
                case 5: {
                    DHDAbstractBE.this.sendState(StateTypeEnum.BIOME_OVERRIDE_STATE, new StargateBiomeOverrideState(DHDAbstractBE.this.determineBiomeOverride()));
                    break;
                }
                case 4: {
                    BucketItem bucket;
                    FluidStack fluid;
                    ItemStack stack = this.getStackInSlot(slot);
                    Item item = stack.m_41720_();
                    if (!(item instanceof BucketItem) || (fluid = new FluidStack((bucket = (BucketItem)item).getFluid(), 1000)).getFluid() != FluidRegistry.MOLTEN_NAQUADAH_REFINED.get()) break;
                    int amount = fluid.getAmount();
                    int filled = DHDAbstractBE.this.fluidHandler.fill(fluid, IFluidHandler.FluidAction.SIMULATE);
                    if (filled != amount) break;
                    this.setStackInSlot(slot, new ItemStack((ItemLike)Items.f_42446_));
                    DHDAbstractBE.this.fluidHandler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                    break;
                }
            }
            super.onContentsChanged(slot);
            DHDAbstractBE.this.m_6596_();
        }
    };
    public boolean isLinkedClient;

    public abstract DHDScreenHelper getScreenHelper();

    public DHDAbstractBE(BlockEntityType<?> entityType, BlockPos pos, BlockState state) {
        super(entityType, pos, state);
    }

    public Vec3 getBlockPosInFront() {
        Direction dhdFacing = Direction.m_122407_((int)Math.round((float)((Integer)this.m_58900_().m_61143_((Property)JSGProperties.ROTATION_PROPERTY)).intValue() / 4.0f)).m_122424_();
        return this.m_58899_().m_252807_().m_82549_(new Vec3((double)dhdFacing.m_122436_().m_123341_(), (double)dhdFacing.m_122436_().m_123342_(), (double)dhdFacing.m_122436_().m_123343_()));
    }

    public FluidTank getFluidHandler() {
        return this.fluidHandler;
    }

    public abstract SymbolTypeEnum<?> getSymbolType();

    public abstract Item getControlCrystal();

    public ItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    public DHDAbstractRendererState getRendererStateClient() {
        return this.rendererStateClient;
    }

    public abstract void updateLinkStatus(Level var1, BlockPos var2);

    @Override
    public boolean canLinkTo() {
        return !this.isLinked();
    }

    @Override
    public void setLinkedDevice(BlockPos devicePos) {
        this.linkedGate = devicePos;
        this.m_6596_();
    }

    @Override
    @Nullable
    public StargateAbstractBaseBE getLinkedDevice() {
        if (this.linkedGate == null) {
            return null;
        }
        if (this.m_58904_() == null) {
            return null;
        }
        BlockEntity blockEntity = this.m_58904_().m_7702_(this.linkedGate);
        if (blockEntity instanceof StargateAbstractBaseBE) {
            StargateAbstractBaseBE gate = (StargateAbstractBaseBE)blockEntity;
            return gate;
        }
        return null;
    }

    @Override
    @Nullable
    public BlockPos getLinkedPos() {
        return this.linkedGate;
    }

    public void onLoad() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.targetPoint = new PacketDistributor.TargetPoint((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), 512.0, this.f_58857_.m_46472_());
            this.hadControlCrystal = this.hasControlCrystal();
        } else {
            JSGPacketHandler.sendToServer(new StateUpdateRequestToServer(this.m_58899_(), StateTypeEnum.RENDERER_STATE));
        }
    }

    public ReactorStateEnum getReactorState() {
        return this.reactorState;
    }

    @Override
    public void tick() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_ && this.getRendererStateClient() == null) {
            JSGPacketHandler.sendToServer(new StateUpdateRequestToServer(this.m_58899_(), StateTypeEnum.RENDERER_STATE));
        }
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            if (!this.lastPos.equals((Object)this.m_58899_())) {
                this.lastPos = this.m_58899_();
                this.updateLinkStatus(this.f_58857_, this.m_58899_());
            }
            int newFluidCapacity = (Integer)JSGConfig.DialHomeDevice.fluidCapacity.get();
            if (this.hasUpgrade(DHDUpgradeEnum.CAPACITY_UPGRADE)) {
                newFluidCapacity = (int)((double)newFluidCapacity * (Double)JSGConfig.DialHomeDevice.capacityUpgradeMultiplier.get());
            }
            if (this.fluidHandler.getCapacity() != newFluidCapacity) {
                this.fluidHandler.setCapacity(newFluidCapacity);
                this.m_6596_();
                JSG.logger.debug("DHD at " + BlockHelpers.blockPosToBetterString(this.m_58899_()) + " set itself new capacity! (" + newFluidCapacity + "mb)");
            }
            if (this.hasControlCrystal()) {
                if (this.isLinked()) {
                    StargateAbstractBaseBE gateTile = this.getLinkedDevice();
                    if (gateTile == null) {
                        this.setLinkedDevice(null);
                        JSG.logger.error("Gate didn't unlink properly, forcing...");
                        return;
                    }
                    IEnergyStorage energyStorage = (IEnergyStorage)gateTile.getCapability(ForgeCapabilities.ENERGY, null).resolve().orElseThrow();
                    int amount = 1;
                    if (this.reactorState != ReactorStateEnum.STANDBY) {
                        FluidStack simulatedDrain = this.fluidHandler.drain(amount, IFluidHandler.FluidAction.SIMULATE);
                        this.reactorState = simulatedDrain.getAmount() >= amount ? ReactorStateEnum.ONLINE : ReactorStateEnum.NO_FUEL;
                    }
                    if (this.reactorState == ReactorStateEnum.ONLINE || this.reactorState == ReactorStateEnum.STANDBY) {
                        float percent = (float)Objects.requireNonNull(energyStorage).getEnergyStored() / (float)energyStorage.getMaxEnergyStored();
                        if ((double)percent < (Double)JSGConfig.DialHomeDevice.activationLevel.get()) {
                            this.reactorState = ReactorStateEnum.ONLINE;
                        } else if ((double)percent >= (Double)JSGConfig.DialHomeDevice.deactivationLevel.get()) {
                            this.reactorState = ReactorStateEnum.STANDBY;
                        }
                    }
                    if (this.reactorState == ReactorStateEnum.ONLINE) {
                        this.fluidHandler.drain(amount, IFluidHandler.FluidAction.EXECUTE);
                        int energyPerOne = (Integer)JSGConfig.DialHomeDevice.energyPerNaquadah.get();
                        if (this.hasUpgrade(DHDUpgradeEnum.EFFICIENCY_UPGRADE)) {
                            energyPerOne = (int)((double)energyPerOne * (Double)JSGConfig.DialHomeDevice.efficiencyUpgradeMultiplier.get());
                        }
                        energyStorage.receiveEnergy(energyPerOne, false);
                    }
                } else {
                    this.reactorState = ReactorStateEnum.NOT_LINKED;
                }
            } else {
                this.reactorState = ReactorStateEnum.NO_CRYSTAL;
            }
        }
    }

    protected BiomeOverlayEnum determineBiomeOverride() {
        ItemStack stack = this.itemStackHandler.getStackInSlot(5);
        if (stack.m_41619_()) {
            return null;
        }
        BiomeOverlayEnum biomeOverlay = JSGConfigUtil.getBiomeOverrideItemMetaPairs().get(Block.m_49814_((Item)stack.m_41720_()));
        if (this.getSupportedOverlays().contains(biomeOverlay)) {
            return biomeOverlay;
        }
        return null;
    }

    public EnumSet<BiomeOverlayEnum> getSupportedOverlays() {
        return SUPPORTED_OVERLAYS;
    }

    public boolean hasControlCrystal() {
        return !this.itemStackHandler.getStackInSlot(0).m_41619_();
    }

    private void updateCrystal() {
        boolean hasControlCrystal = this.hasControlCrystal();
        if (this.hadControlCrystal != hasControlCrystal) {
            if (hasControlCrystal) {
                this.sendState(StateTypeEnum.RENDERER_STATE, this.getState(StateTypeEnum.RENDERER_STATE));
            } else {
                this.clearSymbols();
            }
            this.hadControlCrystal = hasControlCrystal;
        }
    }

    public abstract void activateSymbol(SymbolInterface var1);

    public abstract void pushSymbolButton(SymbolInterface var1, @Nullable ServerPlayer var2, boolean var3);

    public void clearSymbols() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_151543_(this.m_58899_());
        }
        this.sendState(StateTypeEnum.DHD_ACTIVATE_BUTTON, new DHDActivateButtonState(true));
    }

    @Override
    public void sendState(StateTypeEnum type, State state) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.targetPoint != null) {
            JSGPacketHandler.sendToClient(new StateUpdatePacketToClient(this.m_58899_(), type, state), this.targetPoint);
        } else {
            JSG.logger.debug("targetPoint was null trying to send " + String.valueOf((Object)type) + " from " + this.getClass().getCanonicalName());
        }
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        return switch (stateType) {
            case StateTypeEnum.DHD_ACTIVATE_BUTTON -> new DHDActivateButtonState();
            case StateTypeEnum.GUI_UPDATE -> new DHDContainerGuiUpdate();
            case StateTypeEnum.BIOME_OVERRIDE_STATE -> new StargateBiomeOverrideState();
            default -> throw new UnsupportedOperationException("EnumStateType." + stateType.name() + " not implemented on " + this.getClass().getName());
        };
    }

    @Override
    public void setState(StateTypeEnum stateType, State state) {
        if (stateType != StateTypeEnum.GUI_UPDATE) {
            throw new UnsupportedOperationException("EnumStateType." + stateType.name() + " not implemented on " + this.getClass().getName());
        }
        DHDContainerGuiUpdate guiState = (DHDContainerGuiUpdate)state;
        this.fluidHandler.setFluid(new FluidStack(FluidRegistry.MOLTEN_NAQUADAH_REFINED.get(), guiState.fluidAmount));
        this.fluidHandler.setCapacity(guiState.tankCapacity);
        this.reactorState = guiState.reactorState;
        this.isLinkedClient = guiState.isLinked;
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(this::getItemStackHandler).cast();
        }
        if (capability == ForgeCapabilities.FLUID_HANDLER && (facing == null || facing == Direction.DOWN)) {
            return LazyOptional.of(this::getFluidHandler).cast();
        }
        return super.getCapability(capability, facing);
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        if (this.linkedGate != null) {
            compound.m_128356_("linkedGate", this.linkedGate.m_121878_());
        }
        compound.m_128365_("itemStackHandler", (Tag)this.itemStackHandler.serializeNBT());
        CompoundTag fluidHandlerCompound = new CompoundTag();
        this.fluidHandler.writeToNBT(fluidHandlerCompound);
        compound.m_128365_("fluidHandler", (Tag)fluidHandlerCompound);
        super.m_183515_(compound);
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("linkedGate")) {
            this.linkedGate = BlockPos.m_122022_((long)compound.m_128454_("linkedGate"));
        }
        this.itemStackHandler.deserializeNBT(compound.m_128469_("itemStackHandler"));
        if (compound.m_128471_("hasUpgrade") || compound.m_128471_("insertAnimation")) {
            this.itemStackHandler.setStackInSlot(1, new ItemStack((ItemLike)ItemRegistry.CRYSTAL_GLYPH_DHD.get()));
        }
        this.fluidHandler.readFromNBT(compound.m_128469_("fluidHandler"));
    }

    @Nonnull
    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_().m_7918_(-1, 0, -1), this.m_58899_().m_7918_(1, 2, 1));
    }

    @Override
    public boolean prepareBE() {
        StargateAbstractBaseBE stargateAbstractBaseBE = this.getLinkedDevice();
        if (stargateAbstractBaseBE instanceof ILinkable) {
            ILinkable linkable = (ILinkable)((Object)stargateAbstractBaseBE);
            linkable.setLinkedDevice(null);
        }
        this.setLinkedDevice(null);
        return true;
    }

    public static enum DHDUpgradeEnum implements EnumKeyInterface<Item>
    {
        CHEVRON_UPGRADE((Item)ItemRegistry.CRYSTAL_GLYPH_DHD.get()),
        CAPACITY_UPGRADE((Item)ItemRegistry.CRYSTAL_UPGRADE_CAPACITY.get()),
        EFFICIENCY_UPGRADE((Item)ItemRegistry.CRYSTAL_UPGRADE_EFFICIENCY.get());

        public final Item item;

        private DHDUpgradeEnum(Item item) {
            this.item = item;
        }

        @Override
        public Item getKey() {
            return this.item;
        }
    }
}

