/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.blockentity.stargate;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.api.event.StargateChevronEngagedEvent;
import dev.tauri.jsg.api.event.StargateClosedEvent;
import dev.tauri.jsg.api.event.StargateClosingEvent;
import dev.tauri.jsg.api.event.StargateDialFailEvent;
import dev.tauri.jsg.api.event.StargateOpenedEvent;
import dev.tauri.jsg.api.event.StargateOpeningEvent;
import dev.tauri.jsg.api.item.NotebookPageSerialization;
import dev.tauri.jsg.api.stargate_listener.StargateListenerHandler;
import dev.tauri.jsg.block.stargate.StargateAbstractBaseBlock;
import dev.tauri.jsg.blockentity.CamouflageBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.blockentity.util.ScheduledTask;
import dev.tauri.jsg.blockentity.util.ScheduledTaskExecutorInterface;
import dev.tauri.jsg.chunkloader.ChunkManager;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.config.ingame.JSGEnumConfigOption;
import dev.tauri.jsg.config.ingame.JSGIntRangeConfigOption;
import dev.tauri.jsg.config.stargate.StargateDimensionConfig;
import dev.tauri.jsg.config.stargate.StargateDimensionConfigEntry;
import dev.tauri.jsg.config.util.JSGConfigUtil;
import dev.tauri.jsg.config.util.StargateTimeLimitModeEnum;
import dev.tauri.jsg.helpers.BlockHelpers;
import dev.tauri.jsg.helpers.BlockPosHelper;
import dev.tauri.jsg.integration.ComputerDeviceHolder;
import dev.tauri.jsg.integration.ComputerDeviceProvider;
import dev.tauri.jsg.item.notebook.PageNotebookItemFilled;
import dev.tauri.jsg.multistructure.IMultiStructureBE;
import dev.tauri.jsg.multistructure.mergehelper.StargateAbstractMergeHelper;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.StateUpdatePacketToClient;
import dev.tauri.jsg.packet.packets.StateUpdateRequestToServer;
import dev.tauri.jsg.power.general.EnergyRequiredToOperate;
import dev.tauri.jsg.power.general.SmallEnergyStorage;
import dev.tauri.jsg.property.JSGProperties;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.renderer.stargate.StargateAbstractRendererState;
import dev.tauri.jsg.sound.JSGSoundHelper;
import dev.tauri.jsg.sound.JSGSoundHelperClient;
import dev.tauri.jsg.sound.SoundEventEnum;
import dev.tauri.jsg.sound.SoundPositionedEnum;
import dev.tauri.jsg.sound.StargateSoundEventEnum;
import dev.tauri.jsg.sound.StargateSoundPositionedEnum;
import dev.tauri.jsg.stargate.AutoCloseManager;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import dev.tauri.jsg.stargate.BlackHoleAnimationState;
import dev.tauri.jsg.stargate.EnumIrisState;
import dev.tauri.jsg.stargate.EnumIrisType;
import dev.tauri.jsg.stargate.EnumScheduledTask;
import dev.tauri.jsg.stargate.EnumStargateState;
import dev.tauri.jsg.stargate.StargateClosedReasonEnum;
import dev.tauri.jsg.stargate.StargateOpenResult;
import dev.tauri.jsg.stargate.StargateTypeEnum;
import dev.tauri.jsg.stargate.codesender.CodeSender;
import dev.tauri.jsg.stargate.network.IAddress;
import dev.tauri.jsg.stargate.network.StargateAddress;
import dev.tauri.jsg.stargate.network.StargateAddressDynamic;
import dev.tauri.jsg.stargate.network.StargateNetwork;
import dev.tauri.jsg.stargate.network.StargatePos;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import dev.tauri.jsg.stargate.network.SymbolTypeRegistry;
import dev.tauri.jsg.stargate.network.SymbolUsage;
import dev.tauri.jsg.stargate.rig.StargateRIGManager;
import dev.tauri.jsg.stargate.teleportation.EventHorizon;
import dev.tauri.jsg.stargate.teleportation.TeleportHelper;
import dev.tauri.jsg.state.State;
import dev.tauri.jsg.state.StateProviderInterface;
import dev.tauri.jsg.state.StateSoundPositionedUpdate;
import dev.tauri.jsg.state.StateTypeEnum;
import dev.tauri.jsg.state.stargate.StargateFlashState;
import dev.tauri.jsg.state.stargate.StargateRendererActionState;
import dev.tauri.jsg.state.stargate.StargateVaporizeBlockParticlesRequest;
import dev.tauri.jsg.util.ITickable;
import dev.tauri.jsg.util.JSGAdvancementsUtil;
import dev.tauri.jsg.util.JSGAxisAlignedBB;
import dev.tauri.jsg.util.TimeUtils;
import dev.tauri.jsg.util.vectors.Vector3f;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StargateAbstractBaseBE
extends CamouflageBE
implements ITickable,
ComputerDeviceProvider,
ScheduledTaskExecutorInterface,
StateProviderInterface,
IMultiStructureBE<StargateAbstractMergeHelper> {
    public StargateAbstractMergeHelper mergeHelper = null;
    public BlockPos pos;
    public EnumStargateState stargateState = EnumStargateState.IDLE;
    private boolean isInitiating;
    private BlockPos lastPos = null;
    protected Level world;
    protected EventHorizon eventHorizon;
    private AutoCloseManager autoCloseManager;
    public boolean isNoxDialing = false;
    protected Map<SymbolTypeEnum<?>, StargateAddress> gateAddressMap = new HashMap();
    protected StargateAddressDynamic dialedAddress = new StargateAddressDynamic(this.getSymbolType());
    public StargatePos targetGatePos;
    public StargatePos stargatePos;
    public boolean connectedToGate = false;
    public boolean connectingToGate = false;
    protected StargatePos connectedToGatePos;
    public boolean isIncoming = false;
    protected PacketDistributor.TargetPoint targetPoint;
    private boolean addedToNetwork;
    protected List<JSGAxisAlignedBB> localKillingBoxes;
    protected List<JSGAxisAlignedBB> localInnerBlockBoxes;
    protected List<JSGAxisAlignedBB> localInnerEntityBoxes;
    protected boolean horizonKilling = false;
    protected int horizonSegments = 0;
    StargateAbstractRendererState rendererStateClient;
    public boolean isMerged;
    public final HashMap<Integer, Entity> entitiesPassedLast = new HashMap();
    private ScheduledTask horizonFlashTask;
    private int flashIndex = 0;
    public boolean isCurrentlyUnstable = false;
    public boolean shouldBeUnstable = false;
    protected List<ScheduledTask> scheduledTasks = new ArrayList<ScheduledTask>();
    protected ScheduledTask lastSpinFinished;
    private int keepAliveEnergyPerTick = 0;
    private int shieldKeepAlive = 0;
    private int energyStoredLastTick = 0;
    protected int energyTransferredLastTick = 0;
    protected float energySecondsToClose = 0.0f;
    public long openedSince;
    public BlackHoleAnimationState blackHoleAnimationState = new BlackHoleAnimationState(this);
    private boolean checkedForBlackHole = false;
    public StargateListenerHandler listenerHandler = new StargateListenerHandler(this);
    public final StargateRIGManager rigManager = new StargateRIGManager(this);
    public ComputerDeviceHolder computerDeviceHolder;

    public abstract void generateMergeHelper();

    public StargateAbstractBaseBE(BlockEntityType<?> entityType, BlockPos pos, BlockState state) {
        super(entityType, pos, state);
        this.pos = pos;
        this.world = this.m_58904_();
        this.m_6596_();
        this.generateMergeHelper();
        if (this.world != null && this.world.f_46443_) {
            JSGPacketHandler.sendToServer(new StateUpdateRequestToServer(pos, StateTypeEnum.RENDERER_STATE));
            JSGPacketHandler.sendToServer(new StateUpdateRequestToServer(pos, StateTypeEnum.SOUND_UPDATE));
        }
        if (this.world != null && !this.world.f_46443_) {
            this.createDeviceHolder();
        }
    }

    public BlockState getCurrentBlockState() {
        if (this.f_58857_ == null) {
            return this.m_58900_();
        }
        return this.f_58857_.m_8055_(this.m_58899_());
    }

    @Nonnull
    public Level getLevelNotNull() {
        return Objects.requireNonNull(this.m_58904_());
    }

    public long getTime() {
        return this.getLevelNotNull().m_46467_();
    }

    public AABB getRenderBoundingBox() {
        return new JSGAxisAlignedBB(BlockPosHelper.rotate(new BlockPos(-4, 0, -1), this.mergeHelper.horizontalFacing, this.mergeHelper.verticalFacing).m_121955_((Vec3i)this.m_58899_()), BlockPosHelper.rotate(new BlockPos(4, 8, 1), this.mergeHelper.horizontalFacing, this.mergeHelper.verticalFacing).m_121955_((Vec3i)this.m_58899_()));
    }

    public boolean sendIrisCode(CodeSender sender, String code) {
        if (this.getDialedAddress() == null) {
            return false;
        }
        if (this.getStargateState().initiating() || this.getStargateState().engaged()) {
            StargatePos gate = StargateNetwork.INSTANCE.getStargate(this.getDialedAddress());
            if (gate == null) {
                return false;
            }
            StargateAbstractBaseBE targetGate = gate.getBlockEntity();
            if (targetGate instanceof StargateClassicBaseBE) {
                StargateClassicBaseBE classicTile = (StargateClassicBaseBE)targetGate;
                return classicTile.receiveIrisCode(sender, code);
            }
        }
        return false;
    }

    public StargateNetwork getNetwork() {
        return StargateNetwork.INSTANCE;
    }

    public final EnumStargateState getStargateState() {
        return this.stargateState;
    }

    public void m_142339_(@Nonnull Level world) {
        this.world = world;
        this.m_6596_();
        super.m_142339_(world);
    }

    protected void engageGate() {
        this.stargateState = this.isInitiating ? EnumStargateState.ENGAGED_INITIATING : EnumStargateState.ENGAGED;
        this.eventHorizon.reset();
        JSGSoundHelper.playPositionedSound(this.f_58857_, this.getGateCenterPos(), SoundPositionedEnum.WORMHOLE_LOOP, true);
        if (this.targetGatePos != null) {
            new StargateOpenedEvent(this, this.targetGatePos.getBlockEntity(), this.isInitiating).post();
        } else if (this.rigManager.isActive()) {
            new StargateOpenedEvent(this, this, this.isInitiating).post();
        }
        this.sendSignal("stargate_wormhole_stabilized", new Object[]{this.isInitiating});
        this.m_6596_();
    }

    protected void disconnectGate(boolean force) {
        this.disconnectGate();
        if (force) {
            this.stargateState = EnumStargateState.IDLE;
        }
        this.m_6596_();
    }

    protected void disconnectGate() {
        this.listenerHandler.gateDisconnect();
        if (this.stargateState != EnumStargateState.INCOMING) {
            this.stargateState = EnumStargateState.IDLE;
        } else {
            this.isIncoming = false;
        }
        this.getAutoCloseManager().reset();
        this.dialedAddress.clear();
        new StargateClosedEvent(this).post();
        if (this.f_58857_ instanceof ServerLevel && !this.f_58857_.f_46443_) {
            ChunkManager.unforceChunk((ServerLevel)this.f_58857_, new ChunkPos(this.m_58899_()));
        }
        this.sendSignal("stargate_wormhole_closed_fully", new Object[]{this.isInitiating});
        this.connectedToGate = false;
        this.connectingToGate = false;
        this.m_6596_();
    }

    public boolean isGateBurried() {
        return false;
    }

    public void failGate() {
        if (this.stargateState != EnumStargateState.INCOMING) {
            this.stargateState = EnumStargateState.IDLE;
        }
        this.connectedToGate = false;
        this.connectingToGate = false;
        this.dialedAddress.clear();
        this.m_6596_();
    }

    public void onBlockBroken() {
        this.getNetwork().removeStargate(this.stargatePos);
    }

    public void onGateBroken() {
        this.onBlockBroken();
        this.onGateUnmerged(false);
        this.dropCamo();
    }

    public void onGateUnmerged(boolean external) {
        if (this.m_58904_() == null || this.m_58904_().m_5776_()) {
            return;
        }
        if (external) {
            this.getMergeHelper().updateMemberStateAndCheck(false);
            this.generateMergeHelper();
        }
        this.isMerged = false;
        this.getLevelNotNull().m_46597_(this.m_58899_(), (BlockState)this.getCurrentBlockState().m_61124_((Property)JSGProperties.RENDER_BLOCK_PROPERTY, (Comparable)Boolean.valueOf(true)));
        this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.GATE_RENDER_CHANGED, false);
        this.getLevelNotNull().m_7731_(this.getGateCenterPos(), Blocks.f_50016_.m_49966_(), 3);
        this.resetTargetIncomingAnimation();
        if (this.stargateState.initiating() || this.stargateState.engaged() && this.targetGatePos == null) {
            this.attemptClose(StargateClosedReasonEnum.CONNECTION_LOST);
        } else if (this.stargateState.engaged()) {
            this.targetGatePos.getBlockEntity().attemptClose(StargateClosedReasonEnum.CONNECTION_LOST);
        }
        this.dialedAddress.clear();
        this.connectedToGate = false;
        this.connectingToGate = false;
        this.targetGatePos = null;
        this.scheduledTasks.clear();
        this.stargateState = EnumStargateState.IDLE;
        this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, 0, false);
        ChunkManager.unforceChunk((ServerLevel)this.getLevelNotNull(), new ChunkPos(this.m_58899_()));
        JSGSoundHelper.playPositionedSound(this.getLevelNotNull(), this.getGateCenterPos(), SoundPositionedEnum.WORMHOLE_LOOP, false);
        this.m_6596_();
    }

    public void onGateMerged() {
        this.isMerged = true;
        this.m_6596_();
        this.getLevelNotNull().m_46597_(this.m_58899_(), (BlockState)this.getCurrentBlockState().m_61124_((Property)JSGProperties.RENDER_BLOCK_PROPERTY, (Comparable)Boolean.valueOf(false)));
        this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.GATE_RENDER_CHANGED, true);
    }

    public boolean canAcceptConnectionFrom(StargatePos targetGatePos) {
        boolean allowConnectToDialing = (Boolean)JSGConfig.Stargate.allowConnectToDialing.get();
        if (allowConnectToDialing) {
            if (this.isMerged) {
                switch (this.stargateState) {
                    case IDLE: 
                    case DIALING: 
                    case DIALING_COMPUTER: 
                    case INCOMING: {
                        return true;
                    }
                }
                return false;
            }
        } else {
            return this.isMerged && (this.stargateState.idle() || this.stargateState.incoming());
        }
        return false;
    }

    public void sendRenderingUpdate(StargateRendererActionState.EnumGateAction gateAction, int chevronCount, boolean modifyFinal, EnumIrisType irisType, EnumIrisState irisState, long irisAnimation) {
        this.sendState(StateTypeEnum.RENDERER_UPDATE, new StargateRendererActionState(gateAction, chevronCount, modifyFinal, irisType, irisState, irisAnimation));
    }

    public void sendRenderingUpdate(StargateRendererActionState.EnumGateAction gateAction, int chevronCount, boolean modifyFinal) {
        this.sendState(StateTypeEnum.RENDERER_UPDATE, new StargateRendererActionState(gateAction, chevronCount, modifyFinal));
    }

    public void sendRenderingUpdate(StargateRendererActionState.EnumGateAction gateAction, boolean parameter) {
        this.sendState(StateTypeEnum.RENDERER_UPDATE, new StargateRendererActionState(gateAction, -1, parameter));
    }

    @Override
    public void sendState(StateTypeEnum type, State state) {
        if (this.getLevelNotNull().f_46443_) {
            return;
        }
        if (this.targetPoint != null) {
            JSGPacketHandler.sendToClient(new StateUpdatePacketToClient(this.m_58899_(), type, state), this.targetPoint);
        } else {
            JSG.logger.debug("targetPoint was null trying to send {} from {}", (Object)type, (Object)this.getClass().getCanonicalName());
        }
    }

    public JSGAxisAlignedBB getEventHorizonLocalBox() {
        return this.eventHorizon.getLocalBox();
    }

    protected abstract JSGAxisAlignedBB getHorizonTeleportBox(boolean var1);

    private AutoCloseManager getAutoCloseManager() {
        if (this.autoCloseManager == null) {
            this.autoCloseManager = new AutoCloseManager(this);
        }
        return this.autoCloseManager;
    }

    public void setMotionOfPassingEntity(int entityId, Vector3f motionVector) {
        this.eventHorizon.setMotion(entityId, motionVector);
    }

    public void teleportEntity(int entityId) {
        this.eventHorizon.teleportEntity(entityId);
    }

    public void removeEntity(int entityId) {
        this.eventHorizon.removeEntity(entityId);
    }

    public StargateOpenResult attemptOpenAndFail() {
        ResultTargetValid resultTarget = this.attemptOpenDialed();
        if (resultTarget == null) {
            return StargateOpenResult.ADDRESS_MALFORMED;
        }
        JSG.logger.info("Gate connection error at {}: {}, cause by: {}", new Object[]{BlockHelpers.blockPosToBetterString(this.m_58899_()), resultTarget.result.name(), resultTarget.message});
        if (!resultTarget.result.ok()) {
            this.dialingFailed(resultTarget.result);
            StargatePos dialedGate = this.getNetwork().getStargate(this.dialedAddress);
            if (resultTarget.targetValid && dialedGate != null && dialedGate.getBlockEntity() != null) {
                dialedGate.getBlockEntity().dialingFailed(StargateOpenResult.CALLER_HUNG_UP);
            }
        }
        return resultTarget.result;
    }

    protected ResultTargetValid attemptOpenDialed() {
        StargateOpenResult result = this.checkAddressAndEnergy(this.dialedAddress);
        if (result.ok()) {
            StargatePos targetGatePos = this.getNetwork().getStargate(this.dialedAddress);
            if (targetGatePos == null) {
                return new ResultTargetValid(StargateOpenResult.ADDRESS_MALFORMED, true, "Result is not OK");
            }
            StargateAbstractBaseBE targetTile = targetGatePos.getBlockEntity();
            if (new StargateOpeningEvent(this, targetGatePos.getBlockEntity(), this.isInitiating).post()) {
                return new ResultTargetValid(StargateOpenResult.ABORTED_BY_EVENT, true, "Gate open cancelled by event");
            }
            if (!targetTile.canAcceptConnectionFrom(this.stargatePos)) {
                return new ResultTargetValid(StargateOpenResult.ADDRESS_MALFORMED, true, "Gate can not accept connection");
            }
            JSGAdvancementsUtil.tryTriggerRangedAdvancement(this, JSGAdvancementsUtil.EnumAdvancementType.GATE_OPEN);
            this.openGate(targetGatePos, true, this.isNoxDialing);
            targetTile.openGate(this.stargatePos, false, this.isNoxDialing);
            targetTile.dialedAddress.clear();
            targetTile.dialedAddress.addAll(this.gateAddressMap.get(targetTile.getSymbolType()).subList(0, this.dialedAddress.size() - 1));
            targetTile.dialedAddress.addOrigin();
            return new ResultTargetValid(result, true, "Result is OK");
        }
        return new ResultTargetValid(result, false, "Result is not OK");
    }

    protected StargateOpenResult checkAddress(StargateAddressDynamic address) {
        if (!address.validate()) {
            return StargateOpenResult.ADDRESS_MALFORMED;
        }
        if (!this.canDialAddress(address)) {
            return StargateOpenResult.ADDRESS_MALFORMED;
        }
        StargatePos targetGate = this.getNetwork().getStargate(address);
        if (targetGate == null) {
            return StargateOpenResult.ADDRESS_MALFORMED;
        }
        StargateAbstractBaseBE targetTile = targetGate.getBlockEntity();
        if (targetTile == null) {
            return StargateOpenResult.ADDRESS_MALFORMED;
        }
        if (!targetTile.canAcceptConnectionFrom(this.stargatePos)) {
            return StargateOpenResult.ADDRESS_MALFORMED;
        }
        return StargateOpenResult.OK;
    }

    public int getMinimalSymbolsToDial(SymbolTypeEnum<?> symbolType, StargatePos targetGatePos) {
        return this.getSymbolType().getMinimalSymbolCountTo(symbolType, StargateDimensionConfig.INSTANCE.isGroupEqual(targetGatePos.dimension, (ResourceKey<Level>)this.world.m_46472_()));
    }

    public StargateOpenResult checkAddressAndEnergy(StargateAddressDynamic address) {
        StargateOpenResult result = this.checkAddress(address);
        if (!result.ok()) {
            return result;
        }
        StargatePos targetGatePos = this.getNetwork().getStargate(address);
        if (targetGatePos == null) {
            return StargateOpenResult.ADDRESS_MALFORMED;
        }
        if (!this.hasEnergyToDial(targetGatePos)) {
            return StargateOpenResult.NOT_ENOUGH_POWER;
        }
        StargateAbstractBaseBE targetTile = targetGatePos.getBlockEntity();
        if (targetTile.isGateBurried()) {
            return StargateOpenResult.GATE_BURRIED;
        }
        return StargateOpenResult.OK;
    }

    public boolean canDialAddress(StargateAddressDynamic address) {
        StargatePos targetGatePos = this.getNetwork().getStargate(address);
        if (targetGatePos == null) {
            return false;
        }
        if (targetGatePos.equals(this.stargatePos)) {
            return false;
        }
        return !this.checkAddressLength(address, targetGatePos);
    }

    protected boolean checkAddressLength(StargateAddressDynamic address, StargatePos targetGatePosition) {
        if (targetGatePosition == null || address == null) {
            return false;
        }
        boolean localDial = StargateDimensionConfig.INSTANCE.isGroupEqual((ResourceKey<Level>)this.getLevelNotNull().m_46472_(), targetGatePosition.dimension);
        return address.size() < this.getSymbolType().getMinimalSymbolCountTo(targetGatePosition.getGateSymbolType(), localDial);
    }

    public void attemptClose(StargateClosedReasonEnum reason) {
        if (reason == null) {
            return;
        }
        if (this.targetGatePos == null || this.targetGatePos.getBlockEntity() == null) {
            this.closeGate(reason);
            return;
        }
        if ((new StargateClosingEvent(this, this.targetGatePos.getBlockEntity(), this.isInitiating, reason).post() || new StargateClosingEvent(this.targetGatePos.getBlockEntity(), this, !this.isInitiating, reason).post()) && reason.equals((Object)StargateClosedReasonEnum.REQUESTED)) {
            return;
        }
        if (this.targetGatePos != null) {
            this.targetGatePos.getBlockEntity().closeGate(reason);
        }
        this.closeGate(reason);
    }

    public Direction getFacing() {
        return this.getMergeHelper().horizontalFacing;
    }

    public Direction getFacingVertical() {
        return this.getMergeHelper().verticalFacing == null ? Direction.SOUTH : this.getMergeHelper().verticalFacing;
    }

    public abstract SymbolTypeEnum<?> getSymbolType();

    public abstract StargateTypeEnum getStargateType();

    @Nullable
    public StargateAddress getStargateAddress(SymbolTypeEnum<?> symbolType) {
        if (this.gateAddressMap == null) {
            return null;
        }
        return this.gateAddressMap.get(symbolType);
    }

    protected void initStargatePos() {
        StargatePos oldPos = this.stargatePos;
        StargatePos gatePos = new StargatePos((ResourceKey<Level>)this.getLevelNotNull().m_46472_(), this.m_58899_(), this.getSymbolType(), this.getStargateType());
        if (oldPos != null) {
            gatePos.setName(oldPos.getName());
        }
        this.stargatePos = gatePos;
    }

    public void setGateAddress(SymbolTypeEnum<?> symbolType, StargateAddress stargateAddress) {
        this.initStargatePos();
        this.gateAddressMap.put(symbolType, stargateAddress);
        this.getNetwork().putStargate(stargateAddress, this.stargatePos);
        this.m_6596_();
    }

    public void renameStargatePos(String newName) {
        this.initStargatePos();
        this.getNetwork().renameStargate(this.stargatePos, newName);
        this.stargatePos.setName(newName);
        this.m_6596_();
    }

    public void refresh() {
        this.initStargatePos();
        if (this.stargatePos != null) {
            this.getNetwork().removeStargate(this.stargatePos);
        }
        for (SymbolTypeEnum<?> s : SymbolTypeEnum.values(SymbolUsage.STARGATES)) {
            StargateAddress address = this.getStargateAddress(s);
            if (address == null) {
                this.generateAddresses(true);
                break;
            }
            this.setGateAddress(s, address);
        }
        this.updateFacing(true);
        this.lastPos = this.m_58899_();
        this.m_6596_();
    }

    public StargateAddressDynamic getDialedAddress() {
        return this.dialedAddress;
    }

    protected int getMaxChevrons() {
        return 7;
    }

    public int getMaxChevronsForApi() {
        return this.getMaxChevrons();
    }

    protected boolean stargateWillLock(SymbolInterface symbol, boolean notAddedYet) {
        if (this.dialedAddress.size() + (notAddedYet ? 1 : 0) == this.getMaxChevrons()) {
            return true;
        }
        return this.dialedAddress.size() + (notAddedYet ? 1 : 0) >= 7 && symbol.origin();
    }

    protected boolean stargateWillLock(SymbolInterface symbol) {
        return this.stargateWillLock(symbol, false);
    }

    public boolean canAddSymbol(SymbolInterface symbol) {
        if (symbol == null) {
            return false;
        }
        return this.canAddSymbolInternal(symbol) && !new StargateChevronEngagedEvent(this, symbol, this.stargateWillLock(symbol)).post();
    }

    protected boolean canAddSymbolInternal(SymbolInterface symbol) {
        if (this.dialedAddress.contains(symbol)) {
            return false;
        }
        return this.dialedAddress.size() < this.getMaxChevrons();
    }

    protected void addSymbolToAddress(SymbolInterface symbol) {
        if (!this.canAddSymbol(symbol)) {
            throw new IllegalStateException("Cannot add that symbol");
        }
        this.listenerHandler.gateSymbolEngage(symbol);
        this.dialedAddress.addSymbol(symbol);
        StargateAddressDynamic addressBackup = new StargateAddressDynamic(this.getSymbolType());
        addressBackup.clear();
        addressBackup.addAll(this.dialedAddress);
        if (symbol != this.getSymbolType().getOrigin() && this.dialedAddress.size() >= 6) {
            StargateAbstractBaseBE targetTile;
            this.dialedAddress.addOrigin();
            if (this.checkAddressAndEnergy(this.dialedAddress).ok() && !this.connectedToGate && !Objects.requireNonNull(this.getNetwork().getStargate((StargateAddress)this.dialedAddress)).getBlockEntity().stargateState.incoming()) {
                this.connectingToGate = true;
            } else if (!this.checkAddressAndEnergy(this.dialedAddress).ok() && this.connectedToGate && (targetTile = Objects.requireNonNull(this.getNetwork().getStargate(this.dialedAddress)).getBlockEntity()) != null) {
                targetTile.disconnectGate(true);
                targetTile.stargateState = EnumStargateState.IDLE;
                targetTile.m_6596_();
            }
            this.dialedAddress.clear();
            this.dialedAddress.addAll(addressBackup);
        }
        this.m_6596_();
    }

    protected void resetTargetIncomingAnimation() {
        if (this.connectedToGatePos != null) {
            StargateAbstractBaseBE targetGateTile = this.connectedToGatePos.getBlockEntity();
            targetGateTile.disconnectGate(true);
            targetGateTile.stargateState = EnumStargateState.IDLE;
            targetGateTile.m_6596_();
            this.connectedToGatePos = null;
            this.connectedToGate = false;
            this.connectingToGate = false;
            this.m_6596_();
        }
    }

    protected void doIncomingAnimation(int time, boolean byComputer) {
        this.doIncomingAnimation(time, byComputer, null);
    }

    protected void doIncomingAnimation(int time, boolean byComputer, SymbolInterface symbol) {
        if (!this.connectingToGate) {
            return;
        }
        this.connectingToGate = false;
        this.m_6596_();
        StargateAddressDynamic addressBackup = new StargateAddressDynamic(this.getSymbolType());
        addressBackup.clear();
        addressBackup.addAll(this.dialedAddress);
        if (this.dialedAddress.size() >= 6 && (symbol == null || symbol.origin())) {
            StargateAbstractBaseBE targetGateTile;
            this.dialedAddress.addOrigin();
            StargatePos targetGatePos = this.getNetwork().getStargate(this.dialedAddress);
            if (targetGatePos != null && (targetGateTile = targetGatePos.getBlockEntity()) != null) {
                if (this.checkAddressAndEnergy(this.dialedAddress).ok() && !this.connectedToGate) {
                    int size = this.dialedAddress.size();
                    this.connectedToGate = true;
                    this.connectedToGatePos = targetGatePos;
                    this.m_6596_();
                    int period = 400;
                    if (byComputer) {
                        period = (time += 20) / 20 * 1000 / size;
                    }
                    targetGateTile.isIncoming = true;
                    targetGateTile.m_6596_();
                    if (targetGateTile instanceof StargateClassicBaseBE && ((StargateClassicBaseBE)targetGateTile).isIncomingAnimationAllowed(false)) {
                        targetGateTile.incomingWormhole(size, period);
                    } else {
                        targetGateTile.incomingWormhole(size);
                    }
                    targetGateTile.sendSignal("stargate_incoming_wormhole", new Object[]{size});
                    targetGateTile.stargateState = EnumStargateState.INCOMING;
                    targetGateTile.m_6596_();
                    targetGateTile.failGate();
                } else if (!this.checkAddressAndEnergy(this.dialedAddress).ok() && this.connectedToGate) {
                    targetGateTile.disconnectGate(true);
                    targetGateTile.stargateState = EnumStargateState.IDLE;
                    targetGateTile.m_6596_();
                    this.connectedToGatePos = null;
                    this.m_6596_();
                }
            }
            this.dialedAddress.clear();
            this.dialedAddress.addAll(addressBackup);
        }
    }

    public void incomingWormhole(int dialedAddressSize) {
        this.dialedAddress.clear();
        this.listenerHandler.gateIncoming(dialedAddressSize);
        this.sendSignal("stargate_incoming_wormhole", new Object[]{dialedAddressSize});
    }

    public void incomingWormhole(int dialedAddressSize, int time) {
        this.isIncoming = true;
        this.incomingWormhole(dialedAddressSize);
        this.m_6596_();
    }

    public int getOpenSoundDelay() {
        return EnumScheduledTask.STARGATE_OPEN_SOUND.waitTicks;
    }

    protected void openGate(StargatePos targetGatePos, boolean isInitiating, boolean noxDialing) {
        this.setOpenedSince();
        this.listenerHandler.gateOpen();
        this.isInitiating = isInitiating;
        this.targetGatePos = targetGatePos;
        this.stargateState = EnumStargateState.UNSTABLE_OPENING;
        this.isNoxDialing = noxDialing;
        ChunkManager.forceChunk((ServerLevel)this.getLevelNotNull(), new ChunkPos(this.pos));
        this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.OPEN_GATE, 0, noxDialing);
        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_OPEN_SOUND, this.getOpenSoundDelay()));
        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_HORIZON_LIGHT_BLOCK, EnumScheduledTask.STARGATE_OPEN_SOUND.waitTicks + 19 + this.getTicksPerHorizonSegment()));
        if (!noxDialing) {
            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_HORIZON_WIDEN, EnumScheduledTask.STARGATE_OPEN_SOUND.waitTicks + 23 + this.getTicksPerHorizonSegment()));
        }
        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_ENGAGE));
        if (isInitiating) {
            EnergyRequiredToOperate energyRequired = this.getEnergyRequiredToDial(targetGatePos);
            this.getEnergyStorage().extractEnergy(energyRequired.energyToOpen, false);
            this.keepAliveEnergyPerTick = energyRequired.keepAlive;
        }
        this.sendSignal("stargate_open", new Object[]{isInitiating});
        JSG.logger.debug("Gate at {} opened!", (Object)this.pos.toString());
        this.m_6596_();
    }

    protected void closeGate(StargateClosedReasonEnum reason) {
        this.listenerHandler.gateClose(reason);
        this.stargateState = EnumStargateState.UNSTABLE_CLOSING;
        this.energySecondsToClose = 0.0f;
        this.resetOpenedSince();
        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_CLOSE, 62));
        this.playSoundEvent(StargateSoundEventEnum.CLOSE);
        this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLOSE_GATE, 0, false);
        this.sendSignal("stargate_close", new Object[]{reason.toString().toLowerCase()});
        JSGSoundHelper.playPositionedSound(this.world, this.getGateCenterPos(), SoundPositionedEnum.WORMHOLE_LOOP, false);
        if (this.isInitiating) {
            this.horizonFlashTask = null;
            this.isCurrentlyUnstable = false;
            this.updateFlashState();
        }
        this.targetGatePos = null;
        this.connectedToGate = false;
        this.connectingToGate = false;
        this.connectedToGatePos = null;
        this.isIncoming = false;
        JSG.logger.debug("Gate at {} closed!", (Object)this.pos.toString());
        this.m_6596_();
    }

    protected void dialingFailed(StargateOpenResult reason) {
        if (this.stargateState == EnumStargateState.DIALING || this.stargateState == EnumStargateState.DIALING_COMPUTER || this.stargateState == EnumStargateState.IDLE) {
            this.listenerHandler.gateFail(reason);
            if (this.connectedToGate) {
                if (this instanceof StargateClassicBaseBE) {
                    this.dialedAddress.addSymbol((SymbolInterface)this.getSymbolType().getOrigin());
                }
                if (this.getNetwork().getStargate(this.dialedAddress) != null) {
                    Objects.requireNonNull(this.getNetwork().getStargate(this.dialedAddress)).getBlockEntity().disconnectGate();
                }
            }
            this.sendSignal("stargate_failed", new Object[]{reason.toString().toLowerCase()});
            this.horizonFlashTask = null;
            new StargateDialFailEvent(this, reason).post();
            this.addFailedTaskAndPlaySound();
            if (this.stargateState != EnumStargateState.INCOMING) {
                this.stargateState = EnumStargateState.FAILING;
            }
            JSG.logger.debug("Gate at {} failed!", (Object)this.pos.toString());
            this.m_6596_();
        }
    }

    protected void addFailedTaskAndPlaySound() {
        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_FAIL, 53));
        this.playSoundEvent(StargateSoundEventEnum.DIAL_FAILED);
    }

    protected boolean verifyConnection() {
        if (!(this.targetGatePos != null && this.targetGatePos.getBlockEntity() != null || this.rigManager.isActive())) {
            this.closeGate(StargateClosedReasonEnum.CONNECTION_LOST);
            return false;
        }
        return true;
    }

    @Nullable
    protected abstract SoundPositionedEnum getPositionedSound(StargateSoundPositionedEnum var1);

    @Nullable
    protected abstract SoundEventEnum getSoundEvent(StargateSoundEventEnum var1);

    public void playPositionedSound(StargateSoundPositionedEnum soundEnum, boolean play) {
        SoundPositionedEnum positionedSound = this.getPositionedSound(soundEnum);
        if (positionedSound == null) {
            throw new IllegalArgumentException("Tried to play " + String.valueOf((Object)soundEnum) + " on " + this.getClass().getCanonicalName() + " which apparently doesn't support it.");
        }
        this.playPositionedSound(positionedSound, play);
    }

    public void playPositionedSound(@Nonnull SoundPositionedEnum positionedSound, boolean play) {
        if (this.getLevelNotNull().f_46443_) {
            JSGSoundHelperClient.playPositionedSoundClientSide(this.getGateCenterPos(), positionedSound, play);
        } else {
            JSGSoundHelper.playPositionedSound(this.getLevelNotNull(), this.getGateCenterPos(), positionedSound, play);
        }
    }

    public void playSoundEvent(StargateSoundEventEnum soundEnum) {
        SoundEventEnum soundEvent = this.getSoundEvent(soundEnum);
        if (soundEvent == null) {
            throw new IllegalArgumentException("Tried to play " + String.valueOf((Object)soundEnum) + " on " + this.getClass().getCanonicalName() + " which apparently doesn't support it.");
        }
        if (this.getLevelNotNull().f_46443_) {
            JSGSoundHelper.playSoundEventClientSide(this.getLevelNotNull(), this.getGateCenterPos(), soundEvent);
        } else {
            JSGSoundHelper.playSoundEvent(this.getLevelNotNull(), this.getGateCenterPos(), soundEvent);
        }
    }

    public void playSoundEvent(SoundEventEnum soundEnum) {
        if (soundEnum == null) {
            throw new IllegalArgumentException("Tried to play null on " + this.getClass().getCanonicalName() + " which apparently doesn't support it.");
        }
        if (this.getLevelNotNull().f_46443_) {
            JSGSoundHelper.playSoundEventClientSide(this.getLevelNotNull(), this.getGateCenterPos(), soundEnum);
        } else {
            JSGSoundHelper.playSoundEvent(this.getLevelNotNull(), this.getGateCenterPos(), soundEnum);
        }
    }

    public abstract BlockPos getGateCenterPos();

    @Override
    public void onLoad() {
        this.world = this.getLevelNotNull();
        if (!this.getLevelNotNull().f_46443_) {
            this.lastPos = this.pos = this.m_58899_();
            this.targetPoint = new PacketDistributor.TargetPoint((double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_(), 512.0, this.getLevelNotNull().m_46472_());
            this.generateAddresses(false);
            if (this.stargateState.engaged()) {
                this.verifyConnection();
            }
            this.m_6596_();
            this.updateFacing(true);
            this.generateMergeHelper();
        } else {
            JSGPacketHandler.sendToServer(new StateUpdateRequestToServer(this.pos, StateTypeEnum.RENDERER_STATE));
            JSGPacketHandler.sendToServer(new StateUpdateRequestToServer(this.pos, StateTypeEnum.SOUND_UPDATE));
        }
        super.onLoad();
    }

    public void generateAddresses(boolean reset) {
        if (reset && this.stargatePos != null) {
            this.getNetwork().removeStargate(this.stargatePos);
        }
        Random random = new Random((long)this.pos.hashCode() * 31L + (long)this.getLevelNotNull().m_46472_().m_135782_().hashCode());
        for (SymbolTypeEnum<?> symbolType : SymbolTypeEnum.values(SymbolUsage.STARGATES)) {
            StargateAddress address = this.getStargateAddress(symbolType);
            if (address == null || reset) {
                address = new StargateAddress(symbolType);
                address.generate(random);
            }
            this.setGateAddress(symbolType, address);
        }
    }

    public boolean getForceUnstable() {
        return false;
    }

    public float getSecondsToClose(int energyStored, int morePower) {
        if (this.keepAliveEnergyPerTick <= 0) {
            return (Integer)JSGConfig.Stargate.instabilitySeconds.get() + 5;
        }
        return (float)energyStored / (float)(this.keepAliveEnergyPerTick + morePower + this.shieldKeepAlive) / 20.0f;
    }

    @Override
    public void tick() {
        this.tickBlackHoleAnimation();
        if (this.f_58857_ != null) {
            this.rigManager.tick(!this.f_58857_.m_5776_());
        }
        if (this.f_58857_ != null && this.f_58857_.m_5776_() && this.getRendererStateClient() == null) {
            JSGPacketHandler.sendToServer(new StateUpdateRequestToServer(this.pos, StateTypeEnum.RENDERER_STATE));
        }
        if (this.pos != this.m_58899_()) {
            this.pos = this.m_58899_();
        }
        if (this.f_58857_ != this.m_58904_() && this.m_58904_() != null) {
            this.f_58857_ = this.getLevelNotNull();
        }
        if (this.mergeHelper == null) {
            this.generateMergeHelper();
        } else if (this.getCurrentBlockState().m_60734_() instanceof StargateAbstractBaseBlock && (this.mergeHelper.horizontalFacing != this.getCurrentBlockState().m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY) || this.mergeHelper.verticalFacing != JSGProperties.getDirectionByVerticalFacing((Integer)this.getCurrentBlockState().m_61143_((Property)JSGProperties.FACING_VERTICAL_PROPERTY)) || this.mergeHelper.basePos != this.m_58899_())) {
            this.mergeHelper.horizontalFacing = (Direction)this.getCurrentBlockState().m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY);
            this.mergeHelper.verticalFacing = JSGProperties.getDirectionByVerticalFacing((Integer)this.getCurrentBlockState().m_61143_((Property)JSGProperties.FACING_VERTICAL_PROPERTY));
            this.mergeHelper.basePos = this.m_58899_();
        }
        ScheduledTask.iterate(this.scheduledTasks, this.getTime());
        if (!this.getLevelNotNull().f_46443_) {
            if (!this.addedToNetwork) {
                this.addedToNetwork = true;
            }
            if (this.targetPoint == null) {
                this.targetPoint = new PacketDistributor.TargetPoint((double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_(), 512.0, this.getLevelNotNull().m_46472_());
                this.m_6596_();
            }
            if (this.stargateState.engaged() && this.targetGatePos == null && !this.rigManager.isActive()) {
                JSG.logger.error("A stargateState indicates the Gate should be open, but targetGatePos is null. This is a bug. Closing gate...");
                this.attemptClose(StargateClosedReasonEnum.CONNECTION_LOST);
            }
            if (this.stargateState.engaged() && this.lastPos != this.pos) {
                this.lastPos = this.pos;
                this.m_6596_();
                JSG.logger.error("A stargateState indicates the Gate should be open, but last pos is not matching current pos! Closing gate...");
                this.attemptClose(StargateClosedReasonEnum.CONNECTION_LOST);
                this.refresh();
            }
            this.updatePassedEntities();
            if (this.stargateState.initiating()) {
                this.eventHorizon.scheduleTeleportation(this.targetGatePos, true);
            } else if (this.stargateState.engaged()) {
                this.eventHorizon.scheduleTeleportation(this.targetGatePos, false);
            }
            if (this.getTime() % 20L == 0L && this.stargateState == EnumStargateState.ENGAGED && ((Boolean)JSGConfig.Stargate.autocloseEnabled.get()).booleanValue() && this.shouldAutoclose()) {
                if (this.targetGatePos != null) {
                    this.targetGatePos.getBlockEntity().attemptClose(StargateClosedReasonEnum.AUTOCLOSE);
                } else {
                    this.attemptClose(StargateClosedReasonEnum.AUTOCLOSE);
                }
            }
            if (this.horizonFlashTask != null && this.horizonFlashTask.isActive()) {
                this.horizonFlashTask.update(this.getTime());
            }
            if (this.getTime() % 80L == 0L && this.stargateState.engaged() && !this.rigManager.isActive()) {
                if (this.targetGatePos == null) {
                    this.attemptClose(StargateClosedReasonEnum.CONNECTION_LOST);
                } else {
                    StargateAbstractBaseBE tile = this.targetGatePos.getBlockEntity();
                    if (tile != null) {
                        if (!tile.stargateState.engaged()) {
                            this.attemptClose(StargateClosedReasonEnum.CONNECTION_LOST);
                        }
                    } else {
                        this.attemptClose(StargateClosedReasonEnum.CONNECTION_LOST);
                    }
                }
            }
            this.kawooshDestruction();
            if (this.stargateState.initiating()) {
                if (this.targetGatePos == null) {
                    this.targetGatePos = this.getNetwork().getStargate(this.getStargateAddress(SymbolTypeRegistry.MILKYWAY));
                    this.attemptClose(StargateClosedReasonEnum.CONNECTION_LOST);
                }
                int morePower = this.doTimeLimitFunc();
                this.energySecondsToClose = this.getSecondsToClose(this.getEnergyStorage().getEnergyStored(), morePower);
                if (this.energySecondsToClose >= 1.0f) {
                    boolean forceUnstable = this.getForceUnstable();
                    if (this.horizonFlashTask == null && (forceUnstable || this.energySecondsToClose < (float)((Integer)JSGConfig.Stargate.instabilitySeconds.get()).intValue() && this.energyTransferredLastTick < 0)) {
                        this.resetFlashingSequence();
                        this.shouldBeUnstable = true;
                        this.setHorizonFlashTask(new ScheduledTask(EnumScheduledTask.HORIZON_FLASH, (int)(Math.random() * 40.0) + 5));
                    }
                    if (this.horizonFlashTask != null && !forceUnstable && (this.energySecondsToClose > (float)((Integer)JSGConfig.Stargate.instabilitySeconds.get()).intValue() || this.energyTransferredLastTick >= 0)) {
                        this.horizonFlashTask = null;
                        this.isCurrentlyUnstable = false;
                        this.shouldBeUnstable = false;
                        this.updateFlashState();
                    }
                    this.getEnergyStorage().extractEnergy(this.keepAliveEnergyPerTick + morePower + this.shieldKeepAlive, false);
                    this.m_6596_();
                } else {
                    this.attemptClose(StargateClosedReasonEnum.OUT_OF_POWER);
                }
            } else if (this.shieldKeepAlive > 0) {
                this.getEnergyStorage().extractEnergy(this.shieldKeepAlive, false);
            }
            this.energyTransferredLastTick = this.getEnergyStorage().getEnergyStored() - this.energyStoredLastTick;
            this.energyStoredLastTick = this.getEnergyStorage().getEnergyStored();
        }
    }

    protected void kawooshDestruction() {
        if (this.horizonKilling) {
            ArrayList entities = new ArrayList();
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            for (int i = 0; i < this.horizonSegments; ++i) {
                if (this.localKillingBoxes.size() <= i) continue;
                JSGAxisAlignedBB gBox = this.localKillingBoxes.get(i).offset(this.pos);
                entities.addAll(this.getLevelNotNull().m_45933_(null, (AABB)gBox));
                for (BlockPos bPos : BlockPos.m_121976_((int)((int)Math.floor(gBox.f_82288_)), (int)((int)Math.floor(gBox.f_82289_)), (int)((int)Math.floor(gBox.f_82290_)), (int)((int)Math.ceil(gBox.f_82291_) - 1), (int)((int)Math.ceil(gBox.f_82292_) - 1), (int)((int)Math.ceil(gBox.f_82293_) - 1))) {
                    blocks.add(bPos.m_7949_());
                }
            }
            for (JSGAxisAlignedBB lBox : this.localInnerEntityBoxes) {
                entities.addAll(this.getLevelNotNull().m_45933_(null, (AABB)lBox.offset(this.pos)));
            }
            for (JSGAxisAlignedBB lBox : this.localInnerBlockBoxes) {
                JSGAxisAlignedBB gBox = lBox.offset(this.pos);
                for (BlockPos bPos : BlockPos.m_121976_((int)((int)gBox.f_82288_), (int)((int)gBox.f_82289_), (int)((int)gBox.f_82290_), (int)((int)gBox.f_82291_ - 1), (int)((int)gBox.f_82292_ - 1), (int)((int)gBox.f_82293_ - 1))) {
                    blocks.add(bPos.m_7949_());
                }
            }
            for (Entity entity : entities) {
                TeleportHelper.kawooshKill(entity);
                JSGPacketHandler.sendToClient(new StateUpdatePacketToClient(this.pos, StateTypeEnum.STARGATE_VAPORIZE_BLOCK_PARTICLES, new StargateVaporizeBlockParticlesRequest(entity.m_20183_())), this.targetPoint);
            }
            for (BlockPos dPos : blocks) {
                if (dPos.equals((Object)this.getGateCenterPos())) continue;
                BlockState state = this.getLevelNotNull().m_8055_(dPos);
                if (this.world.m_8055_(dPos).m_60795_() || !(state.m_60800_((BlockGetter)this.world, dPos) >= 0.0f) || !JSGConfigUtil.canKawooshDestroyBlock(state)) continue;
                this.world.m_46597_(dPos, Blocks.f_50016_.m_49966_());
                JSGPacketHandler.sendToClient(new StateUpdatePacketToClient(this.pos, StateTypeEnum.STARGATE_VAPORIZE_BLOCK_PARTICLES, new StargateVaporizeBlockParticlesRequest(dPos)), this.targetPoint);
            }
        }
    }

    public abstract EnumSet<BiomeOverlayEnum> getSupportedOverlays();

    public BiomeOverlayEnum getBiomeOverlayWithOverride(boolean override) {
        return BiomeOverlayEnum.updateBiomeOverlay(this.world, this.getMergeHelper().getTopBlock(), this.getSupportedOverlays());
    }

    public boolean shouldAutoclose() {
        if (!this.rigManager.isActive() && this.targetGatePos != null) {
            return this.getAutoCloseManager().shouldClose(this.targetGatePos);
        }
        return !this.rigManager.isActive();
    }

    public void resetOpenedSince() {
        this.openedSince = -1L;
        this.m_6596_();
    }

    public void setOpenedSince() {
        this.openedSince = this.getTime();
        this.m_6596_();
    }

    public void clearDHDSymbols() {
    }

    public void activateDHDBRB() {
    }

    protected int doTimeLimitFunc() {
        boolean enabled;
        int morePower = 0;
        this.getOpenedSeconds();
        int configPower = (Integer)JSGConfig.Stargate.maxOpenedPowerDrawAfterLimit.get();
        int maxSeconds = (Integer)JSGConfig.Stargate.maxOpenedSeconds.get();
        StargateTimeLimitModeEnum limitMode = (StargateTimeLimitModeEnum)((Object)JSGConfig.Stargate.maxOpenedWhat.get());
        StargateAbstractBaseBE stargateAbstractBaseBE = this;
        if (stargateAbstractBaseBE instanceof StargateClassicBaseBE) {
            StargateClassicBaseBE casted = (StargateClassicBaseBE)stargateAbstractBaseBE;
            limitMode = (StargateTimeLimitModeEnum)((Object)((JSGEnumConfigOption)casted.getConfig().getOption("timeLimitMode")).getValue());
            maxSeconds = (Integer)((JSGIntRangeConfigOption)casted.getConfig().getOption("timeLimitTime")).getValue();
            configPower = (Integer)((JSGIntRangeConfigOption)casted.getConfig().getOption("timeLimitPower")).getValue();
        }
        boolean bl = enabled = limitMode != StargateTimeLimitModeEnum.DISABLED;
        if (enabled && this.getOpenedSeconds() >= (long)maxSeconds) {
            if (limitMode == StargateTimeLimitModeEnum.CLOSE_GATE) {
                this.attemptClose(StargateClosedReasonEnum.CONNECTION_LOST);
                this.clearDHDSymbols();
            } else {
                morePower = (int)((double)this.getOpenedSeconds() / (double)maxSeconds * (double)configPower);
            }
        }
        return morePower;
    }

    public long getOpenedSeconds() {
        if (this.openedSince <= 0L) {
            return -1L;
        }
        return (this.getTime() - this.openedSince) / 20L;
    }

    public String getOpenedSecondsToDisplayAsMinutes() {
        long openedSeconds = this.getOpenedSeconds();
        if (openedSeconds < 1L) {
            return "Closed!";
        }
        int minutes = (int)Math.floor((double)openedSeconds / 60.0);
        int seconds = (int)(openedSeconds - (long)(60 * minutes));
        String secondsString = seconds < 10 ? "0" + seconds : "" + seconds;
        return minutes + ":" + secondsString + "min";
    }

    protected void extractEnergyByShield(int keepAlive) {
        this.shieldKeepAlive = keepAlive;
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.rigManager.onUnload();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
    }

    protected abstract JSGAxisAlignedBB getHorizonKillingBox(boolean var1);

    protected abstract int getHorizonSegmentCount(boolean var1);

    protected abstract List<JSGAxisAlignedBB> getGateVaporizingBoxes(boolean var1);

    public int getTicksPerHorizonSegment() {
        return 12 / this.getHorizonSegmentCount(true);
    }

    public List<JSGAxisAlignedBB> getLocalKillingBoxes() {
        return this.localKillingBoxes;
    }

    public List<JSGAxisAlignedBB> getLocalInnerBlockBoxes() {
        return this.localInnerBlockBoxes;
    }

    protected StargateAbstractRendererState.StargateAbstractRendererStateBuilder getRendererStateServer() {
        return StargateAbstractRendererState.builder().setStargateState(this.stargateState);
    }

    protected abstract StargateAbstractRendererState createRendererStateClient();

    public StargateAbstractRendererState getRendererStateClient() {
        return this.rendererStateClient;
    }

    protected void setRendererStateClient(StargateAbstractRendererState rendererState) {
        this.rendererStateClient = rendererState;
        JSGSoundHelper.playPositionedSound(this.world, this.getGateCenterPos(), SoundPositionedEnum.WORMHOLE_LOOP, rendererState.doEventHorizonRender);
        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_LIGHTING_UPDATE_CLIENT, 10));
    }

    public void updateFacing(boolean server) {
        this.generateMergeHelper();
        this.eventHorizon = new EventHorizon(this.getLevelNotNull(), this.pos, this.getGateCenterPos(), this.getFacing(), this.getFacingVertical(), this.getHorizonTeleportBox(server));
        JSGAxisAlignedBB kBox = this.getHorizonKillingBox(server);
        double width = kBox.f_82293_ - kBox.f_82290_;
        width /= (double)this.getHorizonSegmentCount(server);
        Vec3 offset = new Vec3(0.5, 0.0, 0.5);
        if (this.getFacingVertical() != Direction.SOUTH) {
            offset = this.getFacing().m_122434_() == Direction.Axis.Z ? new Vec3(0.5, 0.5, (double)(this.getFacing().m_122431_() > 0 == this.getFacingVertical().m_122430_() > 0 ? 1 : 0)) : new Vec3((double)(this.getFacing().m_122429_() > 0 == this.getFacingVertical().m_122430_() > 0 ? 1 : 0), 0.5, 0.5);
        }
        this.localKillingBoxes = new ArrayList<JSGAxisAlignedBB>(this.getHorizonSegmentCount(server));
        for (int i = 0; i < this.getHorizonSegmentCount(server); ++i) {
            JSGAxisAlignedBB box = new JSGAxisAlignedBB(kBox.f_82288_, kBox.f_82289_, kBox.f_82290_ + width * (double)i, kBox.f_82291_, kBox.f_82292_, kBox.f_82290_ + width * (double)(i + 1));
            box = box.rotate(this.getFacing(), this.getFacingVertical()).offset(offset);
            this.localKillingBoxes.add(box);
        }
        this.localInnerBlockBoxes = new ArrayList<JSGAxisAlignedBB>();
        this.localInnerEntityBoxes = new ArrayList<JSGAxisAlignedBB>();
        for (JSGAxisAlignedBB lBox : this.getGateVaporizingBoxes(server)) {
            this.localInnerBlockBoxes.add(lBox.rotate(this.getFacing(), this.getFacingVertical()).offset(offset));
            this.localInnerEntityBoxes.add(lBox.grow(0.0, 0.0, -0.25).rotate(this.getFacing(), this.getFacingVertical()).offset(offset));
        }
    }

    public final boolean isMerged() {
        return this.isMerged;
    }

    @Override
    public StargateAbstractMergeHelper getMergeHelper() {
        if (this.mergeHelper == null) {
            this.generateMergeHelper();
        }
        return this.mergeHelper;
    }

    public void updatePassedEntities() {
        if (!this.stargateState.engaged()) {
            if (!this.entitiesPassedLast.isEmpty()) {
                this.entitiesPassedLast.clear();
            }
            this.m_6596_();
            return;
        }
        AABB scanBox = new AABB(this.getGateCenterPos().m_121955_(new Vec3i(-5, -5, -5)), this.getGateCenterPos().m_121955_(new Vec3i(5, 5, 5)));
        final List entities = this.world.m_45933_(null, scanBox);
        ArrayList<Integer> ids = new ArrayList<Integer>(){
            {
                for (Entity e : entities) {
                    this.add(e.m_19879_());
                }
            }
        };
        HashMap<Integer, Entity> clonedEntitiesLast = new HashMap<Integer, Entity>(){
            {
                this.putAll(StargateAbstractBaseBE.this.entitiesPassedLast);
            }
        };
        Iterator iterator = clonedEntitiesLast.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (ids.contains(i)) continue;
            this.entitiesPassedLast.remove(i);
        }
        this.m_6596_();
    }

    public final void entityPassing(Entity entity, boolean inbound, boolean isCreateEntity) {
        boolean isPlayer;
        if (inbound) {
            this.entitiesPassedLast.put(entity.m_19879_(), entity);
        }
        boolean bl = isPlayer = isCreateEntity || entity instanceof ServerPlayer;
        if (isPlayer || entity instanceof Villager) {
            this.getAutoCloseManager().playerPassing();
        }
        this.m_6596_();
        this.sendSignal("stargate_traveler", new Object[]{inbound, isPlayer, entity.getClass().getSimpleName()});
    }

    private void setHorizonFlashTask(ScheduledTask horizonFlashTask) {
        horizonFlashTask.setExecutor(this);
        horizonFlashTask.setTaskCreated(this.getTime());
        this.horizonFlashTask = horizonFlashTask;
        this.m_6596_();
    }

    private void resetFlashingSequence() {
        this.flashIndex = 0;
        this.isCurrentlyUnstable = false;
    }

    private void updateFlashState() {
        JSGPacketHandler.sendToClient(new StateUpdatePacketToClient(this.pos, StateTypeEnum.FLASH_STATE, new StargateFlashState(this.isCurrentlyUnstable)), this.targetPoint);
        if (this.targetGatePos != null) {
            BlockPos tPos = this.targetGatePos.gatePos;
            JSGPacketHandler.sendToClient(new StateUpdatePacketToClient(tPos, StateTypeEnum.FLASH_STATE, new StargateFlashState(this.isCurrentlyUnstable)), new PacketDistributor.TargetPoint((double)tPos.m_123341_(), (double)tPos.m_123342_(), (double)tPos.m_123343_(), 512.0, this.targetGatePos.dimension));
        }
    }

    public boolean isSpinning() {
        return false;
    }

    @Override
    public State getState(StateTypeEnum stateType) {
        switch (stateType) {
            case RENDERER_STATE: {
                return this.getRendererStateServer().build();
            }
            case SOUND_UPDATE: {
                StateSoundPositionedUpdate state = new StateSoundPositionedUpdate();
                state.add(SoundPositionedEnum.WORMHOLE_LOOP, this.getStargateState().engaged());
                state.add(this.getPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL), this.isSpinning());
                return state;
            }
            case BLACK_HOLE_ANIMATION_UPDATE: {
                return this.blackHoleAnimationState;
            }
        }
        return super.getState(stateType);
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        return switch (stateType) {
            case StateTypeEnum.RENDERER_STATE -> this.createRendererStateClient();
            case StateTypeEnum.SOUND_UPDATE -> new StateSoundPositionedUpdate();
            case StateTypeEnum.RENDERER_UPDATE -> new StargateRendererActionState();
            case StateTypeEnum.STARGATE_VAPORIZE_BLOCK_PARTICLES -> new StargateVaporizeBlockParticlesRequest();
            case StateTypeEnum.FLASH_STATE -> new StargateFlashState();
            case StateTypeEnum.BLACK_HOLE_ANIMATION_UPDATE -> this.blackHoleAnimationState;
            default -> super.createState(stateType);
        };
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setState(StateTypeEnum stateType, State state) {
        block0 : switch (stateType) {
            case RENDERER_STATE: {
                this.setRendererStateClient(((StargateAbstractRendererState)state).initClient(this.pos, this.getBiomeOverlayWithOverride(false)));
                this.updateFacing(false);
                break;
            }
            case BLACK_HOLE_ANIMATION_UPDATE: {
                this.blackHoleAnimationState = (BlackHoleAnimationState)state;
                this.m_6596_();
                break;
            }
            case SOUND_UPDATE: {
                StateSoundPositionedUpdate s = (StateSoundPositionedUpdate)state;
                for (Map.Entry<Integer, Boolean> e : s.soundMap.entrySet()) {
                    SoundPositionedEnum sound = SoundPositionedEnum.values()[e.getKey()];
                    if (sound == null) continue;
                    this.playPositionedSound(sound, (boolean)e.getValue());
                }
                break;
            }
            case RENDERER_UPDATE: {
                if (this.getRendererStateClient() == null && ((StargateRendererActionState)state).action != StargateRendererActionState.EnumGateAction.GATE_RENDER_CHANGED) break;
                switch (((StargateRendererActionState)state).action) {
                    case OPEN_GATE: {
                        boolean noxDialing = ((StargateRendererActionState)state).modifyFinal;
                        this.getRendererStateClient().horizonSegments = 0;
                        this.getRendererStateClient().openGate(this.getTime(), noxDialing);
                        break block0;
                    }
                    case CLOSE_GATE: {
                        this.getRendererStateClient().closeGate(this.getTime());
                        break block0;
                    }
                    case STARGATE_HORIZON_WIDEN: {
                        ++this.getRendererStateClient().horizonSegments;
                        break block0;
                    }
                    case STARGATE_HORIZON_SHRINK: {
                        --this.getRendererStateClient().horizonSegments;
                        break block0;
                    }
                    case GATE_RENDER_CHANGED: {
                        this.isMerged = ((StargateRendererActionState)state).modifyFinal;
                        this.m_6596_();
                        break block0;
                    }
                }
                break;
            }
            case STARGATE_VAPORIZE_BLOCK_PARTICLES: {
                break;
            }
            case FLASH_STATE: {
                if (this.getRendererStateClient() == null) break;
                this.getRendererStateClient().horizonUnstable = ((StargateFlashState)state).flash;
                break;
            }
        }
        super.setState(stateType, state);
    }

    @Override
    public void addTask(ScheduledTask scheduledTask) {
        scheduledTask.setExecutor(this);
        scheduledTask.setTaskCreated(this.getTime());
        this.scheduledTasks.add(scheduledTask);
        this.m_6596_();
    }

    public void removeTask(ScheduledTask scheduledTask) {
        this.scheduledTasks.remove(scheduledTask);
        this.m_6596_();
    }

    public int getOriginId() {
        return 5;
    }

    public void setOriginId(CompoundTag compound) {
        compound.m_128405_("originId", this.getOriginId());
    }

    public ItemStack getAddressPage(SymbolTypeEnum<?> symbolType, ItemStack defaultStack, int[] symbolsToDisplay) {
        ItemStack stack = defaultStack;
        if (stack.m_41720_() == ItemRegistry.UNIVERSE_DIALER.get()) {
            ListTag saved = Objects.requireNonNull(stack.m_41784_()).m_128437_("saved", 10);
            CompoundTag compound = this.gateAddressMap.get(symbolType).serializeNBT();
            compound.m_128385_("symbolsToDisplay", symbolsToDisplay);
            this.setOriginId(compound);
            saved.add((Object)compound);
        } else {
            JSG.logger.info("Giving Notebook page of address {}", symbolType);
            CompoundTag compound = PageNotebookItemFilled.getCompoundFromAddress((IAddress)this.gateAddressMap.get(symbolType), symbolsToDisplay, PageNotebookItemFilled.getRegistryPathFromWorld(this.world, this.pos), this.getOriginId(), NotebookPageSerialization.STARGATES);
            stack = new ItemStack((ItemLike)ItemRegistry.NOTEBOOK_PAGE_FILLED.get(), 1);
            stack.m_41751_(compound);
        }
        return stack;
    }

    @Override
    public void executeTask(EnumScheduledTask scheduledTask, CompoundTag customData) {
        switch (scheduledTask) {
            case STARGATE_OPEN_SOUND: {
                if (this.isNoxDialing) {
                    this.playSoundEvent(StargateSoundEventEnum.OPEN_NOX);
                    break;
                }
                this.playSoundEvent(StargateSoundEventEnum.OPEN);
                break;
            }
            case STARGATE_HORIZON_LIGHT_BLOCK: {
                if (!this.getLevelNotNull().m_8055_(this.getGateCenterPos()).m_60795_()) break;
                this.getLevelNotNull().m_46597_(this.getGateCenterPos(), (BlockState)Blocks.f_152480_.m_49966_().m_61124_((Property)BlockStateProperties.f_61422_, (Comparable)Integer.valueOf(15)));
                break;
            }
            case STARGATE_HORIZON_WIDEN: {
                if (!this.horizonKilling) {
                    this.horizonKilling = true;
                }
                ++this.horizonSegments;
                JSGPacketHandler.sendToClient(new StateUpdatePacketToClient(this.pos, StateTypeEnum.RENDERER_UPDATE, StargateRendererActionState.STARGATE_HORIZON_WIDEN_ACTION), this.targetPoint);
                if (this.horizonSegments < this.getHorizonSegmentCount(true)) {
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_HORIZON_WIDEN, this.getTicksPerHorizonSegment()));
                    break;
                }
                this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_HORIZON_SHRINK, this.getTicksPerHorizonSegment() + 12));
                break;
            }
            case STARGATE_HORIZON_SHRINK: {
                --this.horizonSegments;
                JSGPacketHandler.sendToClient(new StateUpdatePacketToClient(this.pos, StateTypeEnum.RENDERER_UPDATE, StargateRendererActionState.STARGATE_HORIZON_SHRINK_ACTION), this.targetPoint);
                if (this.horizonSegments > 0) {
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_HORIZON_SHRINK, this.getTicksPerHorizonSegment() + 1));
                } else {
                    this.horizonKilling = false;
                }
                this.m_6596_();
                break;
            }
            case STARGATE_CLOSE: {
                if (this.getLevelNotNull().m_8055_(this.getGateCenterPos()).m_60734_() == Blocks.f_152480_) {
                    this.getLevelNotNull().m_46597_(this.getGateCenterPos(), Blocks.f_50016_.m_49966_());
                }
                this.disconnectGate();
                break;
            }
            case STARGATE_FAIL: {
                this.failGate();
                break;
            }
            case STARGATE_ENGAGE: {
                if (!this.verifyConnection()) break;
                this.engageGate();
                break;
            }
            case STARGATE_LIGHTING_UPDATE_CLIENT: {
                this.getLevelNotNull().m_151543_(this.getGateCenterPos());
                break;
            }
            case HORIZON_FLASH: {
                this.isCurrentlyUnstable ^= true;
                if (this.isCurrentlyUnstable) {
                    ++this.flashIndex;
                    if (this.flashIndex == 1 && this.targetGatePos != null) {
                        JSGAdvancementsUtil.tryTriggerRangedAdvancement(this, JSGAdvancementsUtil.EnumAdvancementType.GATE_FLICKER);
                        JSGSoundHelper.playSoundEvent(this.getLevelNotNull(), this.getGateCenterPos(), SoundEventEnum.WORMHOLE_FLICKER);
                        JSGSoundHelper.playSoundEvent(this.targetGatePos.getWorld(), this.targetGatePos.getBlockEntity().getGateCenterPos(), SoundEventEnum.WORMHOLE_FLICKER);
                    }
                    this.setHorizonFlashTask(new ScheduledTask(EnumScheduledTask.HORIZON_FLASH, (int)(Math.random() * 3.0) + 3));
                } else if (this.flashIndex == 1) {
                    this.setHorizonFlashTask(new ScheduledTask(EnumScheduledTask.HORIZON_FLASH, (int)(Math.random() * 4.0) + 1));
                } else {
                    float mul = this.energySecondsToClose / (float)((Integer)JSGConfig.Stargate.instabilitySeconds.get()).intValue();
                    if (this.getForceUnstable()) {
                        mul = 0.5f;
                    }
                    int min = (int)(15.0f * mul);
                    int off = (int)(20.0f * mul);
                    this.setHorizonFlashTask(new ScheduledTask(EnumScheduledTask.HORIZON_FLASH, min + (int)(Math.random() * (double)off)));
                    this.resetFlashingSequence();
                }
                this.updateFlashState();
                this.m_6596_();
                break;
            }
        }
    }

    public int getEnergyTransferredLastTick() {
        return this.energyTransferredLastTick;
    }

    public float getEnergySecondsToClose() {
        return this.energySecondsToClose;
    }

    protected abstract SmallEnergyStorage getEnergyStorage();

    public SmallEnergyStorage getEnergyStorageForApi() {
        return this.getEnergyStorage();
    }

    public int getEnergyStored() {
        return this.getEnergyStorage().getEnergyStored();
    }

    public EnergyRequiredToOperate getEnergyRequiredToDialForApi(StargatePos targetGatePos) {
        return this.getEnergyRequiredToDial(targetGatePos);
    }

    protected EnergyRequiredToOperate getEnergyRequiredToDial(StargatePos targetGatePos) {
        BlockPos sPos = this.pos;
        BlockPos tPos = targetGatePos.gatePos;
        ResourceKey sourceDim = this.getLevelNotNull().m_46472_();
        ResourceKey targetDim = targetGatePos.getWorld().m_46472_();
        if (sourceDim == Level.f_46428_ && targetDim == Level.f_46429_) {
            tPos = new BlockPos(tPos.m_123341_() * 8, tPos.m_123342_(), tPos.m_123343_() * 8);
        } else if (sourceDim == Level.f_46429_ && targetDim == Level.f_46428_) {
            sPos = new BlockPos(sPos.m_123341_() * 8, sPos.m_123342_(), sPos.m_123343_() * 8);
        }
        double distance = (int)BlockPosHelper.dist((Vec3i)sPos, tPos.m_123341_(), tPos.m_123342_(), tPos.m_123343_());
        distance = distance < 5000.0 ? (distance *= 0.8) : 5000.0 * Math.log10(distance) / Math.log10(5000.0);
        EnergyRequiredToOperate energyRequired = EnergyRequiredToOperate.stargate();
        energyRequired = energyRequired.mul(distance).add(StargateDimensionConfig.INSTANCE.getCost((ResourceKey<Level>)sourceDim, (ResourceKey<Level>)targetDim));
        if (this.dialedAddress.size() == 9) {
            energyRequired.mul((Double)JSGConfig.Stargate.nineSymbolAddressMul.get());
        }
        if (this.dialedAddress.size() == 8) {
            energyRequired.mul((Double)JSGConfig.Stargate.eightSymbolAddressMul.get());
        }
        return energyRequired;
    }

    public boolean hasEnergyToDial(StargatePos targetGatePos) {
        EnergyRequiredToOperate energyRequired = this.getEnergyRequiredToDial(targetGatePos);
        return this.getEnergyStorage().getEnergyStored() >= energyRequired.energyToOpen;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction facing) {
        if (capability == ForgeCapabilities.ENERGY) {
            return LazyOptional.of(this::getEnergyStorage).cast();
        }
        LazyOptional<T> computerCaps = this.getDeviceHolder().getOrCreateDeviceBasedOnCap(capability);
        if (computerCaps.isPresent()) {
            return computerCaps;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void m_183515_(@NotNull CompoundTag compound) {
        for (StargateAddress stargateAddress : this.gateAddressMap.values()) {
            compound.m_128365_("address_" + String.valueOf(stargateAddress.getSymbolType()), (Tag)stargateAddress.serializeNBT());
        }
        compound.m_128365_("dialedAddress", (Tag)this.dialedAddress.serializeNBT());
        if (this.targetGatePos != null) {
            compound.m_128365_("targetGatePos", (Tag)this.targetGatePos.serializeNBT());
        }
        if (this.connectedToGatePos != null) {
            compound.m_128365_("connectedToGatePos", (Tag)this.connectedToGatePos.serializeNBT());
        }
        compound.m_128379_("connectingToGate", this.connectingToGate);
        compound.m_128379_("connectedToGate", this.connectedToGate);
        compound.m_128379_("isMerged", this.isMerged);
        compound.m_128365_("autoCloseManager", (Tag)this.getAutoCloseManager().serializeNBT());
        compound.m_128405_("keepAliveCostPerTick", this.keepAliveEnergyPerTick);
        if (this.stargateState != null) {
            compound.m_128405_("stargateState", this.stargateState.id);
        }
        compound.m_128365_("scheduledTasks", (Tag)ScheduledTask.serializeList(this.scheduledTasks));
        compound.m_128365_("energyStorage", (Tag)this.getEnergyStorage().serializeNBT());
        compound.m_128379_("horizonKilling", this.horizonKilling);
        compound.m_128405_("horizonSegments", this.horizonSegments);
        compound.m_128356_("openedSince", this.openedSince);
        compound.m_128356_("lastPos", this.lastPos != null ? this.lastPos.m_121878_() : this.pos.m_121878_());
        compound.m_128365_("blackHoleAnimationManager", (Tag)this.blackHoleAnimationState.serializeNBT());
        compound.m_128365_("listenerHandler", (Tag)this.listenerHandler.serializeNBT());
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(@NotNull CompoundTag compound) {
        for (SymbolTypeEnum<?> symbolType : SymbolTypeEnum.values(SymbolUsage.STARGATES)) {
            if (!compound.m_128441_("address_" + String.valueOf(symbolType))) continue;
            this.gateAddressMap.put(symbolType, new StargateAddress(compound.m_128469_("address_" + String.valueOf(symbolType))));
        }
        this.dialedAddress.deserializeNBT(compound.m_128469_("dialedAddress"));
        if (compound.m_128441_("targetGatePos")) {
            this.targetGatePos = new StargatePos(compound.m_128469_("targetGatePos"));
        }
        if (compound.m_128441_("connectedToGatePos")) {
            this.connectedToGatePos = new StargatePos(compound.m_128469_("connectedToGatePos"));
        }
        this.connectingToGate = compound.m_128471_("connectingToGate");
        this.connectedToGate = compound.m_128471_("connectedToGate");
        this.isMerged = compound.m_128471_("isMerged");
        this.getAutoCloseManager().deserializeNBT(compound.m_128469_("autoCloseManager"));
        try {
            ScheduledTask.deserializeList(compound.m_128469_("scheduledTasks"), this.scheduledTasks, this);
        }
        catch (ClassCastException | IndexOutOfBoundsException | NullPointerException e) {
            JSG.logger.warn("Exception at reading NBT");
            JSG.logger.warn("If loading world used with previous version and nothing game-breaking doesn't happen, please ignore it", (Throwable)e);
        }
        this.getEnergyStorage().deserializeNBT(compound.m_128469_("energyStorage"));
        this.keepAliveEnergyPerTick = compound.m_128451_("keepAliveCostPerTick");
        this.stargateState = EnumStargateState.valueOf(compound.m_128451_("stargateState"));
        if (this.stargateState == null) {
            this.stargateState = EnumStargateState.IDLE;
        }
        this.horizonKilling = compound.m_128471_("horizonKilling");
        this.horizonSegments = compound.m_128451_("horizonSegments");
        this.openedSince = compound.m_128454_("openedSince");
        this.lastPos = compound.m_128441_("lastPos") ? BlockPos.m_122022_((long)compound.m_128454_("lastPos")) : this.pos;
        this.blackHoleAnimationState.deserializeNBT(compound.m_128469_("blackHoleAnimationManager"));
        this.listenerHandler.deserializeNBT(compound.m_128469_("listenerHandler"));
        super.m_142466_(compound);
    }

    public SymbolInterface getSymbolFromNameIndex(Object nameIndex) throws IllegalArgumentException {
        SymbolInterface symbol = null;
        if (nameIndex instanceof Integer) {
            symbol = (SymbolInterface)this.getSymbolType().valueOf((Integer)nameIndex);
        } else if (nameIndex instanceof Double) {
            symbol = (SymbolInterface)this.getSymbolType().valueOf(((Double)nameIndex).intValue());
        } else if (nameIndex instanceof String) {
            symbol = (SymbolInterface)this.getSymbolType().fromEnglishName((String)nameIndex);
        } else if (nameIndex instanceof byte[]) {
            symbol = (SymbolInterface)this.getSymbolType().fromEnglishName(new String((byte[])nameIndex));
        }
        if (symbol == null) {
            symbol = (SymbolInterface)this.getSymbolType().fromEnglishName(nameIndex.toString());
        }
        if (symbol == null) {
            throw new IllegalArgumentException("bad argument (symbol name/index invalid) (tried: " + String.valueOf(nameIndex) + ")");
        }
        return symbol;
    }

    public void checkForBlackHoleAfterOpening() {
        if (!this.getStargateState().engaged() && !this.getStargateState().unstable()) {
            this.checkedForBlackHole = false;
            return;
        }
        if (this.checkedForBlackHole) {
            return;
        }
        this.checkedForBlackHole = true;
        Level targetLevel = this.targetGatePos == null ? null : this.targetGatePos.getWorld();
        StargateDimensionConfigEntry entry = StargateDimensionConfig.INSTANCE.getConfigEntry((ResourceKey<Level>)(targetLevel != null ? targetLevel.m_46472_() : null));
        StargateDimensionConfigEntry entryIncoming = StargateDimensionConfig.INSTANCE.getConfigEntry(this.f_58857_ != null ? this.f_58857_.m_46472_() : null);
        boolean shouldBeBlackHole = TimeUtils.isAprilFirst() || entry != null && entry.isBlackHoleDim || entryIncoming != null && entryIncoming.isBlackHoleDim;
        this.blackHoleAnimationState.setConnectedToBlackHole(shouldBeBlackHole, entryIncoming != null && entryIncoming.isBlackHoleDim);
    }

    public void tickBlackHoleAnimation() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.checkForBlackHoleAfterOpening();
        }
        this.blackHoleAnimationState.tick();
    }

    public boolean isRIGAllowed() {
        return false;
    }

    public boolean isIncomingAnimationAllowed(boolean spinning) {
        return false;
    }

    public void createDeviceHolder() {
        this.computerDeviceHolder = new ComputerDeviceHolder(this);
    }

    @Override
    public ComputerDeviceHolder getDeviceHolder() {
        if (this.computerDeviceHolder == null) {
            this.createDeviceHolder();
        }
        return this.computerDeviceHolder;
    }

    @Override
    public String getDeviceType() {
        return "STARGATE_ABSTRACT";
    }

    protected record ResultTargetValid(StargateOpenResult result, boolean targetValid, String message) {
    }
}

