/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.blockentity.stargate;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.blockentity.stargate.StargateClassicBaseBE;
import dev.tauri.jsg.blockentity.util.ScheduledTask;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.config.stargate.StargateDimensionConfig;
import dev.tauri.jsg.helpers.BlockPosHelper;
import dev.tauri.jsg.multistructure.mergehelper.StargateUniverseMergeHelper;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.StateUpdatePacketToClient;
import dev.tauri.jsg.power.general.EnergyRequiredToOperate;
import dev.tauri.jsg.property.JSGProperties;
import dev.tauri.jsg.registry.BlockEntityRegistry;
import dev.tauri.jsg.renderer.stargate.StargateClassicRendererState;
import dev.tauri.jsg.renderer.stargate.StargateUniverseRendererState;
import dev.tauri.jsg.sound.JSGSoundHelper;
import dev.tauri.jsg.sound.SoundEventEnum;
import dev.tauri.jsg.sound.SoundPositionedEnum;
import dev.tauri.jsg.sound.StargateSoundEventEnum;
import dev.tauri.jsg.sound.StargateSoundPositionedEnum;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import dev.tauri.jsg.stargate.EnumDialingType;
import dev.tauri.jsg.stargate.EnumIrisMode;
import dev.tauri.jsg.stargate.EnumScheduledTask;
import dev.tauri.jsg.stargate.EnumSpinDirection;
import dev.tauri.jsg.stargate.EnumStargateState;
import dev.tauri.jsg.stargate.NearbyGate;
import dev.tauri.jsg.stargate.StargateOpenResult;
import dev.tauri.jsg.stargate.StargateTypeEnum;
import dev.tauri.jsg.stargate.network.StargateAddress;
import dev.tauri.jsg.stargate.network.StargateAddressDynamic;
import dev.tauri.jsg.stargate.network.StargatePos;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import dev.tauri.jsg.stargate.network.SymbolTypeRegistry;
import dev.tauri.jsg.stargate.network.SymbolUniverseEnum;
import dev.tauri.jsg.state.State;
import dev.tauri.jsg.state.StateTypeEnum;
import dev.tauri.jsg.state.stargate.StargateRendererActionState;
import dev.tauri.jsg.state.stargate.StargateSpinState;
import dev.tauri.jsg.state.stargate.StargateUniverseSymbolState;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StargateUniverseBaseBE
extends StargateClassicBaseBE {
    protected ResourceKey<Level> fakeWorld;
    protected BlockPos fakePos;
    private static final EnumSet<BiomeOverlayEnum> SUPPORTED_OVERLAYS = EnumSet.of(BiomeOverlayEnum.NORMAL, BiomeOverlayEnum.FROST, BiomeOverlayEnum.MOSSY, BiomeOverlayEnum.AGED);
    private StargateAddress addressToDial;
    private int symbolsToDialCount;
    private int addressPosition;
    private boolean abortingDialing = false;
    private static final int fastDialingPeriod = 30;
    private int coolDown = 0;
    private static final int COOL_DOWN_DELAY = 60;
    private BlockPos lastPos = BlockPos.f_121853_;
    private boolean wasStargateActivated = false;

    public StargateUniverseBaseBE(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.STARGATE_UNIVERSE_BASE_BE.get(), pos, state);
    }

    @Override
    public ResourceKey<Level> getFakeWorld() {
        if (this.fakeWorld == null) {
            return this.world.m_46472_();
        }
        return this.fakeWorld;
    }

    @Override
    public void setFakeWorld(Level world) {
        this.fakeWorld = world.m_46472_();
        this.m_6596_();
    }

    @Override
    public BlockPos getFakePos() {
        if (this.fakePos == null) {
            return this.pos;
        }
        return this.fakePos;
    }

    @Override
    public void setFakePos(BlockPos pos) {
        this.fakePos = pos;
        this.m_6596_();
    }

    public void resetFakePos() {
        this.fakePos = this.pos;
        this.fakeWorld = this.world.m_46472_();
        this.m_6596_();
    }

    public boolean canContinue() {
        return this.coolDown <= 0;
    }

    public void updateCoolDown() {
        if (this.coolDown > 0) {
            --this.coolDown;
        }
        if (this.coolDown < 0) {
            this.coolDown = 0;
        }
        this.m_6596_();
    }

    public void setCoolDown() {
        this.coolDown = 60;
        this.m_6596_();
    }

    @Override
    public void tick() {
        super.tick();
        this.updateCoolDown();
        this.updateFloorChevron();
        if (!this.world.f_46443_ && !this.lastPos.equals((Object)this.pos)) {
            this.lastPos = this.pos;
            this.m_6596_();
        }
    }

    @Override
    public void onGateMerged() {
        super.onGateMerged();
    }

    @Override
    public void updateLinkStatus() {
    }

    public StargateAddress getAddressToDial() {
        return this.addressToDial;
    }

    @Override
    public void addSymbolToAddressDHD(SymbolInterface symbol) {
        if (this.isNoxDialing) {
            this.stargateState = EnumStargateState.DIALING;
            this.m_6596_();
            this.addSymbolToAddress(symbol);
            this.stargateState = EnumStargateState.IDLE;
            this.m_6596_();
        }
    }

    @Override
    public boolean dialAddress(StargateAddress address, int symbolCount, boolean withoutEnergy, EnumDialingType dialingType) {
        if (!this.canContinue()) {
            return false;
        }
        if (!this.stargateState.idle()) {
            return false;
        }
        super.dialAddress(address, symbolCount, withoutEnergy, dialingType);
        if (this.isNoxDialing) {
            for (int i = 0; i < symbolCount; ++i) {
                this.addSymbolToAddressByNox(address.get(i));
            }
            this.addSymbolToAddressByNox((SymbolInterface)this.getSymbolType().getOrigin());
            this.addSymbolToAddressByNox((SymbolInterface)this.getSymbolType().getBRB());
            return true;
        }
        this.addressToDial = address;
        this.symbolsToDialCount = symbolCount;
        this.addressPosition = -1;
        this.targetRingSymbol = SymbolUniverseEnum.G1;
        this.stargateState = EnumStargateState.DIALING;
        JSGSoundHelper.playSoundEvent(this.world, this.getGateCenterPos(), SoundEventEnum.GATE_UNIVERSE_DIAL_START);
        this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.LIGHT_UP_CHEVRONS, 9, true);
        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_DIAL_NEXT, 35, null));
        this.ringSpinContext = null;
        this.spinDirection = EnumSpinDirection.CLOCKWISE;
        this.setCoolDown();
        this.m_6596_();
        if (this.isFastDialing) {
            this.updateBearing(true);
        }
        return true;
    }

    public SymbolInterface getNextSymbol(boolean addOne) {
        ++this.addressPosition;
        int pos = this.addressPosition--;
        if (!addOne) {
            // empty if block
        }
        this.m_6596_();
        if (this.addressToDial == null) {
            return null;
        }
        if (pos >= this.addressToDial.getSize() + 1) {
            return this.getSymbolType().getTopSymbol();
        }
        if (pos >= this.symbolsToDialCount && addOne) {
            return this.getSymbolType().getOrigin();
        }
        if (pos >= this.symbolsToDialCount) {
            return null;
        }
        if (pos >= this.addressToDial.getSize()) {
            return null;
        }
        return this.addressToDial.get(pos);
    }

    @Override
    public boolean abortDialingSequence() {
        if (this.stargateState.incoming()) {
            return false;
        }
        if (this.isIncoming) {
            return false;
        }
        if (this.canContinue() && (this.stargateState.dialingComputer() || this.stargateState.idle() || this.stargateState.dialing())) {
            this.abortingDialing = true;
            this.currentRingSymbol = this.targetRingSymbol;
            this.m_6596_();
            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_RESET, 60, null));
            this.spinStartTime = -1L;
            this.isSpinning = false;
            this.sendState(StateTypeEnum.SPIN_STATE, new StargateSpinState(this.targetRingSymbol, this.spinDirection, true, 0));
            this.addFailedTaskAndPlaySound();
            this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
            if (this.lastSpinFinished != null && this.scheduledTasks.contains(this.lastSpinFinished)) {
                this.removeTask(this.lastSpinFinished);
            }
            if (!this.isIncoming) {
                this.disconnectGate();
            }
            this.stargateState = EnumStargateState.FAILING;
            this.setCoolDown();
            this.m_6596_();
            this.resetTargetIncomingAnimation();
            return true;
        }
        return false;
    }

    @Override
    public void failGate() {
        if (this.stargateState.incoming()) {
            return;
        }
        this.isIncoming = false;
        this.m_6596_();
        if (this.abortingDialing) {
            this.isFinalActive = false;
            this.m_6596_();
            return;
        }
        super.failGate();
        this.addressToDial = null;
        this.updateBearing(false);
        if (!this.abortingDialing && this.targetRingSymbol != SymbolUniverseEnum.TOP_CHEVRON) {
            this.addSymbolToAddressManual(SymbolUniverseEnum.TOP_CHEVRON, null);
        }
    }

    @Override
    public void dialingFailed(StargateOpenResult reason) {
        this.playPositionedSound(StargateSoundPositionedEnum.GATE_RING_ROLL, false);
        super.dialingFailed(reason);
    }

    @Override
    public void generateMergeHelper() {
        this.mergeHelper = new StargateUniverseMergeHelper(this);
        this.mergeHelper.horizontalFacing = (Direction)this.getCurrentBlockState().m_61143_((Property)JSGProperties.FACING_HORIZONTAL_PROPERTY);
        this.mergeHelper.verticalFacing = JSGProperties.getDirectionByVerticalFacing((Integer)this.getCurrentBlockState().m_61143_((Property)JSGProperties.FACING_VERTICAL_PROPERTY));
        this.mergeHelper.stargateSize = this.getStargateSize();
        this.mergeHelper.basePos = this.m_58899_();
    }

    @Override
    protected void disconnectGate() {
        this.isIncoming = false;
        this.m_6596_();
        super.disconnectGate();
        this.addressToDial = null;
        this.updateBearing(false);
        if (!this.abortingDialing) {
            this.addSymbolToAddressManual(SymbolUniverseEnum.TOP_CHEVRON, null);
        }
    }

    @Override
    public void addSymbolToAddressManual(SymbolInterface targetSymbol, Object context) {
        if (this.stargateState.incoming()) {
            return;
        }
        this.updateBearing(false);
        if (targetSymbol != this.getSymbolType().getTopSymbol()) {
            this.stargateState = context != null ? EnumStargateState.DIALING_COMPUTER : EnumStargateState.DIALING;
        }
        if (this.dialedAddress.size() == 0 && targetSymbol != SymbolUniverseEnum.TOP_CHEVRON && this.stargateState.dialingComputer()) {
            JSGSoundHelper.playSoundEvent(this.world, this.getGateCenterPos(), SoundEventEnum.GATE_UNIVERSE_DIAL_START);
            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.LIGHT_UP_CHEVRONS, 9, true);
            this.targetRingSymbol = targetSymbol;
            this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_DIAL_NEXT, 35, null));
            this.ringSpinContext = context;
            this.spinDirection = EnumSpinDirection.CLOCKWISE;
        } else {
            super.addSymbolToAddressManual(targetSymbol, context);
        }
        if (targetSymbol == this.getSymbolType().getTopSymbol()) {
            this.stargateState = EnumStargateState.FAILING;
        }
        this.m_6596_();
    }

    @Override
    public EnergyRequiredToOperate getEnergyRequiredToDial(StargatePos targetGatePos) {
        if (this.dialingWithoutEnergy) {
            return EnergyRequiredToOperate.free();
        }
        BlockPos sPos = this.getFakePos();
        BlockPos tPos = targetGatePos.gatePos;
        ResourceKey<Level> sourceDim = this.getFakeWorld();
        ResourceKey<Level> targetDim = targetGatePos.getWorld().m_46472_();
        StargateAbstractBaseBE targetTile = targetGatePos.getBlockEntity();
        if (targetTile instanceof StargateUniverseBaseBE) {
            tPos = ((StargateUniverseBaseBE)targetTile).getFakePos();
            targetDim = ((StargateUniverseBaseBE)targetTile).getFakeWorld();
        }
        if (sourceDim == Level.f_46428_ && targetDim == Level.f_46429_) {
            tPos = new BlockPos(tPos.m_123341_() * 8, tPos.m_123342_(), tPos.m_123343_() * 8);
        } else if (sourceDim == Level.f_46429_ && targetDim == Level.f_46428_) {
            sPos = new BlockPos(sPos.m_123341_() * 8, sPos.m_123342_(), sPos.m_123343_() * 8);
        }
        double distance = (int)BlockPosHelper.dist((Vec3i)sPos, tPos.m_123341_(), tPos.m_123342_(), tPos.m_123343_());
        distance = distance < 5000.0 ? (distance *= 0.8) : 5000.0 * Math.log10(distance) / Math.log10(5000.0);
        EnergyRequiredToOperate energyRequired = EnergyRequiredToOperate.stargate();
        energyRequired = energyRequired.mul(distance).add(StargateDimensionConfig.INSTANCE.getCost(sourceDim, targetDim));
        if (this.dialedAddress.size() == 9) {
            energyRequired.mul((Double)JSGConfig.Stargate.nineSymbolAddressMul.get());
        }
        if (this.dialedAddress.size() == 8) {
            energyRequired.mul((Double)JSGConfig.Stargate.eightSymbolAddressMul.get());
        }
        return energyRequired.mul((Double)JSGConfig.Stargate.stargateUniverseEnergyMul.get());
    }

    @Override
    public SymbolTypeEnum<?> getSymbolType() {
        return SymbolTypeRegistry.UNIVERSE;
    }

    @Override
    public StargateTypeEnum getStargateType() {
        return StargateTypeEnum.UNIVERSE;
    }

    @Override
    protected int getMaxChevrons() {
        return 9;
    }

    @Override
    public int getOpenSoundDelay() {
        return super.getOpenSoundDelay() + 10;
    }

    private void activateSymbolServer(SymbolInterface symbol) {
        if (!(symbol instanceof SymbolUniverseEnum)) {
            JSG.logger.error("Error while engaging symbol {} for clients.", (Object)symbol.getEnglishName(), (Object)new ClassCastException());
            return;
        }
        JSGPacketHandler.sendToClient(new StateUpdatePacketToClient(this.pos, StateTypeEnum.STARGATE_UNIVERSE_ACTIVATE_SYMBOL, new StargateUniverseSymbolState((SymbolUniverseEnum)symbol, false)), this.targetPoint);
    }

    public void updateBearing(boolean activate) {
    }

    public void updateFloorChevron() {
    }

    @Override
    public void openGate(StargatePos targetGatePos, boolean isInitiating, boolean noxDialing) {
        super.openGate(targetGatePos, isInitiating, noxDialing);
        this.wasStargateActivated = true;
        this.m_6596_();
    }

    public void animateVents() {
    }

    @Override
    protected void addSymbolToAddress(SymbolInterface symbol) {
        this.updateBearing(true);
        this.activateSymbolServer(symbol);
        super.addSymbolToAddress(symbol);
    }

    @Override
    public void executeTask(EnumScheduledTask scheduledTask, CompoundTag customData) {
        boolean onlySpin = false;
        if (customData != null && customData.m_128441_("onlySpin")) {
            onlySpin = customData.m_128471_("onlySpin");
        }
        switch (scheduledTask) {
            case LIGHT_UP_CHEVRONS: {
                this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.LIGHT_UP_CHEVRONS, 9, true);
                break;
            }
            case STARGATE_DIAL_NEXT: {
                this.updateBearing(false);
                if (this.stargateState.incoming() || this.abortingDialing || this.stargateState.failing()) break;
                if (this.isFastDialing && this.stargateState.dialingDHD()) {
                    SymbolInterface tempSymbol;
                    if (this.dialedAddress.size() == 0) {
                        this.spinRing(1, false, true, 30 * this.symbolsToDialCount + 100);
                    }
                    if (!this.canAddSymbol(tempSymbol = this.getNextSymbol(true)) || tempSymbol == SymbolUniverseEnum.TOP_CHEVRON) break;
                    this.addSymbolToAddress(tempSymbol);
                    this.playSoundEvent(StargateSoundEventEnum.CHEVRON_SHUT);
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_DIAL_FINISHED, 10));
                    this.sendSignal("stargate_spin_chevron_engaged", new Object[]{this.dialedAddress.size(), this.stargateWillLock(this.targetRingSymbol), this.targetRingSymbol.getEnglishName()});
                    this.doIncomingAnimation(60, true, this.getNextSymbol(false));
                    if (this.stargateWillLock(tempSymbol)) break;
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_DIAL_NEXT, 30));
                    break;
                }
                if (this.stargateState.dialingComputer() && this.targetRingSymbol != this.getSymbolType().getTopSymbol()) {
                    super.addSymbolToAddressManual(this.targetRingSymbol, this.ringSpinContext);
                    break;
                }
                if (this.targetRingSymbol == this.getSymbolType().getTopSymbol()) break;
                this.targetRingSymbol = this.getNextSymbol(true);
                this.m_6596_();
                if (this.targetRingSymbol == SymbolUniverseEnum.TOP_CHEVRON) {
                    this.abortDialingSequence();
                    break;
                }
                this.addSymbolToAddressManual(this.targetRingSymbol, null);
                break;
            }
            case STARGATE_RESET: {
                if (this.stargateState.incoming()) break;
                this.updateBearing(false);
                this.addSymbolToAddressManual((SymbolInterface)this.getSymbolType().getTopSymbol(), null);
                this.abortingDialing = false;
                break;
            }
            case STARGATE_SPIN_FINISHED: {
                if (onlySpin && this.stargateState.dialingComputer()) {
                    this.stargateState = EnumStargateState.IDLE;
                    this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, 9, true);
                    this.m_6596_();
                    break;
                }
                if (onlySpin && this.stargateState.dialing() && this.isFastDialing) {
                    this.attemptOpenAndFail();
                    break;
                }
                if (onlySpin || this.stargateState.incoming()) break;
                if (this.targetRingSymbol != SymbolUniverseEnum.TOP_CHEVRON) {
                    this.playSoundEvent(StargateSoundEventEnum.CHEVRON_SHUT);
                    this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_DIAL_FINISHED, 10));
                } else {
                    this.updateBearing(false);
                    this.animateVents();
                    this.dialingFailed(StargateOpenResult.ABORTED);
                    this.stargateState = EnumStargateState.IDLE;
                    this.abortingDialing = false;
                }
                this.m_6596_();
                break;
            }
            case BEGIN_SPIN: {
                if (customData == null || !customData.m_128441_("period")) break;
                int period = customData.m_128451_("period");
                this.spinRing(1, false, true, period);
                break;
            }
            case STARGATE_FAILED_SOUND: {
                this.playSoundEvent(StargateSoundEventEnum.DIAL_FAILED);
                this.m_6596_();
                break;
            }
            case STARGATE_DIAL_FINISHED: {
                if (this.abortingDialing) {
                    return;
                }
                if (this.canAddSymbol(this.targetRingSymbol)) {
                    this.addSymbolToAddress(this.targetRingSymbol);
                    if (this.stargateState.dialingComputer()) {
                        if (this.abortingDialing) break;
                        this.stargateState = EnumStargateState.IDLE;
                        break;
                    }
                    if (!this.stargateWillLock(this.targetRingSymbol)) {
                        this.addTask(new ScheduledTask(EnumScheduledTask.STARGATE_DIAL_NEXT, 24));
                        break;
                    }
                    this.attemptOpenAndFail();
                    break;
                }
                if (this.stargateState.incoming()) break;
                this.dialingFailed(StargateOpenResult.ADDRESS_MALFORMED);
                this.stargateState = EnumStargateState.IDLE;
                break;
            }
        }
        this.m_6596_();
        super.executeTask(scheduledTask, customData);
    }

    @Override
    public State createState(StateTypeEnum stateType) {
        if (stateType == StateTypeEnum.STARGATE_UNIVERSE_ACTIVATE_SYMBOL) {
            return new StargateUniverseSymbolState();
        }
        return super.createState(stateType);
    }

    @Override
    public void setState(StateTypeEnum stateType, State state) {
        if (this.getRendererStateClient() != null) {
            switch (stateType) {
                case STARGATE_UNIVERSE_ACTIVATE_SYMBOL: {
                    StargateUniverseSymbolState symbolState = (StargateUniverseSymbolState)state;
                    if (symbolState.dimAll) {
                        this.getRendererStateClient().clearSymbols(this.world.m_46467_());
                        break;
                    }
                    this.getRendererStateClient().activateSymbol(this.world.m_46467_(), symbolState.symbol);
                    break;
                }
                case RENDERER_UPDATE: {
                    StargateRendererActionState gateActionState = (StargateRendererActionState)state;
                    if (gateActionState.action != StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS) break;
                    this.getRendererStateClient().clearSymbols(this.world.m_46467_());
                    break;
                }
            }
        }
        super.setState(stateType, state);
    }

    @Override
    public void incomingWormhole(int dialedAddressSize) {
        this.startIncomingAnimation(dialedAddressSize, 10);
        super.incomingWormhole(9);
    }

    @Override
    public void incomingWormhole(int dialedAddressSize, int time) {
        int period = (time *= dialedAddressSize) - 2000;
        if (period < 0) {
            period = 0;
        }
        this.startIncomingAnimation(dialedAddressSize, period);
        super.incomingWormhole(9, false);
    }

    @Override
    public void startIncomingAnimation(int addressSize, int period) {
        double ticks = (double)(period * 20) / 1000.0;
        this.incomingPeriod = (int)Math.round(ticks);
        this.incomingAddressSize = addressSize;
        this.incomingLastChevronLightUp = 0;
        this.stargateState = EnumStargateState.INCOMING;
        this.isIncoming = true;
        this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.CLEAR_CHEVRONS, 9, true);
        if (this.stargateState.dialing()) {
            this.abortDialingSequence();
        }
        this.m_6596_();
        this.updateBearing(true);
        this.lightUpChevronByIncoming(!this.isIncomingAnimationAllowed(false));
    }

    @Override
    protected void lightUpChevronByIncoming(boolean disableAnimation) {
        super.lightUpChevronByIncoming(disableAnimation);
        if (this.incomingPeriod == -1) {
            return;
        }
        boolean spin = this.isIncomingAnimationAllowed(true);
        if (!disableAnimation && this.incomingLastChevronLightUp == 1) {
            this.stargateState = EnumStargateState.INCOMING;
            CompoundTag compound = new CompoundTag();
            int time = this.incomingPeriod - 15;
            compound.m_128405_("period", time);
            if (spin && time > 25) {
                this.addTask(new ScheduledTask(EnumScheduledTask.BEGIN_SPIN, 15, compound));
            }
            this.addTask(new ScheduledTask(EnumScheduledTask.LIGHT_UP_CHEVRONS, 8));
            this.sendSignal("stargate_incoming_wormhole", new Object[]{this.incomingAddressSize});
            this.playSoundEvent(StargateSoundEventEnum.INCOMING);
            super.resetIncomingAnimation();
            this.isIncoming = false;
            if (this.irisMode == EnumIrisMode.AUTO && this.isIrisOpened()) {
                this.toggleIris();
            }
        } else if (this.incomingLastChevronLightUp == 2 && disableAnimation) {
            this.stargateState = EnumStargateState.INCOMING;
            this.sendRenderingUpdate(StargateRendererActionState.EnumGateAction.LIGHT_UP_CHEVRONS, 9, true);
            this.sendSignal("stargate_incoming_wormhole", new Object[]{this.incomingAddressSize});
            this.playSoundEvent(StargateSoundEventEnum.INCOMING);
            super.resetIncomingAnimation();
            this.isIncoming = false;
            if (this.irisMode == EnumIrisMode.AUTO && this.isIrisOpened()) {
                this.toggleIris();
            }
        } else if (this.isIncoming && !this.stargateState.engaged()) {
            this.stargateState = EnumStargateState.INCOMING;
        }
        this.m_6596_();
    }

    @Override
    public EnumSet<BiomeOverlayEnum> getSupportedOverlays() {
        return SUPPORTED_OVERLAYS;
    }

    @Override
    @Nullable
    protected SoundPositionedEnum getPositionedSound(StargateSoundPositionedEnum soundEnum) {
        return switch (soundEnum) {
            default -> throw new IncompatibleClassChangeError();
            case StargateSoundPositionedEnum.GATE_RING_ROLL -> SoundPositionedEnum.UNIVERSE_RING_ROLL;
            case StargateSoundPositionedEnum.GATE_RING_ROLL_START -> SoundPositionedEnum.UNIVERSE_RING_ROLL_START;
        };
    }

    @Override
    @Nullable
    protected SoundEventEnum getSoundEvent(StargateSoundEventEnum soundEnum) {
        return switch (soundEnum) {
            case StargateSoundEventEnum.OPEN -> SoundEventEnum.GATE_UNIVERSE_OPEN;
            case StargateSoundEventEnum.OPEN_NOX -> SoundEventEnum.GATE_NOX_OPEN;
            case StargateSoundEventEnum.CLOSE -> SoundEventEnum.GATE_UNIVERSE_CLOSE;
            case StargateSoundEventEnum.DIAL_FAILED -> SoundEventEnum.GATE_UNIVERSE_DIAL_FAILED;
            case StargateSoundEventEnum.INCOMING -> SoundEventEnum.GATE_UNIVERSE_DIAL_START;
            case StargateSoundEventEnum.CHEVRON_SHUT -> {
                if (this.targetRingSymbol == SymbolUniverseEnum.TOP_CHEVRON) {
                    yield SoundEventEnum.GATE_UNIVERSE_CHEVRON_TOP_LOCK;
                }
                yield SoundEventEnum.GATE_UNIVERSE_CHEVRON_LOCK;
            }
            default -> null;
        };
    }

    @Override
    protected StargateClassicRendererState.StargateClassicRendererStateBuilder getRendererStateServer() {
        return new StargateUniverseRendererState.StargateUniverseRendererStateBuilder(super.getRendererStateServer()).setDialedAddress(this.stargateState.initiating() || this.stargateState.dialing() ? this.dialedAddress : new StargateAddressDynamic(this.getSymbolType())).setActiveChevrons(this.stargateState.idle() ? 0 : 9).setStargateSize(this.stargateSize);
    }

    @Override
    protected StargateUniverseRendererState createRendererStateClient() {
        return new StargateUniverseRendererState();
    }

    @Override
    public StargateUniverseRendererState getRendererStateClient() {
        return (StargateUniverseRendererState)super.getRendererStateClient();
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag compound) {
        if (this.addressToDial != null) {
            compound.m_128365_("addressToDial", (Tag)this.addressToDial.serializeNBT());
        }
        compound.m_128405_("symbolsToDialCount", this.symbolsToDialCount);
        compound.m_128405_("addressPosition", this.addressPosition);
        compound.m_128405_("coolDown", this.coolDown);
        compound.m_128379_("abortingDialing", this.abortingDialing);
        compound.m_128379_("wasStargateActivated", this.wasStargateActivated);
        if (this.fakePos != null) {
            compound.m_128405_("fakeX", this.fakePos.m_123341_());
            compound.m_128405_("fakeY", this.fakePos.m_123342_());
            compound.m_128405_("fakeZ", this.fakePos.m_123342_());
        }
        if (this.fakeWorld != null) {
            compound.m_128359_("fakeWorld", this.fakeWorld.m_135782_().toString());
        }
        super.m_183515_(compound);
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        this.addressToDial = new StargateAddress(compound.m_128469_("addressToDial"));
        this.addressPosition = compound.m_128451_("addressPosition");
        this.symbolsToDialCount = compound.m_128451_("symbolsToDialCount");
        this.coolDown = compound.m_128451_("coolDown");
        this.abortingDialing = compound.m_128471_("abortingDialing");
        this.wasStargateActivated = compound.m_128471_("wasStargateActivated");
        if (compound.m_128441_("fakeX")) {
            this.fakePos = new BlockPos(compound.m_128451_("fakeX"), compound.m_128451_("fakeY"), compound.m_128451_("fakeZ"));
        }
        if (compound.m_128441_("fakeWorld") && this.world.m_7654_() != null) {
            this.fakeWorld = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(compound.m_128461_("fakeWorld")));
        }
    }

    public NearbyGate getRandomNearbyGate() {
        ArrayList<NearbyGate> addresses = this.getNearbyGates();
        if (addresses.isEmpty()) {
            return null;
        }
        int i = (int)Math.min(Math.floor(Math.random() * (double)addresses.size()), (double)(addresses.size() - 1));
        if (i < 0) {
            i = 0;
        }
        return addresses.get(i);
    }
}

