/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.blockentity.util;

import dev.tauri.jsg.util.EnumKeyInterface;
import java.util.Iterator;
import java.util.stream.IntStream;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public interface IUpgradable {
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> var1, Direction var2);

    default public IItemHandler getItemHandler() {
        return (IItemHandler)this.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElse(null);
    }

    default public boolean hasUpgrade(EnumKeyInterface<Item> upgrade) {
        return this.hasUpgrade(upgrade.getKey());
    }

    default public boolean hasUpgrade(Item item) {
        IItemHandler itemHandler = this.getItemHandler();
        Iterator<Integer> iter = this.getUpgradeSlotsIterator();
        while (iter.hasNext()) {
            int slot = iter.next();
            if (itemHandler.getStackInSlot(slot).m_41720_() != item) continue;
            return true;
        }
        return false;
    }

    default public Iterator<Integer> getUpgradeSlotsIterator() {
        return IntStream.range(0, this.getItemHandler().getSlots()).iterator();
    }

    default public boolean tryInsertUpgrade(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_()) {
            return false;
        }
        IItemHandler itemHandler = this.getItemHandler();
        Iterator<Integer> iterator = this.getUpgradeSlotsIterator();
        while (iterator.hasNext()) {
            int slot = iterator.next();
            if (!itemHandler.getStackInSlot(slot).m_41619_() || !itemHandler.isItemValid(slot, stack)) continue;
            player.m_21008_(hand, itemHandler.insertItem(slot, stack, false));
            return true;
        }
        return false;
    }
}

