/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.command.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.tauri.jsg.api.StargateGenerator;
import dev.tauri.jsg.command.JSGAbstractCommand;
import dev.tauri.jsg.command.JSGCommand;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.config.ingame.JSGIntRangeConfigOption;
import dev.tauri.jsg.config.util.JSGConfigUtil;
import dev.tauri.jsg.helpers.BlockPosHelper;
import dev.tauri.jsg.helpers.RayTraceHelper;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import dev.tauri.jsg.stargate.StargateTypeEnum;
import dev.tauri.jsg.worldgen.GeneratedStargate;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class CommandBuildGate
extends JSGAbstractCommand {
    public CommandBuildGate() {
        super(JSGCommand.JSG_COMMAND_BASE);
    }

    @Override
    public String getName() {
        return "buildgate";
    }

    @Override
    public String getGeneralUsage() {
        return "buildgate <MILKYWAY|PEGASUS|UNIVERSE|TOLLAN|MOVIE|?>";
    }

    @Override
    public String getDescription() {
        return "Builds gate at place you are looking at.";
    }

    @Override
    @ParametersAreNonnullByDefault
    public ArgumentBuilder<CommandSourceStack, ?> registerArguments(ArgumentBuilder<CommandSourceStack, ?> command) {
        return command.then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (StargateTypeEnum type : StargateTypeEnum.values()) {
                if (type == StargateTypeEnum.ORLIN || !Objects.equals(builder.getRemainingLowerCase(), "") && !type.name.toLowerCase().startsWith(builder.getRemainingLowerCase())) continue;
                builder.suggest(type.name);
            }
            return builder.buildFuture();
        }).executes(ctx -> {
            String type = StringArgumentType.getString((CommandContext)ctx, (String)"type");
            StargateTypeEnum typeEnum = StargateTypeEnum.valueOf(type);
            if (typeEnum == null || typeEnum == StargateTypeEnum.ORLIN) {
                this.baseCommand.sendErrorMess((CommandSourceStack)ctx.getSource(), "Specify correct gate type!", new Object[0]);
                return 0;
            }
            ServerPlayer sender = ((CommandSourceStack)ctx.getSource()).m_230896_();
            if (sender == null) {
                this.baseCommand.sendErrorMess((CommandSourceStack)ctx.getSource(), "This command can only be run by a player!", new Object[0]);
                return 0;
            }
            BlockPos pos = BlockPosHelper.getPos(sender.m_20182_());
            BlockPos target = RayTraceHelper.rayTracePos((Player)sender, 10);
            if (target != null) {
                pos = target.m_7495_();
            }
            StargateGenerator.PlacementConfig genCfg = new StargateGenerator.PlacementConfig();
            Direction direction = sender.m_6350_().m_122424_();
            ItemStack item = sender.m_21205_();
            BiomeOverlayEnum overlay = JSGConfigUtil.getBiomeOverrideItemMetaPairs().get(Block.m_49814_((Item)item.m_41720_()));
            if (overlay != null) {
                genCfg.overlay = overlay;
            }
            Level world = sender.m_9236_();
            genCfg.gateBasePos = pos;
            genCfg.gateFacing = direction;
            genCfg.world = world;
            genCfg.gateType = typeEnum;
            genCfg.setStargateEnergyInternalSmart((Integer)JSGConfig.Stargate.stargateEnergyStorage.get());
            genCfg.stargateConfig = config -> {
                ((JSGIntRangeConfigOption)config.getOption("maxCapacitors")).setValue(genCfg.capacitors.size());
                return config;
            };
            genCfg.upgrades.add(StargateGenerator.StargateUpgradesEnum.GLYPH_CRYSTAL_MW);
            genCfg.upgrades.add(StargateGenerator.StargateUpgradesEnum.GLYPH_CRYSTAL_PEG);
            genCfg.upgrades.add(StargateGenerator.StargateUpgradesEnum.GLYPH_CRYSTAL_UNI);
            genCfg.upgrades.add(StargateGenerator.StargateUpgradesEnum.UPGRADE_IRIS_CREATIVE);
            genCfg.upgrades.add(StargateGenerator.StargateUpgradesEnum.GLYPH_CRYSTAL_STARGATE);
            GeneratedStargate result = StargateGenerator.generateStargate(genCfg);
            if (result == null) {
                this.baseCommand.sendErrorMess((CommandSourceStack)ctx.getSource(), "Error while generating stargate!", new Object[0]);
                return 0;
            }
            this.baseCommand.sendSuccessMess((CommandSourceStack)ctx.getSource(), "Stargate generated successfully!", new Object[0]);
            return 1;
        })).executes(ctx -> {
            this.baseCommand.sendErrorMess((CommandSourceStack)ctx.getSource(), "You need to specify gate type!", new Object[0]);
            return 0;
        });
    }
}

