/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.config.ingame;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.config.ingame.JSGConfigOption;
import dev.tauri.jsg.screen.element.EnumButton;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class JSGEnumConfigOption<T>
extends JSGConfigOption<T> {
    public final List<T> allowedValues;

    public JSGEnumConfigOption(String label, List<T> allowedValues, T defaultValue, T value, String ... comment) {
        super(label, defaultValue, value, comment);
        this.allowedValues = allowedValues;
    }

    public JSGEnumConfigOption(String label, List<T> allowedValues, T defaultValue, String ... comment) {
        this(label, allowedValues, defaultValue, defaultValue, comment);
    }

    public JSGEnumConfigOption(String label, List<T> allowedValues, int defaultValueIndex, String ... comment) {
        this(label, allowedValues, allowedValues.get(defaultValueIndex), comment);
    }

    public JSGEnumConfigOption(String label, List<T> allowedValues, String ... comment) {
        this(label, allowedValues, 0, comment);
    }

    public JSGEnumConfigOption(String label, T[] allowedValues, T defaultValue, T value, String ... comment) {
        this(label, Arrays.asList(allowedValues), defaultValue, value, comment);
    }

    public JSGEnumConfigOption(String label, T[] allowedValues, T defaultValue, String ... comment) {
        this(label, allowedValues, defaultValue, defaultValue, comment);
    }

    public JSGEnumConfigOption(String label, T[] allowedValues, int defaultValueIndex, String ... comment) {
        this(label, allowedValues, allowedValues[defaultValueIndex], comment);
    }

    public JSGEnumConfigOption(String label, T[] allowedValues, String ... comment) {
        this(label, allowedValues, 0, comment);
    }

    @Override
    public boolean setValue(String value) {
        return this.allowedValues.parallelStream().filter(av -> av.toString().equals(value)).reduce((a, b) -> {
            throw null;
        }).map(x$0 -> super.setValue(x$0)).orElseGet(() -> {
            JSG.logger.warn("\"%s\" is not an allowed value for %s".formatted(value, this.label));
            return false;
        });
    }

    @Override
    public boolean setValue(T newValue) {
        if (this.allowedValues.parallelStream().noneMatch(av -> av.equals(newValue))) {
            JSG.logger.warn("\"%s\" is not an allowed value for %s".formatted(this.value, this.label));
            return false;
        }
        return super.setValue(newValue);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AbstractWidget createGUIComponent(int y, int id) {
        EnumButton<T> button = new EnumButton<T>(id, -25, y, this.allowedValues);
        return button;
    }
}

