/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.config.stargate;

import com.google.common.reflect.TypeToken;
import dev.tauri.jsg.JSG;
import dev.tauri.jsg.config.AbstractJSONConfig;
import dev.tauri.jsg.config.stargate.StargateDimensionConfigEntry;
import dev.tauri.jsg.power.general.EnergyRequiredToOperate;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import dev.tauri.jsg.worldgen.CustomDimensionsEnum;
import it.unimi.dsi.fastutil.Pair;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;

public class StargateDimensionConfig
extends AbstractJSONConfig<StargateDimensionConfigEntry> {
    private static final Map<String, StargateDimensionConfigEntry> DEFAULTS_MAP = new HashMap<String, StargateDimensionConfigEntry>();
    public static final StargateDimensionConfig INSTANCE;

    public StargateDimensionConfig() {
        super("jsgDimensions_2.0", DEFAULTS_MAP.values());
    }

    @Override
    public Type getJSONType() {
        return new TypeToken<Map<String, StargateDimensionConfigEntry>>(){}.getType();
    }

    protected Pair<StargateDimensionConfigEntry, StargateDimensionConfigEntry> getPairedEntries(ResourceLocation fromDimId, ResourceLocation toDimId) {
        StargateDimensionConfigEntry eFrom = (StargateDimensionConfigEntry)this.configEntries.get(fromDimId.toString());
        StargateDimensionConfigEntry eTo = (StargateDimensionConfigEntry)this.configEntries.get(toDimId.toString());
        if (eFrom == null || eTo == null) {
            JSG.logger.error("Tried to get non-existing dimension. This is a bug.");
            JSG.logger.error("FromId: {}, ToId: {}, FromEntryNull: {}, ToEntryNull: {}", new Object[]{fromDimId, toDimId, eFrom == null, eTo == null});
            JSG.logger.error("JSG dimension entries:{}{}", (Object)System.lineSeparator(), (Object)this.configEntries.entrySet().stream().map(en -> (String)en.getKey() + " | " + ((StargateDimensionConfigEntry)en.getValue()).toString()).collect(Collectors.joining(System.lineSeparator())));
            JSG.logger.error("Stack trace:", (Throwable)new IllegalArgumentException());
            return null;
        }
        return Pair.of((Object)eFrom, (Object)eTo);
    }

    public EnergyRequiredToOperate getCost(ResourceKey<Level> fromDimId, ResourceKey<Level> toDimId) {
        Pair<StargateDimensionConfigEntry, StargateDimensionConfigEntry> fromTo = this.getPairedEntries(fromDimId.m_135782_(), toDimId.m_135782_());
        if (fromTo == null) {
            return EnergyRequiredToOperate.free();
        }
        EnergyRequiredToOperate energyRequired = EnergyRequiredToOperate.stargate();
        double dist = Math.abs(((StargateDimensionConfigEntry)fromTo.first()).distance - ((StargateDimensionConfigEntry)fromTo.second()).distance);
        return energyRequired.mul(dist);
    }

    public boolean isGroupEqual(ResourceKey<Level> fromDim, ResourceKey<Level> toDim) {
        return this.isGroupEqual(fromDim.m_135782_(), toDim.m_135782_());
    }

    public boolean isGroupEqual(ResourceLocation fromDimId, ResourceLocation toDimId) {
        Pair<StargateDimensionConfigEntry, StargateDimensionConfigEntry> fromTo = this.getPairedEntries(fromDimId, toDimId);
        if (fromTo == null) {
            return false;
        }
        return ((StargateDimensionConfigEntry)fromTo.first()).isGroupEqual((StargateDimensionConfigEntry)fromTo.second());
    }

    @Nullable
    public StargateDimensionConfigEntry getConfigEntry(ResourceKey<Level> dim) {
        if (dim == null) {
            return null;
        }
        if (this.configEntries.isEmpty()) {
            try {
                this.reload(null);
            }
            catch (Exception ignored) {
                return null;
            }
        }
        if (this.configEntries.isEmpty()) {
            return null;
        }
        return (StargateDimensionConfigEntry)this.getConfigEntry(dim.m_135782_().toString());
    }

    public int getOrigin(ResourceKey<Level> dim, @Nullable BiomeOverlayEnum overlay) {
        StargateDimensionConfigEntry entry;
        if (overlay == null) {
            overlay = BiomeOverlayEnum.NORMAL;
        }
        if ((entry = this.getConfigEntry(dim)) == null) {
            return -1;
        }
        if (!entry.milkyWayOrigins.containsKey(overlay)) {
            return -1;
        }
        return entry.milkyWayOrigins.get(overlay);
    }

    @Override
    protected void update(@Nullable MinecraftServer server) throws IOException {
        if (server != null) {
            for (ResourceKey location : server.m_129784_()) {
                if (this.configEntries.containsKey(location.m_135782_().toString())) continue;
                this.shouldWriteToFile = true;
                String name = location.m_135782_().toString();
                if (DEFAULTS_MAP.containsKey(name)) {
                    this.configEntries.put(location.m_135782_().toString(), DEFAULTS_MAP.get(name));
                    continue;
                }
                this.configEntries.put(location.m_135782_().toString(), new StargateDimensionConfigEntry(name, (int)(5.0 + 10.0 * Math.random()), null));
            }
        }
        super.update(server);
    }

    static {
        DEFAULTS_MAP.put("minecraft:overworld", new StargateDimensionConfigEntry("minecraft:overworld", 0, new ArrayList<String>(){
            {
                this.add("milkyway");
            }
        }));
        DEFAULTS_MAP.put("minecraft:the_nether", new StargateDimensionConfigEntry("minecraft:the_nether", 5, new ArrayList<String>(){
            {
                this.add("milkyway");
            }
        }, (Map<BiomeOverlayEnum, Integer>)new HashMap<BiomeOverlayEnum, Integer>(){
            {
                this.put(BiomeOverlayEnum.NORMAL, 2);
            }
        }, 0.0, false));
        DEFAULTS_MAP.put("minecraft:the_end", new StargateDimensionConfigEntry("minecraft:the_end", 10, new ArrayList<String>(), (Map<BiomeOverlayEnum, Integer>)new HashMap<BiomeOverlayEnum, Integer>(){
            {
                this.put(BiomeOverlayEnum.NORMAL, 1);
            }
        }, 0.0, false));
        DEFAULTS_MAP.put(CustomDimensionsEnum.ABYDOS.location.toString(), new StargateDimensionConfigEntry(CustomDimensionsEnum.ABYDOS.location.toString(), 13, new ArrayList<String>(){
            {
                this.add("milkyway");
            }
        }, (Map<BiomeOverlayEnum, Integer>)new HashMap<BiomeOverlayEnum, Integer>(){
            {
                this.put(BiomeOverlayEnum.AGED, 4);
            }
        }, 2.0E-4f, false));
        DEFAULTS_MAP.put("ad_astra:moon", new StargateDimensionConfigEntry("ad_astra:moon", 3, new ArrayList<String>(){
            {
                this.add("milkyway");
            }
        }, (Map<BiomeOverlayEnum, Integer>)new HashMap<BiomeOverlayEnum, Integer>(){
            {
                this.put(BiomeOverlayEnum.NORMAL, 3);
            }
        }, 0.0, false));
        INSTANCE = new StargateDimensionConfig();
    }
}

