/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.helpers;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;

public class ItemHandlerHelper {
    private static final Random RANDOM = new Random();

    public static void dropInventoryItems(Level worldIn, BlockPos pos, IItemHandler inventory) {
        ItemHandlerHelper.dropInventoryItems(worldIn, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), inventory);
    }

    public static void dropInventoryItems(Level worldIn, Entity entityAt, IItemHandler inventory) {
        ItemHandlerHelper.dropInventoryItems(worldIn, entityAt.m_20185_(), entityAt.m_20186_(), entityAt.m_20189_(), inventory);
    }

    private static void dropInventoryItems(Level worldIn, double x, double y, double z, IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemstack = inventory.getStackInSlot(i);
            if (itemstack.m_41619_()) continue;
            ItemHandlerHelper.spawnItemStack(worldIn, x, y, z, itemstack);
        }
    }

    public static void clearInventory(IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemstack = inventory.getStackInSlot(i);
            if (itemstack.m_41619_()) continue;
            itemstack.m_41764_(0);
        }
    }

    public static void spawnItemStack(Level worldIn, BlockPos pos, ItemStack stack) {
        ItemHandlerHelper.spawnItemStack(worldIn, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), stack);
    }

    public static void spawnItemStack(Level worldIn, double x, double y, double z, ItemStack stack) {
        if (stack == null) {
            return;
        }
        float f = RANDOM.nextFloat() * 0.8f + 0.1f;
        float f1 = RANDOM.nextFloat() * 0.8f + 0.1f;
        float f2 = RANDOM.nextFloat() * 0.8f + 0.1f;
        while (!stack.m_41619_()) {
            ItemEntity entityitem = new ItemEntity(worldIn, x + (double)f, y + (double)f1, z + (double)f2, stack.m_41620_(RANDOM.nextInt(21) + 10));
            double motionX = RANDOM.nextGaussian() * (double)0.05f;
            double motionY = RANDOM.nextGaussian() * (double)0.05f + (double)0.2f;
            double motionZ = RANDOM.nextGaussian() * (double)0.05f;
            entityitem.m_20334_(motionX, motionY, motionZ);
            worldIn.m_7967_((Entity)entityitem);
        }
    }
}

