/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.integration.jei.category;

import dev.tauri.jsg.integration.jei.category.CauldronRecipeType;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCauldronRecipeCategory
implements IRecipeCategory<CauldronRecipeType> {
    public static final int width = 116;
    public static final int height = 54;
    protected final IDrawable background;
    protected final IDrawable icon;
    protected final Component localizedName;

    public AbstractCauldronRecipeCategory(IGuiHelper guiHelper, Component localizedName) {
        ResourceLocation location = new ResourceLocation("jsg", "textures/gui/jei/cauldron_recipe_container.png");
        this.background = guiHelper.createDrawable(location, 0, this.getVOffset(), 116, 54);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)Blocks.f_50256_));
        this.localizedName = localizedName;
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public ResourceLocation getRegistryName(CauldronRecipeType recipe) {
        return recipe.getId();
    }

    public abstract int getVOffset();

    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    @ParametersAreNonnullByDefault
    public void setRecipe(IRecipeLayoutBuilder builder, CauldronRecipeType recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 19, 1).addItemStack(recipe.getItem());
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 19, 35).addFluidStack(recipe.getFluid().getFluid(), 1000L)).setFluidRenderer(1000L, false, 16, 11);
        recipe.setResult(builder, recipe, focuses);
    }

    @ParametersAreNonnullByDefault
    public void draw(CauldronRecipeType recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
    }
}

