/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.item.linkable.dialer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.tauri.jsg.helpers.ItemRenderingHelper;
import dev.tauri.jsg.helpers.JSGMinecraftHelper;
import dev.tauri.jsg.item.linkable.HandHeldDeviceRenderer;
import dev.tauri.jsg.item.linkable.dialer.UniverseDialerMode;
import dev.tauri.jsg.loader.ElementEnum;
import dev.tauri.jsg.loader.model.OBJModel;
import dev.tauri.jsg.loader.texture.Texture;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import dev.tauri.jsg.stargate.EnumStargateState;
import dev.tauri.jsg.stargate.network.StargateAddress;
import dev.tauri.jsg.stargate.network.StargateAddressDynamic;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeRegistry;
import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class UniverseDialerBEWLR
extends BlockEntityWithoutLevelRenderer {
    private final ArrayList<Integer> switchStates = new ArrayList();

    public UniverseDialerBEWLR() {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
    }

    @ParametersAreNonnullByDefault
    public void m_108829_(ItemStack itemStack, ItemDisplayContext itemDisplayContext, PoseStack stack, MultiBufferSource bufferSource, int light, int overlay) {
        if (itemStack.m_41782_()) {
            OBJModel.source = bufferSource;
            HandHeldDeviceRenderer.currentStack = stack;
            HandHeldDeviceRenderer.source = bufferSource;
            HandHeldDeviceRenderer.light = light;
            stack.m_85836_();
            RenderSystem.enableDepthTest();
            if (itemDisplayContext == ItemDisplayContext.FIXED) {
                stack.m_85836_();
                stack.m_85837_(0.53, 0.5, 0.6);
                stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                stack.m_85841_(0.2f, 0.2f, 0.2f);
            } else {
                boolean mainHand = itemDisplayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || itemDisplayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                boolean thirdPerson = itemDisplayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || itemDisplayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                HumanoidArm handSide = mainHand ? HumanoidArm.RIGHT : HumanoidArm.LEFT;
                float partialTicks = Minecraft.m_91087_().getPartialTick();
                if (thirdPerson) {
                    stack.m_85836_();
                    stack.m_85841_(0.3f, 0.3f, 0.3f);
                    stack.m_85837_(2.0, 2.1, 3.0);
                    stack.m_252781_(Axis.f_252529_.m_252977_(-45.0f));
                    stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    stack.m_252781_(Axis.f_252403_.m_252977_(0.0f));
                    stack.m_252781_(Axis.f_252529_.m_252977_(50.0f));
                    stack.m_85837_(0.0, 1.5, 0.3);
                    stack.m_85841_(0.7f, 0.7f, 0.7f);
                } else {
                    HandHeldDeviceRenderer.renderArms(handSide, partialTicks);
                    stack.m_85836_();
                    ItemRenderingHelper.applyBobbing(stack, partialTicks);
                    stack.m_85841_(0.3f, 0.3f, 0.3f);
                    stack.m_85837_(2.0, 2.1, 3.0);
                    stack.m_252781_(Axis.f_252529_.m_252977_(-45.0f));
                    stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    stack.m_252781_(Axis.f_252403_.m_252977_(0.0f));
                }
            }
            CompoundTag compound = itemStack.m_41783_();
            if (compound != null) {
                long time;
                BiomeOverlayEnum biomeOverlay = BiomeOverlayEnum.NORMAL;
                if (compound.m_128441_("biomeOverlay")) {
                    biomeOverlay = BiomeOverlayEnum.values()[compound.m_128451_("biomeOverlay")];
                }
                ElementEnum.UNIVERSE_DIALER.bindTextureAndRender(biomeOverlay, stack);
                stack.m_85836_();
                UniverseDialerMode mode = UniverseDialerMode.valueOf(compound.m_128445_("mode"));
                boolean notLinked = mode.linkable && !compound.m_128441_(mode.tagPosName);
                boolean clocksDisabled = false;
                if (mode == UniverseDialerMode.COUNTDOWN && (time = compound.m_128454_("timerCountTo")) == -1L) {
                    clocksDisabled = true;
                }
                stack.m_252781_(Axis.f_252529_.m_252977_(85.0f));
                stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                stack.m_85837_(0.65, 0.0, 1.25);
                stack.m_85841_(1.0f, -1.0f, 1.0f);
                stack.m_85837_(-0.2, 0.8, -1.0);
                stack.m_85836_();
                RenderSystem.enableBlend();
                if (notLinked || clocksDisabled) {
                    stack.m_85836_();
                    stack.m_85837_(-1.2, -0.75, 0.0);
                    stack.m_85841_(1.0f, -1.0f, 1.0f);
                    stack.m_85836_();
                    stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                    RenderSystem.enableDepthTest();
                    Texture.bindTextureWithMc(new ResourceLocation("jsg", "textures/gui/universe_warning.png"));
                    if (notLinked && mode == UniverseDialerMode.COUNTDOWN) {
                        RenderSystem.setShaderColor((float)0.7f, (float)1.0f, (float)0.3f, (float)1.0f);
                    } else {
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    }
                    HandHeldDeviceRenderer.drawTexturedRect(0.0f, 0.0f, 0.0f, 0.24f, 0.24f);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    stack.m_85849_();
                    stack.m_85849_();
                }
                HandHeldDeviceRenderer.drawStringWithShadow(0.0f, 0.0f, mode.localize(), true, false);
                HandHeldDeviceRenderer.drawStringWithShadow(-0.7f, 0.0f, mode.next().localize(), false, false);
                if (!notLinked || mode == UniverseDialerMode.MEMORY || mode == UniverseDialerMode.COUNTDOWN) {
                    if (mode == UniverseDialerMode.GATE_INFO) {
                        EnumStargateState gateStatus = EnumStargateState.valueOf(compound.m_128451_("gateStatus"));
                        String[] opened = compound.m_128461_("gateOpenTime").split(" ");
                        String[] iris = compound.m_128461_("gateIrisState").split(" ");
                        String[] lastSymbol = compound.m_128461_("gateLastSymbol").replaceAll("Glyph ", "G").split(" ");
                        float top = -0.3f;
                        float row = 0.2f;
                        float x = -0.1f;
                        float second = -0.9f;
                        HandHeldDeviceRenderer.drawStringWithShadow(x, top - row * 0.0f, "State:", false, false);
                        HandHeldDeviceRenderer.drawStringWithShadow(x, top - row * 1.0f, "Wormhole:", false, false);
                        HandHeldDeviceRenderer.drawStringWithShadow(x, top - row * 2.0f, "Iris:", false, false);
                        HandHeldDeviceRenderer.drawStringWithShadow(x, top - row * 3.0f, "Last glyph:", false, false);
                        String[] state = gateStatus.toString().replaceAll("ENGAGED", "ENGAGED INCOMING").replaceAll("ENGAGED INCOMING_INITIATING", "ENGAGED OUTGOING").replaceAll("_", " ").split(" ");
                        if (this.switchStates.size() < 4) {
                            this.switchStates.clear();
                            for (int i = 0; i < 4; ++i) {
                                this.switchStates.add(0);
                            }
                        }
                        for (int u = 0; u < 4; ++u) {
                            int max = 0;
                            switch (u) {
                                default: {
                                    break;
                                }
                                case 0: {
                                    max = state.length;
                                    break;
                                }
                                case 1: {
                                    max = opened.length;
                                    break;
                                }
                                case 2: {
                                    max = iris.length;
                                    break;
                                }
                                case 3: {
                                    max = lastSymbol.length;
                                }
                            }
                            int current = (int)Math.floor((double)(JSGMinecraftHelper.getClientTick() % (long)(40 * max)) / 40.0);
                            this.switchStates.set(u, current);
                        }
                        if (state.length > this.switchStates.get(0)) {
                            HandHeldDeviceRenderer.drawStringWithShadow(x + second, top - row * 0.0f, state[this.switchStates.get(0)].replaceAll("_", " "), true, false);
                        }
                        if (opened.length > this.switchStates.get(1)) {
                            HandHeldDeviceRenderer.drawStringWithShadow(x + second, top - row * 1.0f, opened[this.switchStates.get(1)].replaceAll("_", " "), true, false);
                        }
                        if (iris.length > this.switchStates.get(2)) {
                            HandHeldDeviceRenderer.drawStringWithShadow(x + second, top - row * 2.0f, iris[this.switchStates.get(2)].replaceAll("_", " "), true, false);
                        }
                        if (lastSymbol.length > this.switchStates.get(3)) {
                            HandHeldDeviceRenderer.drawStringWithShadow(x + second, top - row * 3.0f, lastSymbol[this.switchStates.get(3)].replaceAll("_", " "), true, false);
                        }
                    } else if (mode != UniverseDialerMode.COUNTDOWN) {
                        byte selected = compound.m_128445_("selected");
                        ListTag tagList = compound.m_128437_(mode.tagListName, 10);
                        block12: for (int offset = -1; offset <= 2; ++offset) {
                            int index = selected + offset;
                            if (index < 0 || index >= tagList.size()) continue;
                            boolean active = offset == 0;
                            CompoundTag entryCompound = tagList.m_128728_(index);
                            switch (mode) {
                                case MEMORY: 
                                case NEARBY: {
                                    boolean engage_poo;
                                    HandHeldDeviceRenderer.drawStringWithShadow(-0.1f, -0.5f - 0.2f * (float)offset, index + 1 + ".", active, false);
                                    StargateAddress address = new StargateAddress(entryCompound);
                                    int[] symbolsToDisplay = entryCompound.m_128465_("symbolsToDisplay");
                                    EnumStargateState gateStatus = EnumStargateState.valueOf(compound.m_128451_("gateStatus"));
                                    boolean isIdle = gateStatus.idle();
                                    StargateAddressDynamic dialedAddress = HandHeldDeviceRenderer.addrFromBytes(compound, "dialedAddress");
                                    StargateAddressDynamic toDialAddress = HandHeldDeviceRenderer.addrFromBytes(compound, "toDialAddress");
                                    int dialed = -1;
                                    boolean isDialingThisAddr = false;
                                    if (toDialAddress != null && toDialAddress.equals(address)) {
                                        dialed = 0;
                                        isDialingThisAddr = true;
                                    }
                                    if (dialedAddress != null && dialed == 0 && isDialingThisAddr) {
                                        dialed = dialedAddress.getSize();
                                    }
                                    if (dialed == 0 && isIdle) {
                                        dialed = -1;
                                    }
                                    boolean bl = engage_poo = isDialingThisAddr && dialedAddress != null && dialedAddress.contains((SymbolInterface)dialedAddress.getSymbolType().getOrigin());
                                    if (entryCompound.m_128441_("name")) {
                                        Object entryName = entryCompound.m_128461_("name");
                                        if (dialed > -1) {
                                            entryName = (String)entryName + " (" + dialed + ")";
                                        }
                                        HandHeldDeviceRenderer.drawStringWithShadow(-0.12f, -0.5f - 0.2f * (float)offset, (String)entryName, active, false, true, dialed >= 0, gateStatus);
                                        continue block12;
                                    }
                                    stack.m_85836_();
                                    stack.m_85837_(-0.2, -0.75, 0.0);
                                    stack.m_85841_(1.0f, -1.0f, 1.0f);
                                    stack.m_85836_();
                                    stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                                    int symbolPos = 0;
                                    for (int i : symbolsToDisplay) {
                                        boolean engage_s;
                                        boolean bl2 = engage_s = i <= dialed - (engage_poo ? 1 : 0);
                                        if (i == 9) {
                                            engage_s = engage_poo;
                                        }
                                        SymbolInterface symbol = i >= address.getSize() ? SymbolTypeRegistry.UNIVERSE.getOrigin() : address.get(i);
                                        HandHeldDeviceRenderer.renderSymbol(offset, symbolPos, symbol, isDialingThisAddr, active, engage_s, gateStatus);
                                        ++symbolPos;
                                    }
                                    stack.m_85849_();
                                    stack.m_85849_();
                                    continue block12;
                                }
                                case RINGS: {
                                    continue block12;
                                }
                            }
                        }
                    }
                }
                RenderSystem.disableBlend();
                stack.m_85849_();
                stack.m_85849_();
            }
            stack.m_85849_();
            stack.m_85849_();
            RenderSystem.disableDepthTest();
        }
    }
}

