/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.item.notebook;

import dev.tauri.jsg.api.item.NotebookPageSerialization;
import dev.tauri.jsg.item.JSGItem;
import dev.tauri.jsg.item.notebook.PageNotebookBEWLR;
import dev.tauri.jsg.stargate.network.IAddress;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import dev.tauri.jsg.util.I18n;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class PageNotebookItemFilled
extends JSGItem {
    private static final String UNNAMED = "item.jsg.notebook.unnamed";

    public PageNotebookItemFilled() {
        super(new Item.Properties().m_41497_(Rarity.COMMON), null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private static final PageNotebookBEWLR instance = new PageNotebookBEWLR();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return instance;
            }
        });
    }

    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        if (stack.m_41782_()) {
            CompoundTag compound = stack.m_41783_();
            if (compound == null) {
                return;
            }
            IAddress stargateAddress = NotebookPageSerialization.getDeserializedAddress(compound);
            int[] symbolsToDisplay = compound.m_128465_("symbolsToDisplay");
            HashMap<Integer, Boolean> hashedSymbols = new HashMap<Integer, Boolean>();
            for (int symbolId : symbolsToDisplay) {
                hashedSymbols.put(symbolId, true);
            }
            for (int i = 0; i < 8; ++i) {
                if (hashedSymbols.get(i + 1) == null || !((Boolean)hashedSymbols.get(i + 1)).booleanValue()) continue;
                components.add((Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.ITALIC) + String.valueOf(i < 6 ? ChatFormatting.AQUA : ChatFormatting.DARK_PURPLE) + stargateAddress.get(i).localize())));
            }
        }
    }

    public static int getColorForBiome(String registryPath) {
        int color = 0x303000;
        if (registryPath.contains("ocean") || registryPath.contains("river")) {
            color = 2175392;
        } else if (registryPath.contains("plains")) {
            color = 4747325;
        } else if (registryPath.contains("desert") || registryPath.contains("beach")) {
            color = 10198126;
        } else if (registryPath.contains("extreme_hills")) {
            color = 7561552;
        } else if (registryPath.contains("forest")) {
            color = 5272385;
        } else if (registryPath.contains("taiga")) {
            color = 8104361;
        } else if (registryPath.contains("swamp")) {
            color = 7041847;
        } else if (registryPath.contains("hell")) {
            color = 9841163;
        } else if (registryPath.contains("sky")) {
            color = 6785402;
        } else if (registryPath.contains("ice")) {
            color = 6928582;
        } else if (registryPath.contains("mushroom")) {
            color = 5524301;
        } else if (registryPath.contains("jungle")) {
            color = 0x104004;
        } else if (registryPath.contains("savanna")) {
            color = 0x66622D;
        } else if (registryPath.contains("mesa")) {
            color = 8405271;
        }
        return color;
    }

    public static String getRegistryPathFromWorld(@Nullable Level world, BlockPos pos) {
        if (world == null) {
            return "minecraft:plains";
        }
        return world.m_204166_(pos).m_203543_().orElse(Biomes.f_48205_).m_135782_().m_135815_();
    }

    @Nullable
    public static SymbolTypeEnum<?> getSymbolType(@NotNull CompoundTag tag) {
        return SymbolTypeEnum.byId(tag.m_128451_("symbolType"));
    }

    @Nullable
    public static NotebookPageSerialization.AddressDeserializer getDeserializer(@NotNull CompoundTag tag) {
        return NotebookPageSerialization.byId(PageNotebookItemFilled.getPageAddressType(tag));
    }

    public static ResourceLocation getPageAddressType(@NotNull CompoundTag tag) {
        return new ResourceLocation(tag.m_128461_("addressType"));
    }

    public static CompoundTag getCompoundFromAddress(IAddress address, List<Integer> symbolsToDisplay, String registryPath, int originId, ResourceLocation addressTypeId) {
        int[] symbolsToDisplayArray = new int[symbolsToDisplay.size()];
        for (int i = 0; i < symbolsToDisplay.size(); ++i) {
            symbolsToDisplayArray[i] = symbolsToDisplay.get(i);
        }
        return PageNotebookItemFilled.getCompoundFromAddress(address, symbolsToDisplayArray, registryPath, originId, addressTypeId);
    }

    public static CompoundTag getCompoundFromAddress(IAddress address, int[] symbolsToDisplay, String registryPath, int originId, ResourceLocation addressTypeId) {
        CompoundTag compound = new CompoundTag();
        if (address != null) {
            compound.m_128359_("addressType", addressTypeId.toString());
            if (address.getSymbolType() != null) {
                compound.m_128405_("symbolType", SymbolTypeEnum.getId(address.getSymbolType()));
            }
            if (address.serializeNBT() != null) {
                compound.m_128365_("address", address.serializeNBT());
            }
        }
        compound.m_128385_("symbolsToDisplay", symbolsToDisplay);
        compound.m_128405_("color", PageNotebookItemFilled.getColorForBiome(registryPath));
        compound.m_128405_("originId", originId);
        return compound;
    }

    public static String getUnnamedLocalized() {
        return I18n.format(UNNAMED);
    }

    public static void setName(CompoundTag page, String name) {
        CompoundTag display = new CompoundTag();
        display.m_128359_("Name", Component.Serializer.m_130703_((Component)Component.m_237113_((String)name)));
        page.m_128365_("display", (Tag)display);
    }

    public static String getNameFromCompound(@Nullable CompoundTag compound) {
        CompoundTag display;
        if (compound != null && compound.m_128441_("display") && (display = compound.m_128469_("display")).m_128441_("Name")) {
            return Component.Serializer.m_130701_((String)display.m_128461_("Name")).getString();
        }
        return PageNotebookItemFilled.getUnnamedLocalized();
    }
}

