/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.listener;

import com.mojang.blaze3d.platform.InputConstants;
import dev.tauri.jsg.item.linkable.dialer.UniverseDialerActionEnum;
import dev.tauri.jsg.item.notebook.NotebookActionEnum;
import dev.tauri.jsg.packet.JSGPacketHandler;
import dev.tauri.jsg.packet.packets.NotebookActionPacketToServer;
import dev.tauri.jsg.packet.packets.linkable.GDOCodeKeyPressedToServer;
import dev.tauri.jsg.packet.packets.linkable.UniverseDialerActionPacketToServer;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.screen.gui.GDOVirtualGui;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class InputHandlerClient {
    private static final KeyMapping MODE_SCROLL = new KeyMapping("config.jsg.mode_scroll", 341, "key.categories.jsg");
    private static final KeyMapping ADDRESS_SCROLL = new KeyMapping("config.jsg.address_scroll", 340, "key.categories.jsg");
    private static final KeyMapping MODE_UP = new KeyMapping("config.jsg.mode_up", -1, "key.categories.jsg");
    private static final KeyMapping MODE_DOWN = new KeyMapping("config.jsg.mode_down", -1, "key.categories.jsg");
    private static final KeyMapping ADDRESS_UP = new KeyMapping("config.jsg.address_up", -1, "key.categories.jsg");
    private static final KeyMapping ADDRESS_DOWN = new KeyMapping("config.jsg.address_down", -1, "key.categories.jsg");
    private static final KeyMapping ADDRESS_EDIT = new KeyMapping("config.jsg.address_edit", 260, "key.categories.jsg");
    public static final KeyMapping[] KEY_BINDINGS = new KeyMapping[]{MODE_SCROLL, ADDRESS_SCROLL, MODE_UP, MODE_DOWN, ADDRESS_UP, ADDRESS_DOWN, ADDRESS_EDIT};

    @SubscribeEvent
    public static void onMouseEvent(InputEvent.MouseScrollingEvent event) {
        boolean next;
        boolean bl = next = event.getScrollDelta() < 0.0;
        if (InputHandlerClient.checkForItem((Item)ItemRegistry.UNIVERSE_DIALER.get())) {
            InteractionHand hand = InputHandlerClient.getHand((Item)ItemRegistry.UNIVERSE_DIALER.get());
            UniverseDialerActionEnum action = null;
            if (hand != null) {
                if (MODE_SCROLL.m_90857_()) {
                    action = UniverseDialerActionEnum.MODE_CHANGE;
                } else if (ADDRESS_SCROLL.m_90857_()) {
                    action = UniverseDialerActionEnum.ADDRESS_CHANGE;
                }
                if (action != null) {
                    event.setCanceled(true);
                    JSGPacketHandler.sendToServer(new UniverseDialerActionPacketToServer(action, hand, next));
                }
            }
        } else if (InputHandlerClient.checkForItem((Item)ItemRegistry.NOTEBOOK_ITEM.get())) {
            InteractionHand hand = InputHandlerClient.getHand((Item)ItemRegistry.NOTEBOOK_ITEM.get());
            NotebookActionEnum action = null;
            if (hand != null) {
                if (ADDRESS_SCROLL.m_90857_()) {
                    action = NotebookActionEnum.ADDRESS_CHANGE;
                }
                if (action != null) {
                    event.setCanceled(true);
                    JSGPacketHandler.sendToServer(new NotebookActionPacketToServer(action, hand, next));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onKeyboardEvent(InputEvent.Key event) {
        if (event.getAction() != 1) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (InputHandlerClient.checkForItem((Item)ItemRegistry.UNIVERSE_DIALER.get())) {
            InteractionHand hand = InputHandlerClient.getHand((Item)ItemRegistry.UNIVERSE_DIALER.get());
            UniverseDialerActionEnum action = null;
            boolean next = false;
            if (MODE_UP.m_90857_()) {
                action = UniverseDialerActionEnum.MODE_CHANGE;
            } else if (MODE_DOWN.m_90857_()) {
                action = UniverseDialerActionEnum.MODE_CHANGE;
                next = true;
            } else if (ADDRESS_UP.m_90857_()) {
                action = UniverseDialerActionEnum.ADDRESS_CHANGE;
            } else if (ADDRESS_DOWN.m_90857_()) {
                action = UniverseDialerActionEnum.ADDRESS_CHANGE;
                next = true;
            }
            if (action != null) {
                JSGPacketHandler.sendToServer(new UniverseDialerActionPacketToServer(action, hand, next));
            }
        } else if (InputHandlerClient.checkForItem((Item)ItemRegistry.NOTEBOOK_ITEM.get())) {
            InteractionHand hand = InputHandlerClient.getHand((Item)ItemRegistry.NOTEBOOK_ITEM.get());
            NotebookActionEnum action = null;
            boolean next = false;
            if (ADDRESS_UP.m_90857_()) {
                action = NotebookActionEnum.ADDRESS_CHANGE;
            } else if (ADDRESS_DOWN.m_90857_()) {
                action = NotebookActionEnum.ADDRESS_CHANGE;
                next = true;
            }
            if (action != null) {
                JSGPacketHandler.sendToServer(new NotebookActionPacketToServer(action, hand, next));
            }
        } else if (InputHandlerClient.checkForItem((Item)ItemRegistry.GDO.get()) && Minecraft.m_91087_().f_91080_ instanceof GDOVirtualGui) {
            InteractionHand hand = InputHandlerClient.getHand((Item)ItemRegistry.GDO.get());
            InputConstants.Key key = InputConstants.m_84827_((int)event.getKey(), (int)event.getScanCode());
            OptionalInt numeric = key.m_84876_();
            if (numeric.isPresent()) {
                int number = numeric.getAsInt();
                JSGPacketHandler.sendToServer(new GDOCodeKeyPressedToServer(hand, number));
            } else if (key.m_84873_() == 257) {
                Minecraft.m_91087_().m_91152_(null);
                JSGPacketHandler.sendToServer(new GDOCodeKeyPressedToServer(hand, -1));
            } else if (key.m_84873_() == 259) {
                JSGPacketHandler.sendToServer(new GDOCodeKeyPressedToServer(hand, -2));
            }
        }
        if (ADDRESS_EDIT.m_90857_()) {
            InputHandlerClient.tryOpenAddressGui((Player)player);
        }
    }

    private static void tryOpenAddressGui(Player player) {
    }

    @Nullable
    public static InteractionHand getHand(Item item) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        InteractionHand hand = null;
        if (player == null) {
            return null;
        }
        if (player.m_21205_().m_41720_() == item) {
            hand = InteractionHand.MAIN_HAND;
        } else if (player.m_21206_().m_41720_() == item) {
            hand = InteractionHand.OFF_HAND;
        }
        return hand;
    }

    @Nullable
    public static ItemStack getItemStack(Player player, Item item) {
        InteractionHand hand = InputHandlerClient.getHand(item);
        if (hand != null) {
            return player.m_21120_(hand);
        }
        return null;
    }

    public static boolean checkForItem(Item item) {
        return InputHandlerClient.getHand(item) != null;
    }
}

