/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.loader;

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.blaze3d.platform.NativeImage;
import dev.tauri.jsg.JSG;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.config.util.JSGConfigUtil;
import dev.tauri.jsg.loader.model.OBJLoader;
import dev.tauri.jsg.loader.model.OBJModel;
import dev.tauri.jsg.loader.texture.Texture;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class OriginsLoader {
    public static final String MODELS_PATH = "assets/models/origins/";
    public static final String TEXTURES_PATH = "assets/textures/origins/";
    public static final String LOADER_PATH = "assets/loader/";
    public static final String RING_END = "_ring.obj";
    public static final String DHD_END = "_dhd.obj";
    public static final String DHD_LIGHT_END = "_dhd_light.obj";
    public static final String TEXTURE_END = ".png";
    public static final String BASE = "origin_";
    public static final ArrayList<Integer> NOT_LOADED_ORIGINS = new ArrayList();
    public static final int DEFAULT_ORIGIN_ID = 5;
    public static final int MOD_POINT_OF_ORIGINS_COUNT = 6;

    public static File getOriginFile(EnumOriginFileType fileType, int originId) {
        return switch (fileType) {
            case EnumOriginFileType.MODEL_RING -> new File(JSG.modConfigDir, "jsg/assets/models/origins/origin_" + originId + RING_END);
            case EnumOriginFileType.MODEL_DHD -> new File(JSG.modConfigDir, "jsg/assets/models/origins/origin_" + originId + DHD_END);
            case EnumOriginFileType.MODEL_DHD_LIGHT -> new File(JSG.modConfigDir, "jsg/assets/models/origins/origin_" + originId + DHD_LIGHT_END);
            default -> new File(JSG.modConfigDir, "jsg/assets/textures/origins/origin_" + originId + TEXTURE_END);
        };
    }

    public static List<Integer> getAllOrigins() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < 6; ++i) {
            list.add(i);
        }
        for (String s : (List)JSGConfig.Stargate.additionalOrigins.get()) {
            int id = Integer.parseInt(s.split(":")[0]);
            list.add(id);
        }
        return list;
    }

    private static void checkDirectory() {
        try {
            File models = new File(JSG.modConfigDir, "jsg/assets/models/origins/");
            File textures = new File(JSG.modConfigDir, "jsg/assets/textures/origins/");
            File loader = new File(JSG.modConfigDir, "jsg/assets/loader/");
            if (!models.exists()) {
                Files.createDirectories(models.toPath(), new FileAttribute[0]);
            }
            if (!textures.exists()) {
                Files.createDirectories(textures.toPath(), new FileAttribute[0]);
            }
            if (!loader.exists()) {
                Files.createDirectories(loader.toPath(), new FileAttribute[0]);
            }
        }
        catch (Exception e) {
            JSG.logger.error("Error while creating folders for custom resources!", (Throwable)e);
        }
    }

    public static void registerTextures(Map<ResourceLocation, Texture> texturesArray) throws IOException {
        OriginsLoader.checkDirectory();
        if (((List)JSGConfig.Stargate.additionalOrigins.get()).isEmpty()) {
            return;
        }
        for (String s : (List)JSGConfig.Stargate.additionalOrigins.get()) {
            int id = Integer.parseInt(s.split(":")[0]);
            if (!OriginsLoader.getOriginFile(EnumOriginFileType.TEXTURE, id).exists()) {
                NOT_LOADED_ORIGINS.add(id);
                JSG.logger.error("Origin texture not found! [" + id + "]");
                continue;
            }
            InputStream stream = Files.newInputStream(OriginsLoader.getOriginFile(EnumOriginFileType.TEXTURE, id).toPath(), new OpenOption[0]);
            NativeImage image = NativeImage.m_85058_((InputStream)stream);
            ResourceLocation rs = OriginsLoader.getResource(EnumOriginFileType.TEXTURE, id);
            texturesArray.put(rs, new Texture(image, rs));
        }
    }

    public static void loadModels(Map<ResourceLocation, OBJModel> modelsArray) throws IOException {
        OriginsLoader.checkDirectory();
        if (((List)JSGConfig.Stargate.additionalOrigins.get()).isEmpty()) {
            return;
        }
        for (String s : (List)JSGConfig.Stargate.additionalOrigins.get()) {
            int id = Integer.parseInt(s.split(":")[0]);
            if (!(OriginsLoader.getOriginFile(EnumOriginFileType.MODEL_DHD, id).exists() && OriginsLoader.getOriginFile(EnumOriginFileType.MODEL_RING, id).exists() && OriginsLoader.getOriginFile(EnumOriginFileType.MODEL_DHD_LIGHT, id).exists())) {
                NOT_LOADED_ORIGINS.add(id);
                JSG.logger.error("Origin model not found! [" + id + "]");
                continue;
            }
            modelsArray.put(OriginsLoader.getResource(EnumOriginFileType.MODEL_DHD, id), OBJLoader.loadModel(Files.newInputStream(OriginsLoader.getOriginFile(EnumOriginFileType.MODEL_DHD, id).toPath(), new OpenOption[0])));
            modelsArray.put(OriginsLoader.getResource(EnumOriginFileType.MODEL_RING, id), OBJLoader.loadModel(Files.newInputStream(OriginsLoader.getOriginFile(EnumOriginFileType.MODEL_RING, id).toPath(), new OpenOption[0])));
            modelsArray.put(OriginsLoader.getResource(EnumOriginFileType.MODEL_DHD_LIGHT, id), OBJLoader.loadModel(Files.newInputStream(OriginsLoader.getOriginFile(EnumOriginFileType.MODEL_DHD_LIGHT, id).toPath(), new OpenOption[0])));
        }
    }

    public static ResourceLocation getResource(EnumOriginFileType fileType, int originId) {
        if (NOT_LOADED_ORIGINS.contains(originId)) {
            originId = 5;
        }
        if (fileType != EnumOriginFileType.TEXTURE) {
            return new ResourceLocation("jsg", "models/tesr/milkyway/" + (fileType == EnumOriginFileType.MODEL_RING ? "ring/" : "") + BASE + originId + (fileType == EnumOriginFileType.MODEL_DHD_LIGHT ? "_light" : "") + ".obj");
        }
        return new ResourceLocation("jsg", "textures/gui/symbol/milkyway/origin_" + originId + TEXTURE_END);
    }

    public static boolean loadOriginsToConfig(boolean rewrite) {
        OriginsLoader.checkDirectory();
        File loaderFile = new File(JSG.modConfigDir, "jsg/assets/loader/origins.json");
        try {
            Type typeOfHashMap = new TypeToken<Map<String, List<String>>>(){}.getType();
            Map map = (Map)new GsonBuilder().create().fromJson((Reader)new FileReader(loaderFile), typeOfHashMap);
            List list = (List)map.get("list");
            int size = list.size();
            if (!rewrite) {
                size += ((List)JSGConfig.Stargate.additionalOrigins.get()).size();
                for (String s : (List)JSGConfig.Stargate.additionalOrigins.get()) {
                    if (!list.contains(s)) {
                        list.add(s);
                        continue;
                    }
                    --size;
                }
            }
            String[] toConfig = new String[size];
            int i = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String s;
                toConfig[i] = s = (String)iterator.next();
                ++i;
            }
            JSGConfig.Stargate.additionalOrigins.set(List.of(toConfig));
            JSGConfigUtil.reloadConfig();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static enum EnumOriginFileType {
        MODEL_RING,
        MODEL_DHD,
        MODEL_DHD_LIGHT,
        TEXTURE;

    }
}

