/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.packet.packets.linkable;

import dev.tauri.jsg.blockentity.stargate.StargateUniverseBaseBE;
import dev.tauri.jsg.item.linkable.dialer.UniverseDialerActionEnum;
import dev.tauri.jsg.item.linkable.dialer.UniverseDialerMode;
import dev.tauri.jsg.packet.JSGPacket;
import dev.tauri.jsg.registry.ItemRegistry;
import dev.tauri.jsg.sound.JSGSoundHelper;
import dev.tauri.jsg.sound.SoundEventEnum;
import dev.tauri.jsg.stargate.EnumStargateState;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class UniverseDialerActionPacketToServer
extends JSGPacket {
    private UniverseDialerActionEnum action;
    private InteractionHand hand;
    private boolean next;

    public UniverseDialerActionPacketToServer(UniverseDialerActionEnum action, InteractionHand hand, boolean next) {
        this.action = action;
        this.hand = hand;
        this.next = next;
    }

    public UniverseDialerActionPacketToServer(FriendlyByteBuf buf) {
        super(buf);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        buf.writeInt(this.hand == InteractionHand.MAIN_HAND ? 0 : 1);
        buf.writeBoolean(this.next);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.action = UniverseDialerActionEnum.values()[buf.readInt()];
        this.hand = buf.readInt() == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        this.next = buf.readBoolean();
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        ctx.setPacketHandled(true);
        ctx.enqueueWork(() -> {
            CompoundTag compound;
            ServerPlayer player = ctx.getSender();
            if (player == null) {
                return;
            }
            Level world = player.m_9236_();
            ItemStack stack = player.m_21120_(this.hand);
            if (stack.m_41720_() != ItemRegistry.UNIVERSE_DIALER.get()) {
                return;
            }
            if (!stack.m_41782_()) {
                return;
            }
            boolean playModeChangeSound = false;
            boolean playDialFailSound = false;
            if (stack.m_41720_() == ItemRegistry.UNIVERSE_DIALER.get() && stack.m_41782_() && (compound = stack.m_41783_()) != null) {
                UniverseDialerMode mode = UniverseDialerMode.valueOf(compound.m_128445_("mode"));
                byte selected = compound.m_128445_("selected");
                switch (this.action) {
                    case MODE_CHANGE: {
                        mode = this.next ? mode.next() : mode.prev();
                        compound.m_128344_("mode", mode.id);
                        compound.m_128344_("selected", (byte)0);
                        playModeChangeSound = true;
                        break;
                    }
                    case ADDRESS_CHANGE: {
                        int addressCount = compound.m_128437_(mode.tagListName, 10).size();
                        if (this.next && selected < addressCount - 1) {
                            compound.m_128344_("selected", (byte)(selected + 1));
                            playModeChangeSound = true;
                        }
                        if (this.next || selected <= 0) break;
                        compound.m_128344_("selected", (byte)(selected - 1));
                        playModeChangeSound = true;
                        break;
                    }
                    case ABORT: {
                        if (compound.m_128441_("linkedGate")) {
                            BlockPos pos = BlockPos.m_122022_((long)compound.m_128454_("linkedGate"));
                            StargateUniverseBaseBE gateTile = (StargateUniverseBaseBE)world.m_7702_(pos);
                            if (gateTile == null) break;
                            if (gateTile.getStargateState() == EnumStargateState.DIALING) {
                                if (!gateTile.abortDialingSequence()) break;
                                player.m_5661_((Component)Component.m_237115_((String)"item.jsg.universe_dialer.aborting"), true);
                                playDialFailSound = true;
                                break;
                            }
                            player.m_5661_((Component)Component.m_237115_((String)"item.jsg.universe_dialer.not_dialing"), true);
                            break;
                        }
                        player.m_5661_((Component)Component.m_237115_((String)"item.jsg.universe_dialer.not_linked"), true);
                    }
                }
            }
            if (playDialFailSound) {
                JSGSoundHelper.playSoundToPlayer(player, SoundEventEnum.UNIVERSE_DIALER_START_DIAL, player.m_20183_());
            }
            if (playModeChangeSound) {
                JSGSoundHelper.playSoundToPlayer(player, SoundEventEnum.UNIVERSE_DIALER_MODE_CHANGE, player.m_20183_());
            }
        });
    }
}

