/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.packet.packets.stargate;

import dev.tauri.jsg.blockentity.dialhomedevice.DHDAbstractBE;
import dev.tauri.jsg.packet.PositionedPacket;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class DHDButtonClickedToServer
extends PositionedPacket {
    public SymbolInterface symbol;
    public SymbolTypeEnum<?> symbolType;
    public boolean force;

    public DHDButtonClickedToServer() {
    }

    public DHDButtonClickedToServer(BlockPos pos, SymbolInterface symbol) {
        super(pos);
        this.symbol = symbol;
        this.symbolType = symbol.getSymbolType();
    }

    public DHDButtonClickedToServer(BlockPos pos, SymbolInterface symbol, boolean force) {
        this(pos, symbol);
        this.force = force;
    }

    public DHDButtonClickedToServer(FriendlyByteBuf buf) {
        super(buf);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(SymbolTypeEnum.getId(this.symbolType));
        buf.writeInt(this.symbol.getId());
        buf.writeBoolean(this.force);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        super.fromBytes(buf);
        this.symbolType = SymbolTypeEnum.byId(buf.readInt());
        this.symbol = this.symbolType.valueOf(buf.readInt());
        this.force = buf.readBoolean();
    }

    @Override
    public void handle(NetworkEvent.Context ctx) {
        if (ctx.getDirection() != NetworkDirection.PLAY_TO_SERVER) {
            return;
        }
        ctx.setPacketHandled(true);
        ServerPlayer player = ctx.getSender();
        if (player == null) {
            return;
        }
        Level world = player.m_9236_();
        ctx.enqueueWork(() -> {
            DHDAbstractBE dhdTile = (DHDAbstractBE)world.m_7702_(this.pos);
            if (dhdTile == null) {
                return;
            }
            dhdTile.pushSymbolButton(this.symbol, player, this.force);
        });
    }
}

