/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.raycaster;

import dev.tauri.jsg.raycaster.util.RayCastedButton;
import dev.tauri.jsg.raycaster.util.RaycasterVertex;
import dev.tauri.jsg.util.vectors.Vector3f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class Raycaster {
    protected abstract List<RayCastedButton> getButtons();

    protected abstract Vector3f getTranslation(Level var1, BlockPos var2);

    protected abstract boolean buttonClicked(Level var1, Player var2, int var3, BlockPos var4, InteractionHand var5);

    public boolean onActivated(Level level, BlockPos pos, Player player, float rotation, InteractionHand hand) {
        Vec3 lookVec = player.m_20154_();
        for (RayCastedButton btn : this.getButtons()) {
            List<Vector3f> veritices = btn.vectors;
            ArrayList<Vec3> polygon = new ArrayList<Vec3>();
            for (Vector3f v : veritices) {
                polygon.add(this.getTransposed(v, rotation, level, pos, player).getVec3());
            }
            int n = veritices.size();
            if (!this.doesRayIntersectPolygon(player.m_20182_().m_82520_(0.0, (double)player.m_20236_(player.m_20089_()), 0.0), player.m_20154_(), polygon)) continue;
            this.buttonClicked(level, player, btn.buttonId, pos, hand);
            return true;
        }
        return false;
    }

    private RaycasterVertex getTransposed(Vector3f v, float rotation, Level Level2, BlockPos pos, Player player) {
        RaycasterVertex current = new RaycasterVertex(v.x, v.y, v.z);
        return current.rotate(rotation).localToGlobal(pos, this.getTranslation(Level2, pos));
    }

    public boolean doesRayIntersectPolygon(Vec3 eye, Vec3 direction, List<Vec3> polygon) {
        if (polygon.size() < 3) {
            return false;
        }
        Vec3 normal = polygon.get(1).m_82546_(polygon.get(0)).m_82537_(polygon.get(2).m_82546_(polygon.get(0))).m_82541_();
        double denom = normal.m_82526_(direction);
        if (Math.abs(denom) < 1.0E-6) {
            return false;
        }
        double t = -normal.m_82526_(eye.m_82546_(polygon.get(0))) / denom;
        if (t < 0.0) {
            return false;
        }
        Vec3 intersection = eye.m_82549_(direction.m_82490_(t));
        return this.isPointInPolygonBarycentric(intersection, polygon);
    }

    private boolean isPointInPolygonBarycentric(Vec3 point, List<Vec3> polygon) {
        Vec3 p0 = polygon.get(0);
        for (int i = 1; i < polygon.size() - 1; ++i) {
            Vec3 p2;
            Vec3 p1 = polygon.get(i);
            if (!this.isPointInTriangle(point, p0, p1, p2 = polygon.get(i + 1))) continue;
            return true;
        }
        return false;
    }

    private boolean isPointInTriangle(Vec3 p, Vec3 a, Vec3 b, Vec3 c) {
        Vec3 v0 = c.m_82546_(a);
        Vec3 v1 = b.m_82546_(a);
        Vec3 v2 = p.m_82546_(a);
        double dot00 = v0.m_82526_(v0);
        double dot01 = v0.m_82526_(v1);
        double dot02 = v0.m_82526_(v2);
        double dot11 = v1.m_82526_(v1);
        double dot12 = v1.m_82526_(v2);
        double invDenom = 1.0 / (dot00 * dot11 - dot01 * dot01);
        double u = (dot11 * dot02 - dot01 * dot12) * invDenom;
        double v = (dot00 * dot12 - dot01 * dot02) * invDenom;
        return u >= 0.0 && v >= 0.0 && u + v <= 1.0;
    }
}

