/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fluids.FluidStack;

public class BlockRenderer {
    public static void renderBlock(Level level, BlockPos absoluteWorldPos, BlockState blockState, BlockPos pos, PoseStack stack, MultiBufferSource source, int light, int overlay) {
        BlockRenderer.renderBlock(level, absoluteWorldPos, blockState, pos, stack, source, light, overlay, 1.0f);
    }

    public static void renderBlock(Level level, BlockPos absoluteWorldPos, BlockState blockState, BlockPos pos, PoseStack stack, MultiBufferSource source, int light, int overlay, float alpha) {
        RenderShape rendershape = blockState.m_60799_();
        stack.m_85836_();
        stack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
        if (rendershape == RenderShape.MODEL) {
            BlockRenderDispatcher renderer = Minecraft.m_91087_().m_91289_();
            BakedModel bakedmodel = renderer.m_110910_(blockState);
            ModelData modelData = ModelData.EMPTY;
            int color = Minecraft.m_91087_().m_91298_().m_92577_(blockState, (BlockAndTintGetter)level, absoluteWorldPos, 0);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            for (RenderType rt : bakedmodel.getRenderTypes(blockState, RandomSource.m_216335_((long)42L), modelData)) {
                BlockRenderer.renderModel(stack.m_85850_(), source.m_6299_(RenderType.m_110466_()), blockState, bakedmodel, red, green, blue, alpha, light, overlay, modelData, rt);
            }
        } else {
            Minecraft.m_91087_().m_91289_().m_110912_(blockState, stack, source, light, overlay);
        }
        stack.m_85849_();
    }

    public static void renderModel(PoseStack.Pose pPose, VertexConsumer pConsumer, @Nullable BlockState pState, BakedModel pModel, float pRed, float pGreen, float pBlue, float alpha, int pPackedLight, int pPackedOverlay, ModelData modelData, RenderType renderType) {
        RandomSource randomsource = RandomSource.m_216327_();
        for (Direction direction : LevelRenderer.f_109434_) {
            randomsource.m_188584_(42L);
            BlockRenderer.renderQuadList(pPose, pConsumer, pRed, pGreen, pBlue, alpha, pModel.getQuads(pState, direction, randomsource, modelData, renderType), pPackedLight, pPackedOverlay);
        }
        randomsource.m_188584_(42L);
        BlockRenderer.renderQuadList(pPose, pConsumer, pRed, pGreen, pBlue, alpha, pModel.getQuads(pState, null, randomsource, modelData, renderType), pPackedLight, pPackedOverlay);
    }

    private static void renderQuadList(PoseStack.Pose pPose, VertexConsumer pConsumer, float pRed, float pGreen, float pBlue, float alpha, List<BakedQuad> pQuads, int pPackedLight, int pPackedOverlay) {
        for (BakedQuad bakedquad : pQuads) {
            float f2;
            float f1;
            float f;
            if (bakedquad.m_111304_()) {
                f = Mth.m_14036_((float)pRed, (float)0.0f, (float)1.0f);
                f1 = Mth.m_14036_((float)pGreen, (float)0.0f, (float)1.0f);
                f2 = Mth.m_14036_((float)pBlue, (float)0.0f, (float)1.0f);
            } else {
                f = 1.0f;
                f1 = 1.0f;
                f2 = 1.0f;
            }
            pConsumer.putBulkData(pPose, bakedquad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, f, f1, f2, alpha, new int[]{pPackedLight, pPackedLight, pPackedLight, pPackedLight}, pPackedOverlay, false);
        }
    }

    @Nullable
    public static TextureAtlasSprite getFluidTexture(FluidStack fluid, FluidTextureType type) {
        try {
            IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
            if (type == FluidTextureType.STILL) {
                return BlockRenderer.getSprite(props.getStillTexture(fluid));
            }
            return BlockRenderer.getSprite(props.getFlowingTexture(fluid));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static TextureAtlasSprite getSprite(ResourceLocation spriteLocation) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(spriteLocation);
    }

    public static enum FluidTextureType {
        STILL,
        FLOWING;

    }
}

