/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.stargate;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.tauri.jsg.blockentity.CamouflageBE;
import dev.tauri.jsg.blockentity.stargate.StargateAbstractBaseBE;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.helpers.BlockPosHelper;
import dev.tauri.jsg.helpers.JSGMinecraftHelper;
import dev.tauri.jsg.loader.model.OBJModel;
import dev.tauri.jsg.loader.texture.Texture;
import dev.tauri.jsg.loader.texture.TextureLoader;
import dev.tauri.jsg.multistructure.IMultiStructureRenderer;
import dev.tauri.jsg.property.JSGProperties;
import dev.tauri.jsg.renderer.BlockRenderer;
import dev.tauri.jsg.renderer.stargate.StargateAbstractRendererState;
import dev.tauri.jsg.renderer.stargate.StargateClassicRendererState;
import dev.tauri.jsg.renderer.stargate.StargateRendererStatic;
import dev.tauri.jsg.stargate.EnumIrisState;
import dev.tauri.jsg.stargate.EnumIrisType;
import dev.tauri.jsg.util.JSGAxisAlignedBB;
import dev.tauri.jsg.util.JSGColorUtil;
import dev.tauri.jsg.util.math.MathHelper;
import java.awt.Color;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public abstract class StargateAbstractRenderer<S extends StargateAbstractRendererState>
implements BlockEntityRenderer<StargateAbstractBaseBE>,
IMultiStructureRenderer<StargateAbstractBaseBE> {
    public StargateAbstractBaseBE tileEntity;
    public PoseStack stack;
    public MultiBufferSource source;
    public int combinedLight;
    public Level level;
    public float partialTicks;
    public S rendererState;
    protected static final String EV_HORIZON_NORMAL_TEXTURE_ANIMATED = "textures/tesr/event_horizon_animated.jpg";
    protected static final String EV_HORIZON_KAWOOSH_TEXTURE_ANIMATED = "textures/tesr/event_horizon_animated_kawoosh.jpg";
    protected static final String EV_HORIZON_DESATURATED_KAWOOSH_TEXTURE_ANIMATED = "textures/tesr/event_horizon_animated_kawoosh_unstable.jpg";
    protected static final String EV_HORIZON_DESATURATED_TEXTURE_ANIMATED = "textures/tesr/event_horizon_animated_unstable.jpg";
    protected static final String EV_HORIZON_NORMAL_TEXTURE = "textures/tesr/event_horizon.jpg";
    protected static final String EV_HORIZON_DESATURATED_TEXTURE = "textures/tesr/event_horizon_unstable.jpg";
    private static final float VORTEX_START = 5.275f;
    private static final float SPEED_FACTOR = 6.0f;
    private static final Map<ResourceLocation, Boolean> EH_RENDERED = new HashMap<ResourceLocation, Boolean>();

    public StargateAbstractRenderer(BlockEntityRendererProvider.Context ignored) {
    }

    @ParametersAreNonnullByDefault
    public boolean shouldRenderOffScreen(StargateAbstractBaseBE baseBE) {
        return true;
    }

    public int m_142163_() {
        return 192;
    }

    @ParametersAreNonnullByDefault
    public boolean shouldRender(StargateAbstractBaseBE baseBE, Vec3 vec3) {
        return super.m_142756_((BlockEntity)baseBE, vec3);
    }

    @ParametersAreNonnullByDefault
    public void initForGui(StargateAbstractBaseBE tile, GuiGraphics graphics) {
        this.tileEntity = tile;
        this.level = tile.m_58904_();
        this.rendererState = tile.getRendererStateClient();
        this.stack = graphics.m_280168_();
        this.partialTicks = 0.0f;
        this.source = graphics.m_280091_();
        StargateRendererStatic.currentStack = this.stack;
    }

    public int getCombinedLight() {
        int count = 0;
        int count2 = 0;
        long blockSum = 0L;
        long skySum = 0L;
        for (Map.Entry<BlockPos, BlockState> block : this.tileEntity.getMergeHelper().getBlocks().entrySet()) {
            for (Direction side : Direction.values()) {
                ++count;
                count2 += 2;
                int light = LevelRenderer.m_109541_((BlockAndTintGetter)this.level, (BlockPos)block.getKey().m_121955_(side.m_122436_()));
                blockSum += (long)LightTexture.m_109883_((int)light) * 2L;
                skySum += (long)LightTexture.m_109894_((int)light);
            }
        }
        if (count == 0) {
            return 0xF000F0;
        }
        return LightTexture.m_109885_((int)((int)(blockSum / (long)count2)), (int)((int)(skySum / (long)count)));
    }

    public void renderCamoBlocks(int combinedOverlay) {
        this.stack.m_85836_();
        ArrayList<Map.Entry<BlockPos, BlockState>> list = new ArrayList<Map.Entry<BlockPos, BlockState>>(this.tileEntity.getMergeHelper().getBlocks().entrySet());
        list.add(new AbstractMap.SimpleEntry<BlockPos, BlockState>(this.tileEntity.m_58899_(), this.tileEntity.getCurrentBlockState()));
        for (Map.Entry<BlockPos, BlockState> block : list) {
            CamouflageBE camoBE;
            BlockState camoState;
            BlockEntity tile = this.level.m_7702_(block.getKey());
            if (!(tile instanceof CamouflageBE) || (camoState = (camoBE = (CamouflageBE)tile).getCamoBlock()).m_60795_()) continue;
            int light = LevelRenderer.m_109541_((BlockAndTintGetter)this.level, (BlockPos)block.getKey());
            BlockRenderer.renderBlock(this.tileEntity.m_58904_(), block.getKey(), camoState, block.getKey().m_121996_((Vec3i)this.tileEntity.m_58899_()), this.stack, this.source, light, combinedOverlay);
        }
        this.stack.m_85849_();
    }

    @ParametersAreNonnullByDefault
    public void render(StargateAbstractBaseBE baseBE, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, int ignoredLight, int combinedOverlay) {
        this.tileEntity = baseBE;
        this.rendererState = baseBE.getRendererStateClient();
        this.stack = stack;
        this.partialTicks = partialTicks;
        this.source = bufferSource;
        if (this.tileEntity.m_58904_() == null) {
            return;
        }
        this.level = this.tileEntity.getLevelNotNull();
        this.combinedLight = this.getCombinedLight();
        OBJModel.source = bufferSource;
        OBJModel.packedLight = this.combinedLight;
        OBJModel.resetRGB();
        OBJModel.resetDynamicLightning();
        if (!this.shouldRender()) {
            this.renderBuildingHelper(this.tileEntity, stack, this.source, this.combinedLight, combinedOverlay);
        } else {
            this.renderCamoBlocks(combinedOverlay);
            this.stack.m_85836_();
            if (((Boolean)JSGConfig.Debug.renderBoundingBoxes.get()).booleanValue() || Minecraft.m_91087_().m_91290_().m_114377_()) {
                this.stack.m_85836_();
                ((JSGAxisAlignedBB)this.tileEntity.getRenderBoundingBox()).inset(this.tileEntity.m_58899_()).render(stack);
                this.tileEntity.getEventHorizonLocalBox().render(stack);
                for (JSGAxisAlignedBB aabb : this.tileEntity.getLocalInnerBlockBoxes()) {
                    aabb.render(stack);
                }
                for (JSGAxisAlignedBB aabb : this.tileEntity.getLocalKillingBoxes()) {
                    aabb.render(stack);
                }
                this.stack.m_85849_();
            }
            this.correctRotations();
            this.stack.m_85836_();
            this.stack.m_252781_(Axis.f_252392_.m_252977_((float)BlockPosHelper.getDegrees(BlockPosHelper.getRotation(this.tileEntity.getMergeHelper().horizontalFacing))));
            this.stack.m_252781_(Axis.f_252495_.m_252977_((float)BlockPosHelper.getDegrees(BlockPosHelper.getRotation(this.tileEntity.getMergeHelper().verticalFacing))));
            this.stack.m_85836_();
            this.applyTransformations();
            this.stack.m_85836_();
            StargateRendererStatic.currentStack = this.stack;
            this.renderWholeGate();
            this.stack.m_85849_();
            this.stack.m_85849_();
            this.stack.m_85849_();
            this.stack.m_85849_();
            this.renderCamoBlocks(combinedOverlay);
        }
        OBJModel.resetRGB();
        OBJModel.resetDynamicLightning();
    }

    protected void correctRotations() {
        block0 : switch (this.tileEntity.getMergeHelper().horizontalFacing) {
            case WEST: {
                if (this.tileEntity.getMergeHelper().verticalFacing == null) {
                    this.stack.m_252880_(1.0f, 0.0f, 0.0f);
                    break;
                }
                switch (this.tileEntity.getMergeHelper().verticalFacing) {
                    case UP: {
                        break block0;
                    }
                    case DOWN: {
                        this.stack.m_252880_(1.0f, 1.0f, 0.0f);
                        break block0;
                    }
                }
                this.stack.m_252880_(1.0f, 0.0f, 0.0f);
                break;
            }
            case NORTH: {
                if (this.tileEntity.getMergeHelper().verticalFacing == null) {
                    this.stack.m_252880_(1.0f, 0.0f, 1.0f);
                    break;
                }
                switch (this.tileEntity.getMergeHelper().verticalFacing) {
                    case UP: {
                        this.stack.m_252880_(1.0f, 0.0f, 0.0f);
                        break block0;
                    }
                    case DOWN: {
                        this.stack.m_252880_(1.0f, 1.0f, 1.0f);
                        break block0;
                    }
                }
                this.stack.m_252880_(1.0f, 0.0f, 1.0f);
                break;
            }
            case EAST: {
                if (this.tileEntity.getMergeHelper().verticalFacing == null) {
                    this.stack.m_252880_(0.0f, 0.0f, 1.0f);
                    break;
                }
                switch (this.tileEntity.getMergeHelper().verticalFacing) {
                    case UP: {
                        this.stack.m_252880_(1.0f, 0.0f, 1.0f);
                        break block0;
                    }
                    case DOWN: {
                        this.stack.m_252880_(0.0f, 1.0f, 1.0f);
                        break block0;
                    }
                }
                this.stack.m_252880_(0.0f, 0.0f, 1.0f);
                break;
            }
            default: {
                if (this.tileEntity.getMergeHelper().verticalFacing == null) break;
                switch (this.tileEntity.getMergeHelper().verticalFacing) {
                    case UP: {
                        this.stack.m_252880_(0.0f, 0.0f, 1.0f);
                        break block0;
                    }
                    case DOWN: {
                        this.stack.m_252880_(0.0f, 1.0f, 0.0f);
                        break block0;
                    }
                }
            }
        }
    }

    protected abstract void applyTransformations();

    public static boolean isEhKawooshLoaded() {
        return TextureLoader.INSTANCE.isTextureLoaded(new ResourceLocation("jsg", "textures/tesr/event_horizon_animated_kawoosh.jpg_0.0"));
    }

    public void renderWholeGate() {
        this.renderGate();
        this.renderIris(true);
        if (((StargateAbstractRendererState)this.rendererState).doEventHorizonRender) {
            this.stack.m_85836_();
            this.renderKawoosh();
            this.stack.m_85849_();
        } else if (((Boolean)JSGConfig.Stargate.renderEHifTheyNot.get()).booleanValue()) {
            this.stack.m_85836_();
            this.preRenderKawoosh();
            this.stack.m_85849_();
        }
        this.renderIris(false);
    }

    protected boolean shouldRender() {
        if (this.tileEntity == null) {
            return false;
        }
        if (this.rendererState == null) {
            return false;
        }
        return this.tileEntity.getCurrentBlockState().m_61138_((Property)JSGProperties.RENDER_BLOCK_PROPERTY) && (Boolean)this.tileEntity.getCurrentBlockState().m_61143_((Property)JSGProperties.RENDER_BLOCK_PROPERTY) == false;
    }

    protected abstract void renderGate();

    public void scaleVortex() {
    }

    public boolean shouldRenderBackVortex() {
        return false;
    }

    protected ResourceLocation getEventHorizonTextureResource(StargateAbstractRendererState rendererState, boolean kawoosh) {
        return new ResourceLocation("jsg", this.getEventHorizonTexturePath(rendererState, kawoosh));
    }

    protected String getEventHorizonTexturePath(StargateAbstractRendererState rendererState, boolean kawoosh) {
        return rendererState.horizonUnstable ? (kawoosh ? EV_HORIZON_DESATURATED_KAWOOSH_TEXTURE_ANIMATED : EV_HORIZON_DESATURATED_TEXTURE_ANIMATED) : (kawoosh ? EV_HORIZON_KAWOOSH_TEXTURE_ANIMATED : EV_HORIZON_NORMAL_TEXTURE_ANIMATED);
    }

    protected void renderKawoosh() {
        this.renderKawoosh((StargateAbstractRendererState)this.rendererState, true);
    }

    protected void preRenderKawoosh() {
        StargateAbstractRendererState rs = new StargateAbstractRendererState().initClient(((StargateAbstractRendererState)this.rendererState).pos, ((StargateAbstractRendererState)this.rendererState).getBiomeOverlay());
        for (int i = 0; i < 2; ++i) {
            rs.vortexState = i == 0 ? EnumVortexState.STILL : EnumVortexState.FORMING;
            this.renderKawoosh(rs, false);
        }
    }

    public float[] getEventHorizonColor() {
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    protected void renderKawoosh(StargateAbstractRendererState rendererState, boolean render) {
        Texture ehTexture;
        float gateWait = (float)this.tileEntity.getTime() - (float)rendererState.gateWaitStart;
        if (gateWait < 20.0f) {
            return;
        }
        boolean isKawoosh = rendererState.vortexState == EnumVortexState.FORMING || rendererState.vortexState == EnumVortexState.DECREASING || rendererState.vortexState == EnumVortexState.FULL;
        ResourceLocation ehTextureRes = this.getEventHorizonTextureResource(rendererState, isKawoosh && !rendererState.noxDialing);
        if (!render && EH_RENDERED.get(ehTextureRes).booleanValue()) {
            return;
        }
        EH_RENDERED.put(ehTextureRes, true);
        this.stack.m_85836_();
        this.stack.m_85837_(0.0, 0.0, 0.02);
        if (!render) {
            this.stack.m_85841_(1.0E-7f, 1.0E-7f, 1.0E-7f);
        }
        if ((ehTexture = TextureLoader.INSTANCE.getTexture(ehTextureRes)) != null) {
            ehTexture.bindTexture();
        }
        long kawooshStart = rendererState.gateWaitStart + 44L - 24L;
        float tick = (float)(this.level.m_46467_() - kawooshStart) + this.partialTicks;
        float inner = 3.790975f - tick / (rendererState.noxDialing ? 3.2f : 1.0f) / 3.957f;
        float tick2 = tick / 4.0f;
        if ((double)tick2 <= 1.5707963267948966) {
            rendererState.whiteOverlayAlpha = Float.valueOf(MathHelper.cos(tick2));
        } else if (!rendererState.zeroAlphaSet) {
            rendererState.zeroAlphaSet = true;
            rendererState.whiteOverlayAlpha = Float.valueOf(0.0f);
        }
        float kawooshRadius = 0.5f;
        if (rendererState.noxDialing) {
            kawooshRadius = 0.2f;
        }
        float noxAlpha = 0.0f;
        if (rendererState.noxDialing) {
            noxAlpha = Math.min(0.8f, Math.max(0.0f, inner / 3.790975f));
        }
        if (rendererState.vortexState != EnumVortexState.STILL && rendererState.vortexState != EnumVortexState.CLOSING) {
            if (inner >= 0.2f) {
                rendererState.frontStrip = new StargateRendererStatic.QuadStrip(8, inner - 0.2f, 3.790975f, Float.valueOf(tick));
            }
        } else {
            rendererState.frontStrip = null;
        }
        if (inner >= kawooshRadius) {
            rendererState.backStrip = new StargateRendererStatic.QuadStrip(8, inner - 0.2f, 3.790975f, Float.valueOf(tick));
        }
        if (inner < 2.5f) {
            if (rendererState.backStripClamp) {
                float argState;
                if (inner < kawooshRadius) {
                    rendererState.backStripClamp = false;
                    rendererState.backStrip = new StargateRendererStatic.QuadStrip(8, kawooshRadius - 0.2f, 3.790975f, null);
                }
                if ((argState = (tick - 5.275f) / 6.0f) < 1.342f) {
                    rendererState.vortexState = EnumVortexState.FORMING;
                } else if (argState < 4.15f) {
                    rendererState.vortexState = EnumVortexState.FULL;
                } else if (argState < 5.898f) {
                    rendererState.vortexState = EnumVortexState.DECREASING;
                } else if (rendererState.vortexState != EnumVortexState.CLOSING) {
                    rendererState.vortexState = EnumVortexState.STILL;
                }
            }
            if (rendererState.frontStripClamp && inner < 0.2f) {
                rendererState.frontStripClamp = false;
                rendererState.frontStrip = new StargateRendererStatic.QuadStrip(8, 0.0f, 3.790975f, null);
            }
            if (rendererState.vortexState != EnumVortexState.STILL) {
                float arg = (tick - 5.275f) / 6.0f;
                if (rendererState.vortexState != EnumVortexState.CLOSING) {
                    if (rendererState.vortexState != EnumVortexState.SHRINKING) {
                        float mul;
                        if (rendererState.vortexState == EnumVortexState.FORMING && arg >= 1.342f) {
                            rendererState.vortexState = EnumVortexState.FULL;
                        }
                        float end = 0.75f;
                        if (rendererState.vortexState == EnumVortexState.DECREASING && (double)arg >= 5.398 + (double)end) {
                            rendererState.vortexState = EnumVortexState.STILL;
                        }
                        if (rendererState.vortexState == EnumVortexState.FULL) {
                            if (arg >= 3.65f + end) {
                                rendererState.vortexState = EnumVortexState.DECREASING;
                            }
                            mul = arg < 2.0f ? (arg - 1.5f) * (arg - 2.5f) / -10.0f + 0.91f : (arg > 3.0f + end ? (arg - 2.5f - end) * (arg - 3.5f - end) / -10.0f + 0.91f : 0.935f);
                        } else {
                            mul = rendererState.vortexState == EnumVortexState.FORMING ? arg * (arg - 4.0f) / -4.0f : (arg - 1.0f - end) * (arg - 5.0f - end) / -5.968f + 0.29333f;
                        }
                        boolean renderWortex = true;
                        if (rendererState instanceof StargateClassicRendererState) {
                            StargateClassicRendererState casted = (StargateClassicRendererState)rendererState;
                            if (casted.irisState == EnumIrisState.CLOSED && casted.irisType != EnumIrisType.NULL) {
                                mul = 0.0f;
                                renderWortex = false;
                            }
                        }
                        if (!rendererState.noxDialing && renderWortex) {
                            this.stack.m_85836_();
                            this.scaleVortex();
                            float prevZ = 0.0f;
                            float prevRad = 0.0f;
                            int index = 0;
                            for (Map.Entry<Float, Float> e : StargateRendererStatic.Z_RadiusMap.entrySet()) {
                                float currentRad;
                                Float currentZ = e.getKey();
                                if (currentZ.floatValue() < 0.0f || currentZ.floatValue() >= 0.0f && mul <= 0.0f) continue;
                                float mulAbs = Math.abs(mul);
                                float f = currentRad = e.getValue().floatValue() == 0.0f ? 0.0f : e.getValue().floatValue() + StargateRendererStatic.getOffset(index, tick, 7.0f, 1);
                                if (index != 0) {
                                    new StargateRendererStatic.QuadStrip(9, currentRad, prevRad, Float.valueOf(tick), 1.4f).render(tick, Float.valueOf(currentZ.floatValue() * mulAbs), Float.valueOf(prevZ * mulAbs), false, Float.valueOf(1.0f - rendererState.whiteOverlayAlpha.floatValue()), 5.0f, false);
                                }
                                prevZ = currentZ.floatValue();
                                prevRad = currentRad;
                                ++index;
                            }
                            this.stack.m_85849_();
                        }
                    } else {
                        long stateChange = rendererState.gateWaitClose + 35L;
                        float arg2 = ((float)(this.level.m_46467_() - stateChange) + this.partialTicks) / 3.0f - 1.0f;
                        rendererState.whiteOverlayAlpha = Float.valueOf(MathHelper.sin(arg2));
                        if (arg2 < 3.890975f) {
                            rendererState.backStrip = new StargateRendererStatic.QuadStrip(8, arg2, 3.790975f, Float.valueOf(tick));
                            rendererState.frontStrip = new StargateRendererStatic.QuadStrip(8, arg2, 3.790975f, Float.valueOf(tick));
                        } else {
                            rendererState.whiteOverlayAlpha = null;
                            if (this.level.m_46467_() - stateChange - 9L > 7L) {
                                rendererState.doEventHorizonRender = false;
                            }
                        }
                    }
                } else if (this.level.m_46467_() - rendererState.gateWaitClose > 35L) {
                    float arg2 = ((float)(this.level.m_46467_() - (rendererState.gateWaitClose + 35L)) + this.partialTicks) / 6.0f / 2.0f;
                    if ((double)arg2 <= 0.5235987755982988) {
                        rendererState.whiteOverlayAlpha = Float.valueOf(MathHelper.sin(arg2));
                    } else {
                        if (rendererState.backStrip == null) {
                            rendererState.backStrip = new StargateRendererStatic.QuadStrip(8, arg2, 3.790975f, Float.valueOf(tick));
                        }
                        if (rendererState.frontStrip == null) {
                            rendererState.frontStrip = new StargateRendererStatic.QuadStrip(8, arg2, 3.790975f, Float.valueOf(tick));
                        }
                        rendererState.vortexState = EnumVortexState.SHRINKING;
                    }
                }
            }
        }
        if (rendererState.vortexState != null && (rendererState.vortexState == EnumVortexState.STILL || rendererState.vortexState == EnumVortexState.CLOSING)) {
            if (rendererState.vortexState == EnumVortexState.CLOSING) {
                this.renderEventHorizon(true, rendererState.whiteOverlayAlpha, false, 1.7f);
            } else {
                this.renderEventHorizon(false, rendererState.horizonUnstable ? Float.valueOf(0.3f) : null, false, rendererState.horizonUnstable ? 1.2f : 1.0f);
            }
            this.stack.m_85849_();
            return;
        }
        if (rendererState.whiteOverlayAlpha != null) {
            if (rendererState.backStrip != null) {
                rendererState.backStrip.render(tick, Float.valueOf(0.0f), Float.valueOf(0.0f), false, Float.valueOf(Math.max(0.0f, 1.0f - rendererState.whiteOverlayAlpha.floatValue() - noxAlpha)), 1.0f);
            }
            if (rendererState.frontStrip != null) {
                if (this.shouldRenderBackVortex()) {
                    this.renderEventHorizon(false, Float.valueOf(0.3f), false, 1.0f, true);
                }
                double tickFromStart = (double)(this.level.m_46467_() - kawooshStart) + (double)this.partialTicks;
                double arg2 = ((tickFromStart - (double)5.275f) / 6.0 - 4.4) / 1.5;
                if (!this.shouldRenderBackVortex() || arg2 <= 0.0) {
                    this.stack.m_85836_();
                    RenderSystem.enableBlend();
                    this.stack.m_252781_(Axis.f_252392_.m_252977_(180.0f));
                    ehTextureRes = this.getEventHorizonTextureResource(rendererState, false);
                    ehTexture = TextureLoader.INSTANCE.getTexture(ehTextureRes);
                    if (ehTexture != null) {
                        ehTexture.bindTexture();
                    }
                    Float alpha = Float.valueOf(Math.max(0.0f, 1.0f - rendererState.whiteOverlayAlpha.floatValue() - 0.3f - noxAlpha));
                    rendererState.frontStrip.render(tick, Float.valueOf(0.0f), Float.valueOf(0.0f), false, alpha, 1.0f);
                    RenderSystem.disableBlend();
                    this.stack.m_85849_();
                }
            }
        }
        this.stack.m_85849_();
    }

    protected void renderEventHorizon(boolean white, Float alpha, boolean backOnly, float mul) {
        this.renderEventHorizon(white, alpha, backOnly, mul, false);
    }

    protected void renderEventHorizon(boolean white, Float alpha, boolean backOnly, float mul, boolean closingAnimation) {
        if (this.getBlackHoleVortexDepth() != 0.0f) {
            this.renderBackVortex(closingAnimation, false, this.getBlackHoleVortexDepth(), this.tileEntity.blackHoleAnimationState.getBackVortexAngle(), this.tileEntity.blackHoleAnimationState.getBackVortexRed());
            return;
        }
        float tick = JSGMinecraftHelper.getClientTick();
        if (!closingAnimation) {
            RenderSystem.enableBlend();
            for (int k = backOnly ? 1 : 0; k < (this.shouldRenderBackVortex() ? 1 : 2); ++k) {
                this.stack.m_85836_();
                if (k == 1) {
                    this.stack.m_252781_(Axis.f_252392_.m_252977_(180.0f));
                }
                if (alpha == null) {
                    alpha = Float.valueOf(0.0f);
                }
                if (k == 1) {
                    alpha = Float.valueOf(alpha.floatValue() + 0.3f);
                }
                if (white) {
                    StargateRendererStatic.innerCircle.render(tick, true, alpha, mul, (byte)0, this.getEventHorizonColor());
                }
                StargateRendererStatic.innerCircle.render(tick, false, Float.valueOf(1.0f - alpha.floatValue()), mul, (byte)0, this.getEventHorizonColor());
                for (StargateRendererStatic.QuadStrip strip : StargateRendererStatic.quadStrips) {
                    if (white) {
                        strip.render(tick, true, alpha, mul, (byte)0, this.getEventHorizonColor());
                    }
                    strip.render(tick, false, Float.valueOf(1.0f - alpha.floatValue()), mul, (byte)0, this.getEventHorizonColor());
                }
                this.stack.m_85849_();
            }
            RenderSystem.disableBlend();
        }
        if (this.shouldRenderBackVortex()) {
            this.renderBackVortex(closingAnimation, true, 1.0f, tick, 0.0f);
        }
    }

    public float getBlackHoleVortexDepth() {
        return this.tileEntity.blackHoleAnimationState.getBackVortexDepth();
    }

    protected void renderBackVortex(boolean closingAnimation, boolean onlyBack, float depthMul, float rotationZ, float redMul) {
        float tick = JSGMinecraftHelper.getClientTick();
        long kawooshStart = ((StargateAbstractRendererState)this.rendererState).gateWaitStart + 44L - 24L;
        double tickFromStart = (double)(this.level.m_46467_() - kawooshStart) + (double)this.partialTicks;
        double arg = ((tickFromStart - (double)5.275f) / 6.0 - 4.4) / 1.5;
        if (arg < 0.0) {
            return;
        }
        float factor = arg > 1.82 ? 1.0f : (float)(-((arg + (double)2.65f) * (arg + (double)2.65f - 4.0) / -5.6746697425842285) + (double)0.63f);
        float mul = 0.3085f * factor * 2.0f * depthMul;
        float[] color = this.getEventHorizonColor();
        Color colorC = new Color((int)(color[0] * 255.0f), (int)(color[1] * 255.0f), (int)(color[2] * 255.0f), 255);
        int mixColors = JSGColorUtil.blendColors(JSGColorUtil.fromColor(colorC), 0xFF00FF, redMul);
        Color finalColor = JSGColorUtil.toColor(mixColors);
        RenderSystem.enableBlend();
        this.stack.m_85836_();
        this.stack.m_252781_(Axis.f_252403_.m_252977_(rotationZ));
        this.scaleVortex();
        for (int i = 0; i < (onlyBack ? 1 : 2); ++i) {
            this.stack.m_85836_();
            if (i == 1) {
                this.stack.m_85841_(1.0f, -1.0f, 1.0f);
            }
            float prevZ = 0.0f;
            float prevRad = 0.0f;
            int index = 0;
            for (Map.Entry<Float, Float> e : StargateRendererStatic.Z_RadiusMap.entrySet()) {
                Float currentZ = e.getKey();
                if (currentZ.floatValue() > 0.0f) continue;
                float currentRad = e.getValue().floatValue() == 0.0f ? 0.0f : e.getValue().floatValue() + StargateRendererStatic.getOffset(index, tick, 7.0f, 1);
                float mul2 = 0.5f * (-currentZ.floatValue() / 5.0f) * (Math.max(0.0f, 1.0f + currentZ.floatValue()) / 2.0f);
                if (currentZ.floatValue() == 0.0f) {
                    currentRad = 3.790975f;
                    mul2 = 0.0f;
                }
                if (((StargateAbstractRendererState)this.rendererState).frontStrip != null && closingAnimation && currentRad < ((StargateAbstractRendererState)this.rendererState).frontStrip.innerRadius) continue;
                if (index != 0) {
                    new StargateRendererStatic.QuadStrip(9, currentRad, prevRad, Float.valueOf(tick), 1.4f * mul2).render(tick, Float.valueOf(currentZ.floatValue() * mul), Float.valueOf(prevZ * mul), false, Float.valueOf(i == 1 ? 1.0f : 0.7f), 5.0f * mul2, false, (byte)0, new float[]{(float)finalColor.getRed() / 255.0f, (float)finalColor.getGreen() / 255.0f, (float)finalColor.getBlue() / 255.0f}, false);
                }
                prevZ = currentZ.floatValue();
                prevRad = currentRad;
                ++index;
            }
            this.stack.m_85849_();
        }
        this.stack.m_85849_();
        RenderSystem.disableBlend();
    }

    protected void renderIris(boolean backOnly) {
    }

    static {
        EH_RENDERED.put(new ResourceLocation("jsg", EV_HORIZON_NORMAL_TEXTURE_ANIMATED), false);
        EH_RENDERED.put(new ResourceLocation("jsg", EV_HORIZON_KAWOOSH_TEXTURE_ANIMATED), false);
        EH_RENDERED.put(new ResourceLocation("jsg", EV_HORIZON_DESATURATED_KAWOOSH_TEXTURE_ANIMATED), false);
        EH_RENDERED.put(new ResourceLocation("jsg", EV_HORIZON_DESATURATED_TEXTURE_ANIMATED), false);
        EH_RENDERED.put(new ResourceLocation("jsg", EV_HORIZON_NORMAL_TEXTURE), false);
        EH_RENDERED.put(new ResourceLocation("jsg", EV_HORIZON_DESATURATED_TEXTURE), false);
    }

    public static enum EnumVortexState {
        FORMING(0),
        FULL(1),
        DECREASING(2),
        STILL(3),
        CLOSING(4),
        SHRINKING(5);

        private static final Map<Integer, EnumVortexState> map;
        public final int index;

        private EnumVortexState(int index) {
            this.index = index;
        }

        public static EnumVortexState valueOf(int index) {
            return map.get(index);
        }

        public boolean equals(EnumVortexState state) {
            return this.index == state.index;
        }

        static {
            map = new HashMap<Integer, EnumVortexState>();
            for (EnumVortexState packet : EnumVortexState.values()) {
                map.put(packet.index, packet);
            }
        }
    }
}

