/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.stargate;

import dev.tauri.jsg.JSG;
import dev.tauri.jsg.config.JSGConfig;
import dev.tauri.jsg.renderer.stargate.ChevronTextureList;
import dev.tauri.jsg.renderer.stargate.StargateAbstractRendererState;
import dev.tauri.jsg.stargate.BiomeOverlayEnum;
import dev.tauri.jsg.stargate.EnumIrisMode;
import dev.tauri.jsg.stargate.EnumIrisState;
import dev.tauri.jsg.stargate.EnumIrisType;
import dev.tauri.jsg.stargate.EnumSpinDirection;
import dev.tauri.jsg.stargate.ISpinHelper;
import dev.tauri.jsg.stargate.StargateClassicSpinHelper;
import dev.tauri.jsg.stargate.StargateSizeEnum;
import dev.tauri.jsg.stargate.network.SymbolInterface;
import dev.tauri.jsg.stargate.network.SymbolTypeEnum;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;

public abstract class StargateClassicRendererState
extends StargateAbstractRendererState {
    public StargateSizeEnum stargateSize = (StargateSizeEnum)((Object)JSGConfig.Stargate.stargateSize.get());
    public ChevronTextureList chevronTextureList;
    public ISpinHelper spinHelper;
    public BiomeOverlayEnum biomeOverride;
    public EnumIrisType irisType;
    public EnumIrisState irisState;
    public long irisAnimation;
    public double irisHeat = 0.0;
    public double gateHeat = 0.0;

    public StargateClassicRendererState() {
    }

    public StargateClassicRendererState(StargateClassicRendererStateBuilder builder) {
        super(builder);
        this.chevronTextureList = new ChevronTextureList(this.getChevronTextureBase(), builder.activeChevrons, builder.isFinalActive);
        this.spinHelper = new StargateClassicSpinHelper(builder.symbolType, builder.currentRingSymbol, builder.spinDirection, builder.isSpinning, builder.targetRingSymbol, builder.spinStartTime, builder.plusRounds);
        this.biomeOverride = builder.biomeOverride;
        this.irisState = builder.irisState;
        this.irisType = builder.irisType;
        this.irisAnimation = builder.irisAnimation;
        this.stargateSize = builder.stargateSize;
    }

    @Override
    public StargateAbstractRendererState initClient(BlockPos pos, BiomeOverlayEnum biomeOverlay) {
        this.chevronTextureList.initClient();
        return super.initClient(pos, biomeOverlay);
    }

    protected abstract String getChevronTextureBase();

    @Override
    public BiomeOverlayEnum getBiomeOverlay() {
        if (this.biomeOverride != null) {
            return this.biomeOverride;
        }
        return super.getBiomeOverlay();
    }

    public void clearChevrons(long time) {
        this.chevronTextureList.clearChevrons(time);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        if (this.stargateSize == null) {
            this.stargateSize = (StargateSizeEnum)((Object)JSGConfig.Stargate.stargateSize.get());
        }
        buf.writeInt(this.stargateSize.id);
        this.chevronTextureList.toBytes(buf);
        this.spinHelper.toBytes(buf);
        if (this.biomeOverride != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.biomeOverride.ordinal());
        } else {
            buf.writeBoolean(false);
        }
        buf.writeByte((int)this.irisState.id);
        buf.writeByte((int)this.irisType.id);
        buf.writeLong(this.irisAnimation);
        buf.writeDouble(this.irisHeat);
        buf.writeDouble(this.gateHeat);
        super.toBytes(buf);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        this.stargateSize = StargateSizeEnum.fromId(buf.readInt());
        this.fromBytes(buf, StargateClassicSpinHelper.class);
    }

    protected void fromBytes(ByteBuf buf, Class<? extends ISpinHelper> type) {
        this.chevronTextureList = new ChevronTextureList(this.getChevronTextureBase());
        this.chevronTextureList.fromBytes(buf);
        try {
            this.spinHelper = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            JSG.logger.error("", (Throwable)e);
        }
        this.spinHelper.fromBytes(buf);
        if (buf.readBoolean()) {
            this.biomeOverride = BiomeOverlayEnum.values()[buf.readInt()];
        }
        this.irisState = EnumIrisState.getValue(buf.readByte());
        this.irisType = EnumIrisType.byId(buf.readByte());
        this.irisAnimation = buf.readLong();
        this.irisHeat = buf.readDouble();
        this.gateHeat = buf.readDouble();
        super.fromBytes(buf);
    }

    public static StargateClassicRendererStateBuilder builder() {
        return new StargateClassicRendererStateBuilder();
    }

    public static class StargateClassicRendererStateBuilder
    extends StargateAbstractRendererState.StargateAbstractRendererStateBuilder {
        protected SymbolTypeEnum<?> symbolType;
        private StargateSizeEnum stargateSize;
        protected int activeChevrons;
        protected boolean isFinalActive;
        protected SymbolInterface currentRingSymbol;
        protected EnumSpinDirection spinDirection;
        protected boolean isSpinning;
        protected SymbolInterface targetRingSymbol;
        protected long spinStartTime;
        protected int plusRounds;
        public BiomeOverlayEnum biomeOverride;
        public EnumIrisState irisState;
        public EnumIrisType irisType;
        public String irisCode;
        public EnumIrisMode irisMode;
        public long irisAnimation;

        public StargateClassicRendererStateBuilder() {
        }

        public StargateClassicRendererStateBuilder(StargateAbstractRendererState.StargateAbstractRendererStateBuilder superBuilder) {
            this.setStargateState(superBuilder.stargateState);
        }

        public StargateClassicRendererStateBuilder setStargateSize(StargateSizeEnum stargateSize) {
            this.stargateSize = stargateSize;
            return this;
        }

        public StargateClassicRendererStateBuilder setSymbolType(SymbolTypeEnum<?> symbolType) {
            this.symbolType = symbolType;
            return this;
        }

        public StargateClassicRendererStateBuilder setActiveChevrons(int activeChevrons) {
            this.activeChevrons = activeChevrons;
            return this;
        }

        public StargateClassicRendererStateBuilder setFinalActive(boolean isFinalActive) {
            this.isFinalActive = isFinalActive;
            return this;
        }

        public StargateClassicRendererStateBuilder setCurrentRingSymbol(SymbolInterface currentRingSymbol) {
            this.currentRingSymbol = currentRingSymbol;
            return this;
        }

        public StargateClassicRendererStateBuilder setSpinDirection(EnumSpinDirection spinDirection) {
            this.spinDirection = spinDirection;
            return this;
        }

        public StargateClassicRendererStateBuilder setSpinning(boolean isSpinning) {
            this.isSpinning = isSpinning;
            return this;
        }

        public StargateClassicRendererStateBuilder setTargetRingSymbol(SymbolInterface targetRingSymbol) {
            this.targetRingSymbol = targetRingSymbol;
            return this;
        }

        public StargateClassicRendererStateBuilder setSpinStartTime(long spinStartTime) {
            this.spinStartTime = spinStartTime;
            return this;
        }

        public StargateClassicRendererStateBuilder setBiomeOverride(BiomeOverlayEnum biomeOverride) {
            this.biomeOverride = biomeOverride;
            return this;
        }

        public StargateClassicRendererStateBuilder setIrisState(EnumIrisState irisState) {
            this.irisState = irisState;
            return this;
        }

        public StargateClassicRendererStateBuilder setIrisType(EnumIrisType irisType) {
            this.irisType = irisType;
            return this;
        }

        public StargateClassicRendererStateBuilder setIrisCode(String code) {
            this.irisCode = code;
            return this;
        }

        public StargateClassicRendererStateBuilder setIrisMode(EnumIrisMode mode) {
            this.irisMode = mode;
            return this;
        }

        public StargateClassicRendererStateBuilder setIrisAnimation(long irisAnimation) {
            this.irisAnimation = irisAnimation;
            return this;
        }

        public void setPlusRounds(int rounds) {
            this.plusRounds = rounds;
        }
    }
}

