/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.stargate;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.tauri.jsg.helpers.BlockPosHelper;
import dev.tauri.jsg.loader.ElementEnum;
import dev.tauri.jsg.loader.model.ModelLoader;
import dev.tauri.jsg.property.JSGProperties;
import dev.tauri.jsg.renderer.stargate.StargateAbstractRenderer;
import dev.tauri.jsg.renderer.stargate.StargateOrlinRendererState;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.properties.Property;

public class StargateOrlinRenderer
extends StargateAbstractRenderer<StargateOrlinRendererState> {
    public static final float GATE_SCALE = 2.3f;
    public static final Map<Integer, TranslationInterface> LIGHT_BULBS_TRANSLATIONS = new HashMap<Integer, TranslationInterface>(){
        {
            this.put(0, stack -> {});
            this.put(1, stack -> {
                stack.m_252880_(0.0f, 0.0f, 0.0f);
                stack.m_252781_(Axis.f_252403_.m_252977_(-51.8f));
            });
            this.put(2, stack -> {
                stack.m_252880_(0.003f, 0.0f, 0.0f);
                stack.m_252781_(Axis.f_252403_.m_252977_(-103.3f));
            });
            this.put(3, stack -> {
                stack.m_252880_(0.0f, -0.004f, 0.0f);
                stack.m_252781_(Axis.f_252403_.m_252977_(-154.4f));
            });
            this.put(4, stack -> {
                stack.m_252880_(0.0f, -0.004f, 0.0f);
                stack.m_252781_(Axis.f_252403_.m_252977_(-206.0f));
            });
            this.put(5, stack -> {
                stack.m_252880_(-0.002f, -0.004f, 0.0f);
                stack.m_252781_(Axis.f_252403_.m_252977_(-257.5f));
            });
            this.put(6, stack -> stack.m_252781_(Axis.f_252403_.m_252977_(51.3f)));
        }
    };

    public StargateOrlinRenderer(BlockEntityRendererProvider.Context ignored) {
        super(ignored);
    }

    @Override
    protected void applyTransformations() {
        this.stack.m_85837_(0.5, 1.7, 0.5);
        this.stack.m_85841_(2.3f, 2.3f, 2.3f);
    }

    public boolean isBroken() {
        return this.tileEntity.getCurrentBlockState().m_61138_((Property)JSGProperties.ORLIN_BROKEN) && (Boolean)this.tileEntity.getCurrentBlockState().m_61143_((Property)JSGProperties.ORLIN_BROKEN) != false;
    }

    public boolean renderStand() {
        return this.tileEntity.getFacingVertical() == Direction.SOUTH && !this.level.m_8055_(this.tileEntity.m_58899_().m_7495_()).m_60795_();
    }

    public boolean renderInsulator(int index) {
        Direction facingH = this.tileEntity.getFacing();
        Direction facingV = this.tileEntity.getFacingVertical();
        BlockPos insulatorSupportBlock = BlockPos.f_121853_;
        if (index == 0) {
            insulatorSupportBlock = new BlockPos(1, 3, 0);
        } else if (index == 1) {
            insulatorSupportBlock = new BlockPos(2, 0, 0);
        } else if (index == 2) {
            insulatorSupportBlock = new BlockPos(-2, 0, 0);
        } else if (index == 3) {
            insulatorSupportBlock = new BlockPos(-1, 3, 0);
        } else {
            return false;
        }
        insulatorSupportBlock = BlockPosHelper.rotate(insulatorSupportBlock, facingH, facingV).m_121955_((Vec3i)this.tileEntity.m_58899_());
        return !this.level.m_8055_(insulatorSupportBlock).m_60795_();
    }

    @Override
    protected void renderGate() {
        this.stack.m_85836_();
        boolean isBroken = this.isBroken();
        if (!isBroken) {
            int i;
            this.stack.m_85836_();
            ElementEnum.ORLIN_GATE.bindTextureAndRender(((StargateOrlinRendererState)this.rendererState).getBiomeOverlay(), this.stack);
            this.stack.m_85849_();
            for (i = 0; i < 4; ++i) {
                if (!this.renderInsulator(i)) continue;
                this.stack.m_85836_();
                this.stack.m_252781_(Axis.f_252403_.m_252977_((float)(-90 * i)));
                ModelLoader.INSTANCE.getModel(ModelLoader.INSTANCE.getModelResource("orlin/orlin_coil.obj")).render(this.stack);
                this.stack.m_85849_();
            }
            for (i = 0; i < 7; ++i) {
                this.stack.m_85836_();
                LIGHT_BULBS_TRANSLATIONS.get(i).translate(this.stack);
                ModelLoader.INSTANCE.getModel(ModelLoader.INSTANCE.getModelResource("orlin/orlin_gate_light.obj")).render(this.stack, true);
                this.stack.m_85849_();
            }
        } else {
            ElementEnum.ORLIN_GATE_BURNT.bindTextureAndRender(((StargateOrlinRendererState)this.rendererState).getBiomeOverlay(), this.stack);
        }
        if (this.renderStand()) {
            this.stack.m_85836_();
            this.stack.m_85837_(0.0, -0.75, 0.21);
            ElementEnum.ORLIN_STAND.bindTextureAndRender(((StargateOrlinRendererState)this.rendererState).getBiomeOverlay(), this.stack);
            this.stack.m_85849_();
        }
        this.stack.m_85849_();
    }

    @Override
    protected void renderKawoosh() {
        this.stack.m_85837_(0.0, 0.008729801177978516, 0.0);
        this.stack.m_85841_(0.13f, 0.13f, 0.13f);
        super.renderKawoosh();
    }

    public static interface TranslationInterface {
        public void translate(PoseStack var1);
    }
}

