/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.stargate;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.tauri.jsg.loader.ElementEnum;
import dev.tauri.jsg.loader.model.OBJModel;
import dev.tauri.jsg.loader.texture.Texture;
import dev.tauri.jsg.loader.texture.TextureLoader;
import dev.tauri.jsg.renderer.EmissiveRenderer;
import dev.tauri.jsg.renderer.stargate.ChevronEnum;
import dev.tauri.jsg.renderer.stargate.StargateClassicRenderer;
import dev.tauri.jsg.renderer.stargate.StargatePegasusRendererState;
import dev.tauri.jsg.stargate.network.SymbolTypeRegistry;
import dev.tauri.jsg.util.math.NumberUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import org.joml.Matrix4f;

public class StargatePegasusRenderer
extends StargateClassicRenderer<StargatePegasusRendererState> {
    public static final float GATE_DIAMETER = 10.1815f;
    private static final int GLYPHS_COUNT = 36;
    private static final Map<Integer, VertexBuffer> SYMBOLS_MODEL_CACHE = new HashMap<Integer, VertexBuffer>();

    public StargatePegasusRenderer(BlockEntityRendererProvider.Context ignored) {
        super(ignored);
    }

    @Override
    public float getGateDiameter() {
        return 10.1815f;
    }

    @Override
    public double getScaleMultiplier() {
        return 1.0;
    }

    @Override
    protected void renderGate() {
        double tick;
        int index;
        this.stack.m_85836_();
        ElementEnum.PEGASUS_GATE.bindTextureAndRender(((StargatePegasusRendererState)this.rendererState).getBiomeOverlay(), this.stack);
        this.stack.m_85849_();
        this.renderRing();
        this.renderChevrons();
        this.stack.m_85836_();
        if (((StargatePegasusRendererState)this.rendererState).spinHelper.getIsSpinning() && !((StargatePegasusRendererState)this.rendererState).slotToGlyphMap.containsKey(index = (int)Math.floor(((StargatePegasusRendererState)this.rendererState).spinHelper.apply(tick = (double)((float)this.level.m_46467_() + this.partialTicks))))) {
            this.renderGlyph(((StargatePegasusRendererState)this.rendererState).spinHelper.getTargetSymbol().getId(), index, false);
        }
        for (int i = 0; i < 38; ++i) {
            if (!((StargatePegasusRendererState)this.rendererState).slotToGlyphMap.containsKey(i) && i < 36) {
                if (((StargatePegasusRendererState)this.rendererState).spinHelper.getIsSpinning() || !((StargatePegasusRendererState)this.rendererState).slotToGlyphMap.isEmpty()) continue;
                this.renderGlyph(i, i, true);
                continue;
            }
            if (!((StargatePegasusRendererState)this.rendererState).slotToGlyphMap.containsKey(i) && i >= 36) continue;
            this.renderGlyph(((StargatePegasusRendererState)this.rendererState).slotToGlyphMap.get(i), i, false);
        }
        this.stack.m_85849_();
    }

    private void renderRing() {
        this.stack.m_85836_();
        if (ElementEnum.PEGASUS_RING.model != null && ElementEnum.PEGASUS_RING.biomeTextureResourceMap.get(((StargatePegasusRendererState)this.rendererState).getBiomeOverlay()) != null) {
            ElementEnum.PEGASUS_RING.bindTextureAndRender(((StargatePegasusRendererState)this.rendererState).getBiomeOverlay(), this.stack);
        }
        this.stack.m_85849_();
    }

    @Override
    protected void renderChevron(ChevronEnum chevron, boolean onlyLight) {
        this.stack.m_85836_();
        this.stack.m_252781_(Axis.f_252403_.m_252977_((float)chevron.rotation));
        boolean renderEmissive = onlyLight && ((StargatePegasusRendererState)this.rendererState).chevronTextureList.getState(chevron) > 2;
        Texture chevronTexture = TextureLoader.INSTANCE.getTexture(((StargatePegasusRendererState)this.rendererState).chevronTextureList.get(((StargatePegasusRendererState)this.rendererState).getBiomeOverlay(), chevron, onlyLight));
        if (chevronTexture != null) {
            chevronTexture.bindTexture();
            if (chevron.isFinal()) {
                float chevronOffset = 0.0f;
                this.stack.m_85836_();
                this.stack.m_252880_(0.0f, chevronOffset, 0.0f);
                ElementEnum.PEGASUS_CHEVRON_LIGHT.render(this.stack, renderEmissive);
                this.stack.m_252880_(0.0f, -2.0f * chevronOffset, 0.0f);
                ElementEnum.PEGASUS_CHEVRON_MOVING.render(this.stack, renderEmissive);
                this.stack.m_85849_();
            } else {
                ElementEnum.PEGASUS_CHEVRON_MOVING.render(this.stack, renderEmissive);
                ElementEnum.PEGASUS_CHEVRON_LIGHT.render(this.stack, renderEmissive);
            }
            if (!onlyLight) {
                ElementEnum.PEGASUS_CHEVRON_FRAME.bindTextureAndRender(((StargatePegasusRendererState)this.rendererState).getBiomeOverlay(), this.stack);
                ElementEnum.PEGASUS_CHEVRON_BACK.render(this.stack);
            }
            this.stack.m_85849_();
            OBJModel.resetRGB();
        }
    }

    private double[] getPositionInRingAtIndex(double radius, int index) {
        double deg = 10.0 * (double)index;
        double rad = Math.toRadians(deg);
        return new double[]{radius * Math.cos(rad), radius * Math.sin(rad), deg};
    }

    protected void renderGlyph(int glyphId, int slot, boolean deactivated) {
        this.renderGlyph(glyphId, slot, deactivated, false);
        if (deactivated) {
            this.renderGlyph(glyphId, slot, false, true);
        }
    }

    protected void renderGlyph(int glyphId, int slot, boolean deactivated, boolean translatePos) {
        if (OBJModel.renderType != OBJModel.EnumOBJRenderMethod.NORMAL) {
            this.renderGlyphGUI(glyphId, slot, deactivated, translatePos);
            return;
        }
        VertexBuffer vertexBuffer = SYMBOLS_MODEL_CACHE.get(glyphId);
        double radius = 0.94;
        int textureSlot = SymbolTypeRegistry.PEGASUS.valueOf((int)glyphId).textureSlot;
        double[] uv = this.getPositionInRingAtIndex(radius, -textureSlot);
        float x = (float)((uv[0] + radius) / 2.0);
        float y = (float)((uv[1] + radius) / 2.0);
        float tileSize = 0.27f;
        float uvSize = 0.0625f;
        if (vertexBuffer == null) {
            vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder buffer = tessellator.m_85915_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            buffer.m_5483_((double)(-tileSize), 0.0, (double)(-tileSize)).m_7421_(x, y).m_5752_();
            buffer.m_5483_((double)(-tileSize), 0.0, (double)tileSize).m_7421_(x, y + uvSize).m_5752_();
            buffer.m_5483_((double)tileSize, 0.0, (double)tileSize).m_7421_(x + uvSize, y + uvSize).m_5752_();
            buffer.m_5483_((double)tileSize, 0.0, (double)(-tileSize)).m_7421_(x + uvSize, y).m_5752_();
            BufferBuilder.RenderedBuffer rb = buffer.m_231175_();
            vertexBuffer.m_85921_();
            vertexBuffer.m_231221_(rb);
            VertexBuffer.m_85931_();
        }
        VertexBuffer finalVertexBuffer = vertexBuffer;
        EmissiveRenderer.renderWithLightOverlay(this.stack, false, () -> {
            String path = String.format("pegasus/%s.png", deactivated ? "glyphs_off" : "glyphs");
            Texture.bindTextureWithMc(TextureLoader.INSTANCE.getTextureResource(path));
            finalVertexBuffer.m_85921_();
        }, () -> {
            double[] slotPos = this.getPositionInRingAtIndex(4.2407502174377445, slot);
            this.stack.m_85837_(NumberUtils.round(slotPos[0], 3), NumberUtils.round(slotPos[1], 3), translatePos ? -0.105 : 0.205);
            this.stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            this.stack.m_252781_(Axis.f_252436_.m_252977_(10.0f * (float)(slot - textureSlot) + 180.0f));
            Matrix4f projection = RenderSystem.getProjectionMatrix();
            Matrix4f matrix = this.stack.m_85850_().m_252922_();
            finalVertexBuffer.m_253207_(matrix, projection, Objects.requireNonNull(RenderSystem.getShader()));
            VertexBuffer.m_85931_();
        }, GameRenderer::m_172747_);
        SYMBOLS_MODEL_CACHE.put(glyphId, vertexBuffer);
    }

    protected void renderGlyphGUI(int glyphId, int slot, boolean deactivated, boolean translatePos) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        EmissiveRenderer.renderWithLightOverlay(this.stack, false, () -> {
            String path = String.format("pegasus/%s.png", deactivated ? "glyphs_off" : "glyphs");
            Texture.bindTextureWithMc(TextureLoader.INSTANCE.getTextureResource(path));
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        }, () -> {
            double[] slotPos = this.getPositionInRingAtIndex(4.2407502174377445, slot);
            double radius = 0.94;
            int textureSlot = SymbolTypeRegistry.PEGASUS.valueOf((int)glyphId).textureSlot;
            double[] uv = this.getPositionInRingAtIndex(radius, -textureSlot);
            float x = (float)((uv[0] + radius) / 2.0);
            float y = (float)((uv[1] + radius) / 2.0);
            float tileSize = 0.27f;
            float uvSize = 0.0625f;
            this.stack.m_85837_(NumberUtils.round(slotPos[0], 3), NumberUtils.round(slotPos[1], 3), translatePos ? -0.105 : 0.205);
            this.stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            this.stack.m_252781_(Axis.f_252436_.m_252977_(10.0f * (float)(slot - textureSlot) + 180.0f));
            Matrix4f matrix = this.stack.m_85850_().m_252922_();
            buffer.m_252986_(matrix, -tileSize, 0.0f, -tileSize).m_7421_(x, y).m_5752_();
            buffer.m_252986_(matrix, -tileSize, 0.0f, tileSize).m_7421_(x, y + uvSize).m_5752_();
            buffer.m_252986_(matrix, tileSize, 0.0f, tileSize).m_7421_(x + uvSize, y + uvSize).m_5752_();
            buffer.m_252986_(matrix, tileSize, 0.0f, -tileSize).m_7421_(x + uvSize, y).m_5752_();
            tessellator.m_85914_();
        }, OBJModel.renderType != OBJModel.EnumOBJRenderMethod.NORMAL ? GameRenderer::m_172817_ : GameRenderer::m_172747_);
    }
}

