/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.renderer.stargate;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.tauri.jsg.config.JSGConfig;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class StargateRendererStatic {
    public static PoseStack currentStack;
    public static final float EVENT_HORIZON_RADIUS = 3.790975f;
    private static final int QUADS;
    private static final int SECTIONS;
    private static final float SECTION_ANGLE;
    public static final float INNER_CIRCLE_RADIUS = 0.25f;
    private static final float QUAD_STEP;
    private static final List<Float> OFFSET_LIST;
    private static final List<Float> SIN;
    private static final List<Float> COS;
    private static final List<Float> QUAD_RADIUS;
    static InnerCircle innerCircle;
    static List<QuadStrip> quadStrips;
    private static final Random RANDOM;
    static final float kawooshRadius = 2.5f;
    private static final float kawooshSize = 9.0f;
    private static final int kawooshSections = 36;
    static Map<Float, Float> Z_RadiusMap;

    private static float getRandomFloat() {
        return RANDOM.nextFloat() * 2.0f - 1.0f;
    }

    public static float getOffset(int index, float tick, float mul, int quadStripIndex) {
        return (float)(Math.sin(tick / 4.0f + OFFSET_LIST.get(index).floatValue()) * (double)mul * (double)((float)quadStripIndex / 4.0f) * (double)(quadStripIndex - quadStrips.size()) / 400.0);
    }

    private static float toUV(float coord) {
        return (coord + 1.0f) / 2.0f;
    }

    private static void initEventHorizon() {
        int i;
        for (i = 0; i < SECTIONS * (QUADS + 1); ++i) {
            OFFSET_LIST.add(Float.valueOf(StargateRendererStatic.getRandomFloat() * 3.0f));
        }
        for (i = 0; i <= SECTIONS; ++i) {
            SIN.add(Float.valueOf((float)Math.sin(SECTION_ANGLE * (float)i)));
            COS.add(Float.valueOf((float)Math.cos(SECTION_ANGLE * (float)i)));
        }
        innerCircle = new InnerCircle();
        for (i = 0; i <= QUADS; ++i) {
            QUAD_RADIUS.add(Float.valueOf(0.25f + QUAD_STEP * (float)i));
        }
        for (i = 0; i < QUADS; ++i) {
            quadStrips.add(new QuadStrip(i));
        }
    }

    public static void computeFaceNormalTri(@NotNull Vector3f saveTo, float x0, float y0, float z0, float x1, float y1, float z1, float x2, float y2, float z2) {
        float dy0 = y2 - y0;
        float dz1 = z0 - z1;
        float dz0 = z2 - z0;
        float dy1 = y0 - y1;
        float normX = dy0 * dz1 - dz0 * dy1;
        float dx1 = x0 - x1;
        float dx0 = x2 - x0;
        float normY = dz0 * dx1 - dx0 * dz1;
        float normZ = dx0 * dy1 - dy0 * dx1;
        float l = (float)Math.sqrt(normX * normX + normY * normY + normZ * normZ);
        if (l != 0.0f) {
            normX /= l;
            normY /= l;
            normZ /= l;
        }
        saveTo.set(normX, normY, normZ);
    }

    private static void initKawoosh() {
        int i;
        Z_RadiusMap = new LinkedHashMap<Float, Float>();
        float wortexLengthRange = 0.509f;
        float step = wortexLengthRange / 36.0f;
        float scaleZ = 9.0f / wortexLengthRange;
        float scaleY = 18.754688f;
        boolean soundStart = false;
        for (i = 36; i >= 0; --i) {
            float zPrev = step * (float)(i + 1);
            float z = step * (float)i;
            float y = 0.195f / (z * 5.0f + 0.8f) - 0.05f;
            if (i == 36) {
                y = 0.0f;
            }
            if (y < 0.0f) {
                y = 0.0f;
            }
            if (y == 0.0f) continue;
            if (!soundStart) {
                soundStart = true;
                Z_RadiusMap.put(Float.valueOf(-zPrev * scaleZ), Float.valueOf(0.0f));
            }
            Z_RadiusMap.put(Float.valueOf(-z * scaleZ), Float.valueOf(y * scaleY));
        }
        for (i = 0; i <= 36; ++i) {
            float z = step * (float)i;
            float y = 0.0f;
            if (z <= 0.1f) {
                y = (float)(-Math.sqrt(0.01 - Math.pow((double)z - 0.1, 2.0))) + 0.19f;
            } else if (z <= 0.4f) {
                y = (float)(Math.sin(-z * 13.0f) / 92.0 + (double)0.1f);
            } else if (z <= wortexLengthRange) {
                y = (float)Math.sqrt(0.012 - Math.pow((double)z - 0.4, 2.0));
            }
            if (i == 36) {
                y = 0.0f;
            }
            if (y < 0.0f) {
                y = 0.0f;
            }
            Z_RadiusMap.put(Float.valueOf(z * scaleZ), Float.valueOf(y * scaleY));
        }
    }

    static {
        QUADS = (Integer)JSGConfig.Stargate.eventHorizonRenderQuads.get();
        SECTIONS = (Integer)JSGConfig.Stargate.eventHorizonRenderSections.get();
        SECTION_ANGLE = (float)(Math.PI * 2 / (double)SECTIONS);
        QUAD_STEP = 3.540975f / (float)QUADS;
        OFFSET_LIST = new ArrayList<Float>();
        SIN = new ArrayList<Float>();
        COS = new ArrayList<Float>();
        QUAD_RADIUS = new ArrayList<Float>();
        quadStrips = new ArrayList<QuadStrip>();
        RANDOM = new Random();
        StargateRendererStatic.initEventHorizon();
        StargateRendererStatic.initKawoosh();
    }

    public static class InnerCircle {
        private final List<Float> x = new ArrayList<Float>();
        private final List<Float> y = new ArrayList<Float>();
        private final List<Float> tx = new ArrayList<Float>();
        private final List<Float> ty = new ArrayList<Float>();
        private final Vector3f cache = new Vector3f();

        public InnerCircle() {
            float texMul = 0.065946095f;
            for (int i = 0; i < SECTIONS; ++i) {
                this.x.add(Float.valueOf(SIN.get(i).floatValue() * 0.25f));
                this.y.add(Float.valueOf(COS.get(i).floatValue() * 0.25f));
                this.tx.add(Float.valueOf(StargateRendererStatic.toUV(SIN.get(i).floatValue() * texMul)));
                this.ty.add(Float.valueOf(StargateRendererStatic.toUV(COS.get(i).floatValue() * texMul)));
            }
        }

        public void render(float tick, boolean white, Float alpha, float mul) {
            this.render(tick, white, alpha, mul, (byte)0);
        }

        public void render(float tick, boolean white, Float alpha, float mul, byte animationOverride) {
            this.render(tick, white, alpha, mul, animationOverride, new float[]{1.0f, 1.0f, 1.0f});
        }

        public void render(float tick, boolean white, Float alpha, float mul, byte animationOverride, float[] color) {
            boolean animated;
            RenderSystem.enableDepthTest();
            RenderSystem.enableCull();
            boolean bl = animated = animationOverride != -1;
            if (white && alpha.floatValue() > 0.5f) {
                alpha = Float.valueOf(1.0f - alpha.floatValue());
            }
            Tesselator t = Tesselator.m_85913_();
            BufferBuilder b = t.m_85915_();
            Matrix4f matrix = currentStack.m_85850_().m_252922_();
            RenderSystem.setShader(GameRenderer::m_172700_);
            b.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85812_);
            int texIndex = (int)(tick * 4.0f % 185.0f);
            float xTexOffset = (float)(texIndex % 14) / 14.0f;
            float yTexOffset = (float)(texIndex / 14) / 14.0f;
            float xTex = 0.5f;
            float yTex = 0.5f;
            if (animated) {
                xTex /= 14.0f;
                xTex += xTexOffset;
                yTex /= 14.0f;
                yTex += yTexOffset;
            } else {
                yTex *= -1.0f;
            }
            b.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(color[0], color[1], color[2], alpha != null ? alpha.floatValue() : 1.0f).m_7421_(xTex, yTex).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            for (int i = SECTIONS; i >= 0; --i) {
                int index = i == SECTIONS ? 0 : i;
                if (i % 3 == 0) {
                    StargateRendererStatic.computeFaceNormalTri(this.cache, this.x.get(index).floatValue(), this.y.get(index).floatValue(), StargateRendererStatic.getOffset(index, tick * mul, mul, 0), this.x.get(index + 1).floatValue(), this.y.get(index + 1).floatValue(), StargateRendererStatic.getOffset(index + 1, tick * mul, mul, 0), this.x.get(index + 2).floatValue(), this.y.get(index + 2).floatValue(), StargateRendererStatic.getOffset(index + 2, tick * mul, mul, 0));
                }
                xTex = this.tx.get(index).floatValue();
                yTex = this.ty.get(index).floatValue();
                if (animated) {
                    xTex /= 14.0f;
                    xTex += xTexOffset;
                    yTex /= 14.0f;
                    yTex += yTexOffset;
                } else {
                    yTex *= -1.0f;
                }
                b.m_252986_(matrix, this.x.get(index).floatValue(), this.y.get(index).floatValue(), StargateRendererStatic.getOffset(index, tick * mul, mul, 0)).m_85950_(color[0], color[1], color[2], alpha != null ? alpha.floatValue() : 1.0f).m_7421_(xTex, yTex).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(currentStack.m_85850_().m_252943_(), this.cache.x, this.cache.y, this.cache.z).m_5752_();
            }
            t.m_85914_();
            RenderSystem.disableDepthTest();
            RenderSystem.disableCull();
        }
    }

    public static class QuadStrip {
        private final List<Float> x = new ArrayList<Float>();
        private final List<Float> y = new ArrayList<Float>();
        private final List<Float> tx = new ArrayList<Float>();
        private final List<Float> ty = new ArrayList<Float>();
        private final int quadStripIndex;
        private final float radMul;
        public final float innerRadius;
        Vector3f cache = new Vector3f();

        public QuadStrip(int quadStripIndex) {
            this(quadStripIndex, QUAD_RADIUS.get(quadStripIndex).floatValue(), QUAD_RADIUS.get(quadStripIndex + 1).floatValue(), null);
        }

        public QuadStrip(int quadStripIndex, float innerRadius, float outerRadius, Float tick) {
            this(quadStripIndex, innerRadius, outerRadius, tick, 1.0f);
        }

        public QuadStrip(int quadStripIndex, float innerRadius, float outerRadius, Float tick, float radMul) {
            this.quadStripIndex = quadStripIndex;
            this.radMul = radMul;
            this.innerRadius = innerRadius;
            this.recalculate(innerRadius, outerRadius, tick);
        }

        public void recalculate(float innerRadius, float outerRadius, Float tick) {
            ArrayList<Float> radius = new ArrayList<Float>();
            ArrayList<Float> texMul = new ArrayList<Float>();
            radius.add(Float.valueOf(innerRadius));
            radius.add(Float.valueOf(outerRadius));
            for (int i = 0; i < 2; ++i) {
                texMul.add(Float.valueOf(((Float)radius.get(i)).floatValue() / 3.790975f));
            }
            for (int k = 0; k < 2; ++k) {
                for (int i = 0; i < SECTIONS; ++i) {
                    float rad = ((Float)radius.get(k)).floatValue();
                    if (tick != null) {
                        rad = this.quadStripIndex == 9 ? (rad += StargateRendererStatic.getOffset(i, tick.floatValue(), 5.0f * this.radMul, this.quadStripIndex) * 0.75f) : (rad += StargateRendererStatic.getOffset(i, tick.floatValue(), 1.0f * this.radMul, this.quadStripIndex) * 2.0f);
                    }
                    this.x.add(Float.valueOf(rad * SIN.get(i).floatValue()));
                    this.y.add(Float.valueOf(rad * COS.get(i).floatValue()));
                    this.tx.add(Float.valueOf(StargateRendererStatic.toUV(SIN.get(i).floatValue() * ((Float)texMul.get(k)).floatValue())));
                    this.ty.add(Float.valueOf(StargateRendererStatic.toUV(COS.get(i).floatValue() * ((Float)texMul.get(k)).floatValue())));
                }
            }
        }

        public void render(float tick, boolean white, Float alpha, float mul) {
            this.render(tick, null, null, white, alpha, mul);
        }

        public void render(float tick, boolean white, Float alpha, float mul, byte animationOverride) {
            this.render(tick, null, null, white, alpha, mul, false, animationOverride);
        }

        public void render(float tick, boolean white, Float alpha, float mul, byte animationOverride, float[] color) {
            this.render(tick, null, null, white, alpha, mul, false, animationOverride, color, false);
        }

        public void render(float tick, Float outerZ, Float innerZ, boolean white, Float alpha, float mul) {
            this.render(tick, outerZ, innerZ, white, alpha, mul, false, (byte)0);
        }

        public void render(float tick, Float outerZ, Float innerZ, boolean white, Float alpha, float mul, boolean offsetZ) {
            this.render(tick, outerZ, innerZ, white, alpha, mul, false, (byte)0, new float[]{1.0f, 1.0f, 1.0f}, offsetZ);
        }

        public void render(float tick, Float outerZ, Float innerZ, boolean white, Float alpha, float mul, boolean reversed, byte animationOverride) {
            this.render(tick, outerZ, innerZ, white, alpha, mul, reversed, animationOverride, new float[]{1.0f, 1.0f, 1.0f}, false);
        }

        public void render(float tick, Float outerZ, Float innerZ, boolean white, Float alpha, float mul, boolean reversed, byte animationOverride, float[] color, boolean offsetZ) {
            int i;
            boolean animate;
            boolean bl = animate = animationOverride != -1;
            if (white && alpha.floatValue() > 0.5f) {
                alpha = Float.valueOf(1.0f - alpha.floatValue());
            }
            RenderSystem.setShader(GameRenderer::m_172700_);
            Tesselator t = Tesselator.m_85913_();
            BufferBuilder b = t.m_85915_();
            Matrix4f matrix = currentStack.m_85850_().m_252922_();
            RenderSystem.enableDepthTest();
            RenderSystem.enableCull();
            b.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85812_);
            int texIndex = (int)(tick * 4.0f % 185.0f);
            float xTexOffset = (float)(texIndex % 14) / 14.0f;
            float yTexOffset = (float)(texIndex / 14) / 14.0f;
            int n = i = reversed ? 0 : SECTIONS;
            while (reversed && i <= SECTIONS || !reversed && i >= 0) {
                int index = i == SECTIONS ? 0 : i;
                if (i % 3 == 0) {
                    StargateRendererStatic.computeFaceNormalTri(this.cache, this.x.get(index).floatValue(), this.y.get(index).floatValue(), StargateRendererStatic.getOffset(index + SECTIONS * this.quadStripIndex, tick * mul, mul, this.quadStripIndex), this.x.get(index + 1).floatValue(), this.y.get(index + 1).floatValue(), StargateRendererStatic.getOffset(index + 1 + SECTIONS * this.quadStripIndex, tick * mul, mul, this.quadStripIndex), this.x.get(index + 2).floatValue(), this.y.get(index + 2).floatValue(), StargateRendererStatic.getOffset(index + 2 + SECTIONS * this.quadStripIndex, tick * mul, mul, this.quadStripIndex));
                }
                float z = outerZ != null ? outerZ.floatValue() : StargateRendererStatic.getOffset(index + SECTIONS * this.quadStripIndex, tick * mul, mul, this.quadStripIndex);
                if (offsetZ) {
                    z += StargateRendererStatic.getOffset(index, tick * mul, mul, this.quadStripIndex);
                }
                float xTex = this.tx.get(index).floatValue();
                float yTex = this.ty.get(index).floatValue();
                if (animate) {
                    xTex /= 14.0f;
                    xTex += xTexOffset;
                    yTex /= 14.0f;
                    yTex += yTexOffset;
                } else {
                    yTex *= -1.0f;
                }
                b.m_252986_(matrix, this.x.get(index).floatValue(), this.y.get(index).floatValue(), z).m_85950_(color[0], color[1], color[2], alpha != null ? alpha.floatValue() : 1.0f).m_7421_(xTex, yTex).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(currentStack.m_85850_().m_252943_(), this.cache.x, this.cache.y, this.cache.z).m_5752_();
                xTex = this.tx.get(index += SECTIONS).floatValue();
                yTex = this.ty.get(index).floatValue();
                if (animate) {
                    xTex /= 14.0f;
                    xTex += xTexOffset;
                    yTex /= 14.0f;
                    yTex += yTexOffset;
                } else {
                    yTex *= -1.0f;
                }
                z = innerZ != null ? innerZ.floatValue() : StargateRendererStatic.getOffset(index + SECTIONS * this.quadStripIndex, tick * mul, mul, this.quadStripIndex + 1);
                b.m_252986_(matrix, this.x.get(index).floatValue(), this.y.get(index).floatValue(), z).m_85950_(color[0], color[1], color[2], alpha != null ? alpha.floatValue() : 1.0f).m_7421_(xTex, yTex).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(currentStack.m_85850_().m_252943_(), this.cache.x, this.cache.y, this.cache.z).m_5752_();
                i += reversed ? 1 : -1;
            }
            t.m_85914_();
            RenderSystem.disableDepthTest();
            RenderSystem.disableCull();
        }
    }
}

