/*
 * Decompiled with CFR 0.152.
 */
package dev.tauri.jsg.screen.element;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tauri.jsg.loader.texture.Texture;
import dev.tauri.jsg.screen.util.GuiHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class Diode {
    public static final ResourceLocation DIODE_TEXTURE = new ResourceLocation("jsg", "textures/gui/diodes.png");
    private final Screen screen;
    private final int x;
    private final int y;
    private final String description;
    private final Map<DiodeStatus, String> statusStringMap;
    private DiodeStatus status;
    private StatusMapperInterface statusMapper;
    private StatusStringMapperInterface statusStringMapper;

    public Diode(Screen screen, int x, int y, String description) {
        this.screen = screen;
        this.x = x;
        this.y = y;
        this.description = description;
        this.statusStringMap = new HashMap<DiodeStatus, String>(3);
    }

    public Diode putStatus(DiodeStatus status, String statusString) {
        this.statusStringMap.put(status, statusString);
        return this;
    }

    public Diode setStatusMapper(StatusMapperInterface statusMapper) {
        this.statusMapper = statusMapper;
        return this;
    }

    public Diode setStatusStringMapper(StatusStringMapperInterface statusStringMapper) {
        this.statusStringMapper = statusStringMapper;
        return this;
    }

    public Diode setDiodeStatus(DiodeStatus status) {
        this.status = status;
        return this;
    }

    public boolean render(int mouseX, int mouseY) {
        this.status = this.statusMapper.get();
        RenderSystem.enableBlend();
        Texture.bindTextureWithMc(DIODE_TEXTURE);
        GuiHelper.drawModalRectWithCustomSizedTexture(this.x, this.y, this.status.xTex, this.status.yTex, 8, 7, 16.0f, 16.0f);
        RenderSystem.disableBlend();
        return GuiHelper.isPointInRegion(this.x, this.y, 8, 8, mouseX, mouseY);
    }

    public void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        String statusString = null;
        if (this.statusStringMapper != null) {
            statusString = this.statusStringMapper.get();
        }
        if (statusString == null) {
            statusString = this.statusStringMap.get((Object)this.status);
        }
        MutableComponent textComponent = Component.m_237113_((String)(String.valueOf(this.status.color) + String.valueOf(ChatFormatting.ITALIC) + statusString));
        graphics.m_280677_(Minecraft.m_91087_().f_91062_, List.of(Component.m_237113_((String)this.description), textComponent), Optional.empty(), mouseX, mouseY);
    }

    public static interface StatusMapperInterface {
        public DiodeStatus get();
    }

    public static interface StatusStringMapperInterface {
        @Nullable
        public String get();
    }

    public static enum DiodeStatus {
        OFF(0, 0, ChatFormatting.DARK_RED),
        WARN(8, 0, ChatFormatting.YELLOW),
        ON(0, 7, ChatFormatting.GREEN);

        public final int xTex;
        public final int yTex;
        public final ChatFormatting color;

        private DiodeStatus(int xTex, int yTex, ChatFormatting color) {
            this.xTex = xTex;
            this.yTex = yTex;
            this.color = color;
        }
    }
}

